/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.mule.runtime.core.api.scheduler.SchedulerBusyException;
import org.mule.service.scheduler.internal.executor.WaitPolicy;
import org.mule.service.scheduler.internal.threads.SchedulerThreadFactory;

public final class ByCallerThreadGroupPolicy
implements RejectedExecutionHandler {
    private final ThreadPoolExecutor.AbortPolicy abort = new ThreadPoolExecutor.AbortPolicy(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            throw new SchedulerBusyException("Task " + r.toString() + " rejected from " + executor.toString());
        }
    };
    private final WaitPolicy wait = new WaitPolicy();
    private final ThreadPoolExecutor.CallerRunsPolicy callerRuns = new ThreadPoolExecutor.CallerRunsPolicy();
    private final Set<ThreadGroup> waitGroups;
    private final ThreadGroup parentGroup;

    public ByCallerThreadGroupPolicy(Set<ThreadGroup> waitGroups, ThreadGroup parentGroup) {
        this.waitGroups = Collections.unmodifiableSet(waitGroups);
        this.parentGroup = parentGroup;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        ThreadGroup targetGroup = ((SchedulerThreadFactory)executor.getThreadFactory()).getGroup();
        ThreadGroup currentThreadGroup = Thread.currentThread().getThreadGroup();
        if (this.isWaitGroupThread(targetGroup) && targetGroup == currentThreadGroup) {
            this.callerRuns.rejectedExecution(r, executor);
        } else if (!this.isSchedulerThread(currentThreadGroup) || this.isWaitGroupThread(currentThreadGroup)) {
            this.wait.rejectedExecution(r, executor);
        } else {
            this.abort.rejectedExecution(r, executor);
        }
    }

    private boolean isWaitGroupThread(ThreadGroup threadGroup) {
        if (threadGroup != null) {
            while (threadGroup.getParent() != null) {
                if (this.waitGroups.contains(threadGroup)) {
                    return true;
                }
                threadGroup = threadGroup.getParent();
            }
        }
        return false;
    }

    private boolean isSchedulerThread(ThreadGroup threadGroup) {
        if (threadGroup != null) {
            while (threadGroup.getParent() != null) {
                if (threadGroup.equals(this.parentGroup)) {
                    return true;
                }
                threadGroup = threadGroup.getParent();
            }
        }
        return false;
    }
}

