/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.threads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.api.scheduler.SchedulerPoolsConfig;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.ThrottledScheduler;
import org.mule.service.scheduler.internal.executor.ByCallerThreadGroupPolicy;
import org.mule.service.scheduler.internal.threads.SchedulerThreadFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerThreadPools {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerThreadPools.class);
    private static final String CPU_LIGHT_THREADS_NAME = ThreadType.CPU_LIGHT.getName();
    private static final String IO_THREADS_NAME = ThreadType.IO.getName();
    private static final String COMPUTATION_THREADS_NAME = ThreadType.CPU_INTENSIVE.getName();
    private static final String TIMER_THREADS_NAME = "timer";
    private static final String CUSTOM_THREADS_NAME = ThreadType.CUSTOM.getName();
    private SchedulerPoolsConfig threadPoolsConfig;
    private final ThreadGroup schedulerGroup;
    private final ThreadGroup cpuLightGroup;
    private final ThreadGroup ioGroup;
    private final ThreadGroup computationGroup;
    private final ThreadGroup timerGroup;
    private final ThreadGroup customGroup;
    private final ThreadGroup customWaitGroup;
    private final RejectedExecutionHandler byCallerThreadGroupPolicy;
    private ThreadPoolExecutor cpuLightExecutor;
    private ThreadPoolExecutor ioExecutor;
    private ThreadPoolExecutor computationExecutor;
    private Set<ThreadPoolExecutor> customSchedulersExecutors = new HashSet<ThreadPoolExecutor>();
    private ScheduledThreadPoolExecutor scheduledExecutor;
    private Scheduler quartzScheduler;
    private List<org.mule.runtime.api.scheduler.Scheduler> activeSchedulers = Collections.synchronizedList(new ArrayList());

    public SchedulerThreadPools(String name, SchedulerPoolsConfig threadPoolsConfig) {
        this.threadPoolsConfig = threadPoolsConfig;
        this.schedulerGroup = new ThreadGroup(name);
        this.cpuLightGroup = new ThreadGroup(this.schedulerGroup, threadPoolsConfig.getThreadNamePrefix() + CPU_LIGHT_THREADS_NAME);
        this.ioGroup = new ThreadGroup(this.schedulerGroup, threadPoolsConfig.getThreadNamePrefix() + IO_THREADS_NAME);
        this.computationGroup = new ThreadGroup(this.schedulerGroup, threadPoolsConfig.getThreadNamePrefix() + COMPUTATION_THREADS_NAME);
        this.timerGroup = new ThreadGroup(this.schedulerGroup, threadPoolsConfig.getThreadNamePrefix() + TIMER_THREADS_NAME);
        this.customGroup = new ThreadGroup(this.schedulerGroup, threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME);
        this.customWaitGroup = new ThreadGroup(this.customGroup, threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME);
        this.byCallerThreadGroupPolicy = new ByCallerThreadGroupPolicy(new HashSet<ThreadGroup>(Arrays.asList(this.ioGroup, this.customWaitGroup)), this.schedulerGroup);
    }

    public void start() throws MuleException {
        this.cpuLightExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getCpuLightPoolSize().getAsInt(), this.threadPoolsConfig.getCpuLightPoolSize().getAsInt(), 0L, TimeUnit.SECONDS, this.createQueue(this.threadPoolsConfig.getCpuLightQueueSize().getAsInt()), new SchedulerThreadFactory(this.cpuLightGroup), this.byCallerThreadGroupPolicy);
        this.ioExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getIoCorePoolSize().getAsInt(), this.threadPoolsConfig.getIoMaxPoolSize().getAsInt(), this.threadPoolsConfig.getIoKeepAlive().getAsLong(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new SchedulerThreadFactory(this.ioGroup), this.byCallerThreadGroupPolicy);
        this.computationExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getCpuIntensivePoolSize().getAsInt(), this.threadPoolsConfig.getCpuIntensivePoolSize().getAsInt(), 0L, TimeUnit.SECONDS, this.createQueue(this.threadPoolsConfig.getCpuIntensiveQueueSize().getAsInt()), new SchedulerThreadFactory(this.computationGroup), this.byCallerThreadGroupPolicy);
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, new SchedulerThreadFactory(this.timerGroup, "%s"));
        this.scheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduledExecutor.setRemoveOnCancelPolicy(true);
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        try {
            schedulerFactory.initialize(this.defaultQuartzProperties());
            this.quartzScheduler = schedulerFactory.getScheduler();
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
        this.cpuLightExecutor.prestartAllCoreThreads();
        this.ioExecutor.prestartAllCoreThreads();
        this.computationExecutor.prestartAllCoreThreads();
        this.scheduledExecutor.prestartAllCoreThreads();
    }

    private BlockingQueue<Runnable> createQueue(int size) {
        return size == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(size);
    }

    private Properties defaultQuartzProperties() {
        Properties factoryProperties = new Properties();
        factoryProperties.setProperty("org.quartz.scheduler.instanceName", this.threadPoolsConfig.getThreadNamePrefix());
        factoryProperties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        factoryProperties.setProperty("org.quartz.threadPool.threadNamePrefix", this.threadPoolsConfig.getThreadNamePrefix() + "_qz");
        factoryProperties.setProperty("org.quartz.threadPool.threadCount", "1");
        return factoryProperties;
    }

    public void stop() throws MuleException, InterruptedException {
        this.cpuLightExecutor.shutdown();
        this.ioExecutor.shutdown();
        this.computationExecutor.shutdown();
        for (ThreadPoolExecutor customSchedulerExecutor : this.customSchedulersExecutors) {
            customSchedulerExecutor.shutdown();
        }
        this.scheduledExecutor.shutdown();
        try {
            this.quartzScheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
        long startMillis = System.currentTimeMillis();
        this.waitForExecutorTermination(startMillis, this.scheduledExecutor, this.threadPoolsConfig.getThreadNamePrefix() + TIMER_THREADS_NAME);
        this.waitForExecutorTermination(startMillis, this.cpuLightExecutor, this.threadPoolsConfig.getThreadNamePrefix() + CPU_LIGHT_THREADS_NAME);
        this.waitForExecutorTermination(startMillis, this.ioExecutor, this.threadPoolsConfig.getThreadNamePrefix() + IO_THREADS_NAME);
        this.waitForExecutorTermination(startMillis, this.computationExecutor, this.threadPoolsConfig.getThreadNamePrefix() + COMPUTATION_THREADS_NAME);
        for (ThreadPoolExecutor customSchedulerExecutor : new ArrayList<ThreadPoolExecutor>(this.customSchedulersExecutors)) {
            this.waitForExecutorTermination(startMillis, customSchedulerExecutor, ((SchedulerThreadFactory)customSchedulerExecutor.getThreadFactory()).getGroup().getName());
        }
        this.cpuLightExecutor = null;
        this.ioExecutor = null;
        this.computationExecutor = null;
        this.scheduledExecutor = null;
        this.quartzScheduler = null;
    }

    protected void waitForExecutorTermination(long startMillis, ExecutorService executor, String executorLabel) throws InterruptedException {
        if (!executor.awaitTermination(this.threadPoolsConfig.getGracefulShutdownTimeout().getAsLong() - (System.currentTimeMillis() - startMillis), TimeUnit.MILLISECONDS)) {
            List<Runnable> cancelledJobs = executor.shutdownNow();
            logger.warn("'" + executorLabel + "' " + executor.toString() + " did not shutdown gracefully after " + this.threadPoolsConfig.getGracefulShutdownTimeout() + " milliseconds.");
            if (logger.isDebugEnabled()) {
                logger.debug("The jobs " + cancelledJobs + " were cancelled.");
            } else {
                logger.info(cancelledJobs.size() + " jobs were cancelled.");
            }
        }
    }

    public org.mule.runtime.api.scheduler.Scheduler createCpuLightScheduler(SchedulerConfig config, int parallelTasksEstimate, Supplier<Long> stopTimeout) {
        this.validateWaitAllowedNotChanged(config);
        String schedulerName = this.resolveCpuLightSchedulerName(config);
        DefaultScheduler scheduler = this.shouldThrottle(config, this.threadPoolsConfig.getCpuLightPoolSize()) ? new ThrottledScheduler(schedulerName, this.cpuLightExecutor, parallelTasksEstimate, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_LIGHT, config.getMaxConcurrentTasks(), stopTimeout, this.shutdownCallback()) : new DefaultScheduler(schedulerName, this.cpuLightExecutor, parallelTasksEstimate, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_LIGHT, stopTimeout, this.shutdownCallback());
        this.activeSchedulers.add(scheduler);
        return scheduler;
    }

    public org.mule.runtime.api.scheduler.Scheduler createIoScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout) {
        this.validateWaitAllowedNotChanged(config);
        String schedulerName = this.resolveIoSchedulerName(config);
        DefaultScheduler scheduler = this.shouldThrottle(config, this.threadPoolsConfig.getIoMaxPoolSize()) ? new ThrottledScheduler(schedulerName, this.ioExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, config.getMaxConcurrentTasks(), stopTimeout, this.shutdownCallback()) : new DefaultScheduler(schedulerName, this.ioExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, stopTimeout, this.shutdownCallback());
        this.activeSchedulers.add(scheduler);
        return scheduler;
    }

    private Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback() {
        return schr -> this.activeSchedulers.remove(schr);
    }

    public org.mule.runtime.api.scheduler.Scheduler createCpuIntensiveScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout) {
        this.validateWaitAllowedNotChanged(config);
        String schedulerName = this.resolveComputationSchedulerName(config);
        DefaultScheduler scheduler = this.shouldThrottle(config, this.threadPoolsConfig.getCpuIntensivePoolSize()) ? new ThrottledScheduler(schedulerName, this.computationExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_INTENSIVE, config.getMaxConcurrentTasks(), stopTimeout, this.shutdownCallback()) : new DefaultScheduler(schedulerName, this.computationExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_INTENSIVE, stopTimeout, this.shutdownCallback());
        this.activeSchedulers.add(scheduler);
        return scheduler;
    }

    private void validateWaitAllowedNotChanged(SchedulerConfig config) {
        if (config.getWaitAllowed().isPresent()) {
            throw new IllegalArgumentException("Only custom schedulers may define 'waitAllowed' behaviour");
        }
    }

    private boolean shouldThrottle(SchedulerConfig config, OptionalInt backingPoolMaxSize) {
        return config.getMaxConcurrentTasks() != null && config.getMaxConcurrentTasks() < backingPoolMaxSize.orElse(Integer.MAX_VALUE);
    }

    public org.mule.runtime.api.scheduler.Scheduler createCustomScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout) {
        String threadsName = this.resolveCustomThreadsName(config);
        return this.doCreateCustomScheduler(config, workers, stopTimeout, this.resolveCustomSchedulerName(config), new SynchronousQueue<Runnable>(), threadsName);
    }

    public org.mule.runtime.api.scheduler.Scheduler createCustomScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout, int queueSize) {
        String threadsName = this.resolveCustomThreadsName(config);
        return this.doCreateCustomScheduler(config, workers, stopTimeout, this.resolveCustomSchedulerName(config), this.createQueue(queueSize), threadsName);
    }

    private org.mule.runtime.api.scheduler.Scheduler doCreateCustomScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout, String schedulerName, BlockingQueue<Runnable> workQueue, String threadsName) {
        if (config.getMaxConcurrentTasks() == null) {
            throw new IllegalArgumentException("Custom schedulers must define a thread pool size");
        }
        ThreadGroup customChildGroup = new ThreadGroup(this.resolveThreadGroupForCustomScheduler(config), this.threadPoolsConfig.getThreadNamePrefix() + "." + threadsName);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(config.getMaxConcurrentTasks(), config.getMaxConcurrentTasks(), 0L, TimeUnit.MILLISECONDS, workQueue, new SchedulerThreadFactory(customChildGroup, "%s." + threadsName + ".%02d"), this.byCallerThreadGroupPolicy);
        executor.prestartAllCoreThreads();
        CustomScheduler customScheduler = new CustomScheduler(schedulerName, executor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.CUSTOM, stopTimeout, this.shutdownCallback());
        this.customSchedulersExecutors.add(executor);
        this.activeSchedulers.add(customScheduler);
        return customScheduler;
    }

    private ThreadGroup resolveThreadGroupForCustomScheduler(SchedulerConfig config) {
        if (config.getWaitAllowed().orElse(false).booleanValue()) {
            return this.customWaitGroup;
        }
        return this.customGroup;
    }

    private String resolveCpuLightSchedulerName(SchedulerConfig config) {
        if (!config.hasName()) {
            config = config.withName(this.resolveSchedulerCreationLocation(CPU_LIGHT_THREADS_NAME));
        }
        return config.getSchedulerName();
    }

    private String resolveIoSchedulerName(SchedulerConfig config) {
        if (!config.hasName()) {
            config = config.withName(this.resolveSchedulerCreationLocation(IO_THREADS_NAME));
        }
        return config.getSchedulerName();
    }

    private String resolveComputationSchedulerName(SchedulerConfig config) {
        if (!config.hasName()) {
            config = config.withName(this.resolveSchedulerCreationLocation(COMPUTATION_THREADS_NAME));
        }
        return config.getSchedulerName();
    }

    private String resolveCustomSchedulerName(SchedulerConfig config) {
        if (!config.hasName()) {
            config = config.withName(this.resolveSchedulerCreationLocation(CUSTOM_THREADS_NAME));
        }
        return config.getSchedulerName();
    }

    private String resolveCustomThreadsName(SchedulerConfig config) {
        if (config.hasName()) {
            return config.getSchedulerName();
        }
        return this.threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME;
    }

    private String resolveSchedulerCreationLocation(String prefix) {
        int i = 0;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement ste = stackTrace[i++];
        while (this.skip(ste) && i < stackTrace.length) {
            ste = stackTrace[i++];
        }
        ste = this.skip(ste) ? stackTrace[3] : stackTrace[i];
        return prefix + "@" + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber();
    }

    private boolean skip(StackTraceElement ste) {
        return !ste.getClassName().contains("$Proxy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<org.mule.runtime.api.scheduler.Scheduler> getSchedulers() {
        List<org.mule.runtime.api.scheduler.Scheduler> list = this.activeSchedulers;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<org.mule.runtime.api.scheduler.Scheduler>(this.activeSchedulers));
        }
    }

    private class CustomScheduler
    extends DefaultScheduler {
        private final ExecutorService executor;

        private CustomScheduler(String name, ExecutorService executor, int workers, ScheduledExecutorService scheduledExecutor, Scheduler quartzScheduler, ThreadType threadsType, Supplier<Long> shutdownTimeoutMillis, Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback) {
            super(name, executor, workers, scheduledExecutor, quartzScheduler, threadsType, shutdownTimeoutMillis, shutdownCallback);
            this.executor = executor;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            this.executor.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            SchedulerThreadPools.this.customSchedulersExecutors.remove(this);
            List<Runnable> cancelledTasks = super.shutdownNow();
            this.executor.shutdownNow();
            return cancelledTasks;
        }
    }
}

