/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.quartz.Scheduler;

public class ThrottledScheduler
extends DefaultScheduler {
    private final int maxConcurrentTasks;
    private final AtomicInteger runningTasks = new AtomicInteger();

    public ThrottledScheduler(String name, ExecutorService executor, int parallelTasksEstimate, ScheduledExecutorService scheduledExecutor, Scheduler quartzScheduler, ThreadType threadsType, int maxConcurrentTasks, Supplier<Long> shutdownTimeoutMillis, Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback) {
        super(name, executor, parallelTasksEstimate, scheduledExecutor, quartzScheduler, threadsType, shutdownTimeoutMillis, shutdownCallback);
        this.maxConcurrentTasks = maxConcurrentTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putTask(RunnableFuture<?> task, ScheduledFuture<?> scheduledFuture) {
        try {
            AtomicInteger atomicInteger = this.runningTasks;
            synchronized (atomicInteger) {
                this.runningTasks.incrementAndGet();
                while (this.runningTasks.get() > this.maxConcurrentTasks) {
                    this.runningTasks.wait();
                }
            }
            super.putTask(task, scheduledFuture);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeTask(RunnableFuture<?> task) {
        super.removeTask(task);
        AtomicInteger atomicInteger = this.runningTasks;
        synchronized (atomicInteger) {
            this.runningTasks.decrementAndGet();
            this.runningTasks.notify();
        }
    }

    @Override
    public String toString() {
        return super.toString() + " (throttled: " + this.runningTasks.get() + "/" + this.maxConcurrentTasks + ")";
    }
}

