/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.service.scheduler.ThreadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerThreadPoolsConfig
implements SchedulerPoolsConfig {
    private static final Logger logger = LoggerFactory.getLogger(ContainerThreadPoolsConfig.class);
    public static final String SCHEDULER_POOLS_CONFIG_FILE_PROPERTY = "mule.schedulerPools.configFile";
    public static final String PROP_PREFIX = "org.mule.runtime.scheduler.";
    public static final String CPU_LIGHT_PREFIX = "org.mule.runtime.scheduler." + ThreadType.CPU_LIGHT.getName();
    public static final String IO_PREFIX = "org.mule.runtime.scheduler." + ThreadType.IO.getName();
    public static final String CPU_INTENSIVE_PREFIX = "org.mule.runtime.scheduler." + ThreadType.CPU_INTENSIVE.getName();
    public static final String THREAD_POOL = "threadPool";
    public static final String THREAD_POOL_SIZE = "threadPool.size";
    public static final String THREAD_POOL_SIZE_MAX = "threadPool.maxSize";
    public static final String THREAD_POOL_SIZE_CORE = "threadPool.coreSize";
    public static final String THREAD_POOL_KEEP_ALIVE = "threadPool.threadKeepAlive";
    public static final String WORK_QUEUE = "workQueue";
    public static final String WORK_QUEUE_SIZE = "workQueue.size";
    private static final String NUMBER_OR_VAR_REGEXP = "([0-9]+(\\.[0-9]+)?)|cores|mem";
    private static final String FORMULA_FUNCTION_PARAM = "(([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*";
    private static final Pattern POOLSIZE_PATTERN = Pattern.compile("^(([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*|max\\s*\\(\\s*((([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*)?\\s*,\\s*((([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*)?\\s*\\)|min\\s*\\(\\s*((([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*)?\\s*,\\s*((([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*)?\\s*\\)$");
    private static int cores = Runtime.getRuntime().availableProcessors();
    private static long mem = Runtime.getRuntime().maxMemory() / 1024L;
    private long gracefulShutdownTimeout = 15000L;
    private int cpuLightQueueSize = 0;
    private int cpuLightPoolSize = 2 * cores;
    private int ioQueueSize = 0;
    private int ioCorePoolSize = cores;
    private int ioMaxPoolSize = (int)Math.max(2L, (long)cores + (mem - 245760L) / 5120L);
    private long ioKeepAlive = 30000L;
    private int cpuIntensiveQueueSize = 1024;
    private int cpuIntensivePoolSize = 2 * cores;

    public static ContainerThreadPoolsConfig loadThreadPoolsConfig() throws MuleException {
        File muleHome;
        ContainerThreadPoolsConfig config = new ContainerThreadPoolsConfig();
        String overriddenConfigFileName = System.getProperty(SCHEDULER_POOLS_CONFIG_FILE_PROPERTY);
        if (overriddenConfigFileName != null) {
            File overriddenConfigFile = new File(overriddenConfigFileName);
            logger.info("Loading thread pools configuration from " + overriddenConfigFile.getPath());
            return ContainerThreadPoolsConfig.loadProperties(config, overriddenConfigFile);
        }
        File file = muleHome = System.getProperty("mule.home") != null ? new File(System.getProperty("mule.home")) : null;
        if (muleHome == null) {
            logger.info("No mule.home defined. Using default values for thread pools.");
            return config;
        }
        File defaultConfigFile = new File(muleHome, "conf" + File.separator + "scheduler-pools.conf");
        if (!defaultConfigFile.exists()) {
            logger.info("No thread pools config file found. Using default values.");
            return config;
        }
        logger.info("Loading thread pools configuration from " + defaultConfigFile.getPath());
        return ContainerThreadPoolsConfig.loadProperties(config, defaultConfigFile);
    }

    private static ContainerThreadPoolsConfig loadProperties(ContainerThreadPoolsConfig config, File configFile) throws DefaultMuleException, ConfigurationException, MuleException {
        Properties properties = new Properties();
        try (FileInputStream configIs = new FileInputStream(configFile);){
            properties.load(configIs);
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("js");
        if (engine == null) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"No 'js' script engine found. It is required to parse the config in 'conf/scheduler-pools.conf'"));
        }
        engine.put("cores", cores);
        engine.put("mem", mem);
        ContainerThreadPoolsConfig.resolveNumber(properties, "org.mule.runtime.scheduler.gracefulShutdownTimeout", true).ifPresent(v -> config.setGracefulShutdownTimeout(v));
        ContainerThreadPoolsConfig.resolveExpression(properties, CPU_LIGHT_PREFIX + "." + THREAD_POOL_SIZE, config, engine, false).ifPresent(v -> config.setCpuLightPoolSize(v));
        ContainerThreadPoolsConfig.resolveExpression(properties, CPU_LIGHT_PREFIX + "." + WORK_QUEUE_SIZE, config, engine, true).ifPresent(v -> config.setCpuLightQueueSize(v));
        ContainerThreadPoolsConfig.resolveExpression(properties, IO_PREFIX + "." + THREAD_POOL_SIZE_CORE, config, engine, false).ifPresent(v -> config.setIoCorePoolSize(v));
        ContainerThreadPoolsConfig.resolveExpression(properties, IO_PREFIX + "." + THREAD_POOL_SIZE_MAX, config, engine, false).ifPresent(v -> config.setIoMaxPoolSize(v));
        ContainerThreadPoolsConfig.resolveExpression(properties, IO_PREFIX + "." + WORK_QUEUE_SIZE, config, engine, true).ifPresent(v -> config.setIoQueueSize(v));
        ContainerThreadPoolsConfig.resolveNumber(properties, IO_PREFIX + "." + THREAD_POOL_KEEP_ALIVE, true).ifPresent(v -> config.setIoKeepAlive(v));
        ContainerThreadPoolsConfig.resolveExpression(properties, CPU_INTENSIVE_PREFIX + "." + THREAD_POOL_SIZE, config, engine, false).ifPresent(v -> config.setCpuIntensivePoolSize(v));
        ContainerThreadPoolsConfig.resolveExpression(properties, CPU_INTENSIVE_PREFIX + "." + WORK_QUEUE_SIZE, config, engine, true).ifPresent(v -> config.setCpuIntensiveQueueSize(v));
        return config;
    }

    private static OptionalLong resolveNumber(Properties properties, String propName, boolean allowZero) throws MuleException {
        if (!properties.containsKey(propName)) {
            logger.warn("No property '{}' found in config file. Using default value.", (Object)propName);
            return OptionalLong.empty();
        }
        String property = properties.getProperty(propName);
        try {
            long result = Long.parseLong(property);
            ContainerThreadPoolsConfig.validateNumber(propName, result, allowZero);
            return OptionalLong.of(result);
        }
        catch (NumberFormatException e) {
            throw new DefaultMuleException(propName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static OptionalInt resolveExpression(Properties properties, String propName, ContainerThreadPoolsConfig threadPoolsConfig, ScriptEngine engine, boolean allowZero) throws MuleException {
        if (!properties.containsKey(propName)) {
            logger.warn("No property '{}' found in config file. Using default value.", (Object)propName);
            return OptionalInt.empty();
        }
        String property = properties.getProperty(propName).trim().toLowerCase();
        if (!POOLSIZE_PATTERN.matcher(property).matches()) {
            throw new DefaultMuleException(propName + ": Expression not valid");
        }
        property = property.replaceAll("(max|min)", "Math.$1");
        try {
            int result = ((Number)engine.eval(property)).intValue();
            ContainerThreadPoolsConfig.validateNumber(propName, result, allowZero);
            return OptionalInt.of(result);
        }
        catch (ScriptException e) {
            throw new DefaultMuleException(propName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static void validateNumber(String propName, long result, boolean allowZero) throws MuleException {
        if (allowZero) {
            if (result < 0L) {
                throw new DefaultMuleException(propName + ": Value has to be greater than or equal to 0");
            }
        } else if (result <= 0L) {
            throw new DefaultMuleException(propName + ": Value has to be greater than 0");
        }
    }

    private ContainerThreadPoolsConfig() {
    }

    public OptionalLong getGracefulShutdownTimeout() {
        return OptionalLong.of(this.gracefulShutdownTimeout);
    }

    private void setGracefulShutdownTimeout(long gracefulShutdownTimeout) {
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
    }

    public OptionalInt getCpuLightPoolSize() {
        return OptionalInt.of(this.cpuLightPoolSize);
    }

    private void setCpuLightPoolSize(int cpuLightPoolSize) {
        this.cpuLightPoolSize = cpuLightPoolSize;
    }

    public OptionalInt getCpuLightQueueSize() {
        return OptionalInt.of(this.cpuLightQueueSize);
    }

    private void setCpuLightQueueSize(int cpuLightQueueSize) {
        this.cpuLightQueueSize = cpuLightQueueSize;
    }

    public OptionalInt getIoCorePoolSize() {
        return OptionalInt.of(this.ioCorePoolSize);
    }

    private void setIoCorePoolSize(int ioCorePoolSize) {
        this.ioCorePoolSize = ioCorePoolSize;
    }

    public OptionalInt getIoMaxPoolSize() {
        return OptionalInt.of(Math.max(this.ioCorePoolSize, this.ioMaxPoolSize));
    }

    private void setIoMaxPoolSize(int ioMaxPoolSize) {
        this.ioMaxPoolSize = ioMaxPoolSize;
    }

    public OptionalInt getIoQueueSize() {
        return OptionalInt.of(this.ioQueueSize);
    }

    private void setIoQueueSize(int ioQueueSize) {
        this.ioQueueSize = ioQueueSize;
    }

    public OptionalLong getIoKeepAlive() {
        return OptionalLong.of(this.ioKeepAlive);
    }

    private void setIoKeepAlive(long ioKeepAlive) {
        this.ioKeepAlive = ioKeepAlive;
    }

    public OptionalInt getCpuIntensivePoolSize() {
        return OptionalInt.of(this.cpuIntensivePoolSize);
    }

    private void setCpuIntensivePoolSize(int cpuIntensivePoolSize) {
        this.cpuIntensivePoolSize = cpuIntensivePoolSize;
    }

    public OptionalInt getCpuIntensiveQueueSize() {
        return OptionalInt.of(this.cpuIntensiveQueueSize);
    }

    private void setCpuIntensiveQueueSize(int cpuIntensiveQueueSize) {
        this.cpuIntensiveQueueSize = cpuIntensiveQueueSize;
    }

    public String getThreadNamePrefix() {
        return "[MuleRuntime].";
    }
}

