/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.junit.Test;
import org.mule.service.scheduler.internal.AbstractMuleVsJavaExecutorTestCase;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Feature(value="Scheduler Service")
@Story(value="Task Scheduling")
public class ReactorSchedulersTestCase
extends AbstractMuleVsJavaExecutorTestCase {
    public ReactorSchedulersTestCase(Function<AbstractMuleVsJavaExecutorTestCase, ScheduledExecutorService> executorFactory, BlockingQueue<Runnable> sharedExecutorQueue, String param) {
        super(executorFactory, sharedExecutorQueue, param);
    }

    @Test
    @Description(value="Tests that timeout tasks scheduled and cancelled by reactor are not kept referenced in the scheduler")
    public void monoWithTimeout() {
        AtomicBoolean consumed = new AtomicBoolean(false);
        Mono.just((Object)"D'oh!").timeout(Duration.ofMillis(1000L), Mono.just((Object)"timeout"), Schedulers.fromExecutor((Executor)this.executor)).subscribe(s -> {
            consumed.set(true);
            Assert.assertThat((Object)s, (Matcher)Matchers.is((Object)"D'oh!"));
        });
        Assert.assertThat((Object)consumed.get(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(this.executor.shutdownNow(), (Matcher)IsEmptyCollection.empty());
    }
}

