/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Feature(value="Scheduler Service")
@Story(value="Shutdown")
public class DefaultSchedulerShutdownTestCase
extends BaseDefaultSchedulerTestCase {
    private ScheduledExecutorService executor;
    private ScheduledExecutorService otherExecutor;

    @Override
    public void before() throws Exception {
        super.before();
        this.executor = this.createExecutor();
        this.otherExecutor = this.createExecutor();
    }

    @Override
    public void after() throws Exception {
        this.executor.shutdownNow();
        this.otherExecutor.shutdownNow();
        this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        this.otherExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        super.after();
    }

    @Test
    @Description(value="Tests that calling shutdown() on a Scheduler while it's running a task waits for it to finish before terminating")
    public void shutdownWhileRunningTasksFromDifferentSources() throws InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(1);
        Future<Boolean> result1 = this.executor.submit(() -> this.awaitLatch(latch));
        Future<Boolean> result2 = this.otherExecutor.submit(() -> this.awaitLatch(latch));
        this.otherExecutor.shutdown();
        latch.countDown();
        MatcherAssert.assertThat((Object)result1.get(1L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)result2.get(1L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="Tests that calling shutdownNow() on a Scheduler with a queued task cancels that task")
    public void shutdownNowWhileRunningTasksFromDifferentSources() throws InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(1);
        Future<Boolean> result1 = this.executor.submit(() -> this.awaitLatch(latch));
        Runnable task2 = () -> this.awaitLatch(latch);
        this.otherExecutor.submit(task2);
        List<Runnable> notStartedTasks = this.otherExecutor.shutdownNow();
        latch.countDown();
        MatcherAssert.assertThat((Object)result1.get(1L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(notStartedTasks, (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    @Description(value="Tests that a task submitted to a Scheduler after calling shutdown() is rejected")
    public void submitAfterShutdownSameExecutor() throws InterruptedException, ExecutionException {
        this.executor.shutdown();
        this.assertRejected(this.executor, SUBMIT_EMPTY_RUNNABLE);
    }

    @Test
    @Description(value="Tests that a task submitted to a Scheduler after calling shutdown() on another Scheduler is NOT rejected")
    public void submitAfterShutdownOtherExecutor() throws InterruptedException, ExecutionException, TimeoutException {
        this.executor.shutdown();
        CountDownLatch latch = new CountDownLatch(1);
        Future<Boolean> result = this.otherExecutor.submit(() -> this.awaitLatch(latch));
        latch.countDown();
        MatcherAssert.assertThat((Object)result.get(1L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="Tests that a task submitted to a Scheduler after calling shutdownNow() is rejected")
    public void submitAfterShutdownNowSameExecutor() throws InterruptedException, ExecutionException {
        List<Runnable> notStartedTasks = this.executor.shutdownNow();
        MatcherAssert.assertThat(notStartedTasks, (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
        this.assertRejected(this.executor, SUBMIT_EMPTY_RUNNABLE);
    }

    @Test
    @Description(value="Tests that a task submitted to a Scheduler after calling shutdownNow() on another Scheduler is NOT rejected")
    public void submitAfterShutdownNowOtherExecutor() throws InterruptedException, ExecutionException, TimeoutException {
        this.executor.shutdownNow();
        CountDownLatch latch = new CountDownLatch(1);
        Future<Boolean> result = this.otherExecutor.submit(() -> this.awaitLatch(latch));
        latch.countDown();
        MatcherAssert.assertThat((Object)result.get(1L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Description(value="Tests that a task submitted to a Scheduler after the service is stopped is rejected")
    public void submitAfterShutdownSharedExecutor() throws InterruptedException, ExecutionException {
        this.sharedExecutor.shutdown();
        this.assertRejected(this.executor, SUBMIT_EMPTY_RUNNABLE);
    }

    @Test
    @Description(value="Tests that a task submitted to a Scheduler after the service is force-stopped is rejected")
    public void submitAfterShutdownNowSharedExecutor() throws InterruptedException, ExecutionException {
        List<Runnable> notStartedTasks = this.sharedExecutor.shutdownNow();
        MatcherAssert.assertThat(notStartedTasks, (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
        this.assertRejected(this.executor, SUBMIT_EMPTY_RUNNABLE);
    }

    @Test
    @Description(value="Tests that a running task is interrupted when shutdownNow() is called")
    public void shutdownNowInterruptsTask() throws InterruptedException, ExecutionException {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch triggeredLatch = new CountDownLatch(1);
        CountDownLatch interruptionLatch = new CountDownLatch(1);
        Future<Boolean> result = this.executor.submit(() -> {
            triggeredLatch.countDown();
            boolean awaited = false;
            try {
                awaited = this.awaitLatch(latch);
                return awaited;
            }
            finally {
                MatcherAssert.assertThat((Object)Thread.interrupted(), (Matcher)CoreMatchers.is((Object)true));
                interruptionLatch.countDown();
                return awaited;
            }
        });
        triggeredLatch.await(60L, TimeUnit.SECONDS);
        List<Runnable> notStartedTasks = this.executor.shutdownNow();
        interruptionLatch.await(60L, TimeUnit.SECONDS);
        MatcherAssert.assertThat(notStartedTasks, (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
        MatcherAssert.assertThat((Object)result.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Tests that a fixed-rate task stops running when shutdown() is called")
    public void shutdownCancelsFixedRateTasks() throws InterruptedException, ExecutionException {
        int runCountBeforeShutdown;
        AtomicInteger runCount = new AtomicInteger();
        this.executor.scheduleAtFixedRate(() -> {
            AtomicInteger atomicInteger = runCount;
            synchronized (atomicInteger) {
                runCount.incrementAndGet();
            }
        }, 0L, 1L, TimeUnit.MILLISECONDS);
        AtomicInteger atomicInteger = runCount;
        synchronized (atomicInteger) {
            runCountBeforeShutdown = runCount.get();
            this.executor.shutdown();
        }
        Thread.sleep(50L);
        MatcherAssert.assertThat((Object)runCount.get(), (Matcher)CoreMatchers.is((Object)runCountBeforeShutdown));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Tests that a fixed-delay task stops running when shutdown() is called")
    public void shutdownCancelsFixedDelayTasks() throws InterruptedException, ExecutionException {
        int runCountBeforeShutdown;
        AtomicInteger runCount = new AtomicInteger();
        this.executor.scheduleWithFixedDelay(() -> {
            AtomicInteger atomicInteger = runCount;
            synchronized (atomicInteger) {
                runCount.incrementAndGet();
            }
        }, 0L, 1L, TimeUnit.MILLISECONDS);
        AtomicInteger atomicInteger = runCount;
        synchronized (atomicInteger) {
            runCountBeforeShutdown = runCount.get();
            this.executor.shutdown();
        }
        Thread.sleep(50L);
        MatcherAssert.assertThat((Object)runCount.get(), (Matcher)CoreMatchers.is((Object)runCountBeforeShutdown));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Tests that a fixed-rate task stops running when shutdownNow() is called")
    public void shutdownNowCancelsFixedRateTasks() throws InterruptedException, ExecutionException {
        int runCountBeforeShutdown;
        AtomicInteger runCount = new AtomicInteger();
        this.executor.scheduleAtFixedRate(() -> {
            AtomicInteger atomicInteger = runCount;
            synchronized (atomicInteger) {
                runCount.incrementAndGet();
            }
        }, 0L, 1L, TimeUnit.MILLISECONDS);
        AtomicInteger atomicInteger = runCount;
        synchronized (atomicInteger) {
            runCountBeforeShutdown = runCount.get();
            this.executor.shutdownNow();
        }
        Thread.sleep(50L);
        MatcherAssert.assertThat((Object)runCount.get(), (Matcher)CoreMatchers.is((Object)runCountBeforeShutdown));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Tests that a fixed-delay task stops running when shutdownNow() is called")
    public void shutdownNowCancelsFixedDelayTasks() throws InterruptedException, ExecutionException {
        int runCountBeforeShutdown;
        AtomicInteger runCount = new AtomicInteger();
        this.executor.scheduleWithFixedDelay(() -> {
            AtomicInteger atomicInteger = runCount;
            synchronized (atomicInteger) {
                runCount.incrementAndGet();
            }
        }, 0L, 1L, TimeUnit.MILLISECONDS);
        AtomicInteger atomicInteger = runCount;
        synchronized (atomicInteger) {
            runCountBeforeShutdown = runCount.get();
            this.executor.shutdownNow();
        }
        Thread.sleep(50L);
        MatcherAssert.assertThat((Object)runCount.get(), (Matcher)CoreMatchers.is((Object)runCountBeforeShutdown));
    }

    @Test
    @Description(value="Tests that when a Scheduler with a fixed-delay task is shutdown, is stops rescheduling the task to a terminated executor")
    public void shutdownStopsReschedulingFixedDelayTasks() throws InterruptedException, ExecutionException {
        Latch latch = new Latch();
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, 0L, 1L, TimeUnit.MILLISECONDS);
        new PollingProber(100L, 2L).check((Probe)new JUnitLambdaProbe(() -> {
            ((ScheduledThreadPoolExecutor)Mockito.verify((Object)this.sharedScheduledExecutor)).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)((Object)ArgumentMatchers.any())));
            return true;
        }));
        Mockito.reset((Object[])new ScheduledThreadPoolExecutor[]{this.sharedScheduledExecutor});
        this.executor.shutdown();
        latch.countDown();
        Thread.sleep(50L);
        ((ScheduledThreadPoolExecutor)Mockito.verify((Object)this.sharedScheduledExecutor, (VerificationMode)Mockito.never())).schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()));
    }

    @Test
    @Issue(value="MULE-18884")
    public void shutdownFromWithinSchedulerTaskDoesntWait() {
        Future<?> stopFuture = this.executor.submit(() -> ((Scheduler)this.executor).stop());
        PollingProber.probe((long)1000L, (long)10L, () -> stopFuture.isDone() && this.executor.isTerminated());
    }

    protected void assertRejected(ScheduledExecutorService executor, Consumer<ScheduledExecutorService> submitEmptyRunnable) {
        RejectedExecutionException thrown = (RejectedExecutionException)Assertions.assertThrows(RejectedExecutionException.class, () -> submitEmptyRunnable.accept(executor));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.is((Object)(executor.toString() + " already shutdown")));
    }
}

