/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Feature;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.mockito.Mockito;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.service.scheduler.internal.SchedulerServiceContractTestCase;

@Feature(value="Scheduler Service")
public class DefaultSchedulerServiceTestCase
extends SchedulerServiceContractTestCase {
    @Override
    protected String getCpuLightPrefix() {
        return "CPU_LIGHT - cpuLight";
    }

    @Override
    protected boolean areCpuLightTasksInWaitGroup() {
        return false;
    }

    @Override
    protected boolean areIoTasksInWaitGroup() {
        return true;
    }

    @Override
    protected boolean areCpuLightTasksInCpuWorkGroup() {
        return true;
    }

    @Override
    protected boolean areIoTasksInCpuWorkGroup() {
        return false;
    }

    @Override
    protected String getSplashMessage() {
        return "cpuLight.threadPool.size:      " + this.config.getCpuLightPoolSize().getAsInt() + System.lineSeparator() + "cpuLight.workQueue.size:       " + this.config.getCpuLightQueueSize().getAsInt() + System.lineSeparator() + "io.threadPool.maxSize:         " + this.config.getIoMaxPoolSize().getAsInt() + System.lineSeparator() + "io.threadPool.threadKeepAlive: " + this.config.getIoKeepAlive().getAsLong() + " ms" + System.lineSeparator() + "cpuIntensive.threadPool.size:  " + this.config.getCpuIntensivePoolSize().getAsInt() + System.lineSeparator() + "cpuIntensive.workQueue.size:   " + this.config.getCpuIntensiveQueueSize().getAsInt() + System.lineSeparator();
    }

    @Override
    protected void configure(SchedulerPoolsConfig config) {
        Mockito.when((Object)config.getSchedulerPoolStrategy()).thenReturn((Object)SchedulerPoolStrategy.DEDICATED);
        Mockito.when((Object)config.getCpuLightPoolSize()).thenReturn((Object)OptionalInt.of(1));
        Mockito.when((Object)config.getCpuLightQueueSize()).thenReturn((Object)OptionalInt.of(1));
        Mockito.when((Object)config.getCpuIntensiveQueueSize()).thenReturn((Object)OptionalInt.of(1));
        Mockito.when((Object)config.getIoCorePoolSize()).thenReturn((Object)OptionalInt.of(1));
        Mockito.when((Object)config.getIoMaxPoolSize()).thenReturn((Object)OptionalInt.of(1));
        Mockito.when((Object)config.getIoQueueSize()).thenReturn((Object)OptionalInt.of(0));
        Mockito.when((Object)config.getIoKeepAlive()).thenReturn((Object)OptionalLong.of(30000L));
        Mockito.when((Object)config.getCpuIntensivePoolSize()).thenReturn((Object)OptionalInt.of(1));
        Mockito.when((Object)config.getCpuIntensiveQueueSize()).thenReturn((Object)OptionalInt.of(1));
    }
}

