/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.service.scheduler.internal.AbstractMuleExecutorTestCase;

@Feature(value="Scheduler Service")
@Story(value="Task Scheduling")
public class MuleDefaultSchedulerTestCase
extends AbstractMuleExecutorTestCase {
    public MuleDefaultSchedulerTestCase(Function<AbstractMuleExecutorTestCase, ScheduledExecutorService> executorFactory, String param) {
        super(executorFactory, param);
    }

    @Test
    @Issue(value="W-18347237")
    @Description(value="Tests that a task with zero delay is executed immediately.")
    public void scheduleWithZeroDelay() throws InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch taskLatch = new CountDownLatch(1);
        long startTime = System.nanoTime();
        ScheduledFuture<?> scheduled = this.executor.schedule(() -> {
            latch.countDown();
            this.awaitLatch(taskLatch);
        }, 0L, TimeUnit.NANOSECONDS);
        MatcherAssert.assertThat((Object)latch.await(1L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)(System.nanoTime() - startTime), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(TimeUnit.SECONDS.toNanos(1L))));
        taskLatch.countDown();
        MatcherAssert.assertThat(scheduled.get(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat(scheduled.get(1L, TimeUnit.SECONDS), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)scheduled.isDone(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)scheduled.getDelay(TimeUnit.NANOSECONDS), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    @Issue(value="W-18347237")
    @Description(value="Tests that a task with maximum delay is cancelled.")
    public void scheduleWithMaxDelay() {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> scheduled = this.executor.schedule(() -> latch.countDown(), Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        MatcherAssert.assertThat((Object)scheduled.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)scheduled.isDone(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)latch.getCount(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    @Description(value="Tests that the compareTo method orders tasks by their delay correctly")
    public void compareToOrdersTasksByDelay() {
        ScheduledFuture<?> longDelay;
        ScheduledFuture<?> shortDelay = this.executor.schedule(() -> {}, 10L, TimeUnit.NANOSECONDS);
        MatcherAssert.assertThat((Object)(shortDelay.compareTo(longDelay = this.executor.schedule(() -> {}, 100L, TimeUnit.NANOSECONDS)) < 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)(longDelay.compareTo(shortDelay) > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }
}

