/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.hamcrest.number.IsCloseTo;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.alert.TimedDataAggregation;
import org.mule.service.scheduler.internal.AbstractMuleVsJavaExecutorTestCase;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.reporting.ReportableScheduler;

@Feature(value="Scheduler Service")
@Story(value="Task Scheduling")
public class DefaultSchedulerScheduleTestCase
extends AbstractMuleVsJavaExecutorTestCase {
    private static final long TASK_DURATION_MILLIS = 200L;
    private static final long TEST_DELAY_MILLIS = 1000L;

    public DefaultSchedulerScheduleTestCase(Function<AbstractMuleVsJavaExecutorTestCase, ScheduledExecutorService> executorFactory, BlockingQueue<Runnable> sharedExecutorQueue, String param) {
        super(executorFactory, sharedExecutorQueue, param);
    }

    @Test
    @Description(value="Tests scheduling a Runnable in the future")
    public void scheduleRunnable() throws InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        long scheduleNanos = System.nanoTime();
        ScheduledFuture<?> scheduled = this.executor.schedule(() -> {
            latch2.countDown();
            this.awaitLatch(latch1);
        }, 1L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)latch2.await(2L, TimeUnit.SECONDS), (Matcher)Is.is((Object)true));
        latch1.countDown();
        scheduled.get(2L, TimeUnit.SECONDS);
        long finishNanos = System.nanoTime();
        MatcherAssert.assertThat((Object)(finishNanos - scheduleNanos), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toNanos(1L))));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that calling get on a ScheduledFuture with a time lower than the duration of the Runnable task throws a TimeoutException")
    public void scheduleRunnableGetTimeout() throws InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch1 = new CountDownLatch(1);
        ScheduledFuture<?> scheduled = this.executor.schedule(() -> this.awaitLatch(latch1), 1L, TimeUnit.SECONDS);
        Assertions.assertThrows(TimeoutException.class, () -> scheduled.get(1L, TimeUnit.SECONDS));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests scheduling a Callable in the future")
    public void scheduleCallable() throws InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        long scheduleNanos = System.nanoTime();
        ScheduledFuture<Boolean> scheduled = this.executor.schedule(() -> {
            latch2.countDown();
            return this.awaitLatch(latch1);
        }, 1L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)latch2.await(2L, TimeUnit.SECONDS), (Matcher)Is.is((Object)true));
        latch1.countDown();
        scheduled.get(2L, TimeUnit.SECONDS);
        long finishNanos = System.nanoTime();
        MatcherAssert.assertThat((Object)(finishNanos - scheduleNanos), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toNanos(1L))));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that calling get on a ScheduledFuture with a time lower than the duration of the Callable task throws a TimeoutException")
    public void scheduleCallableGetTimeout() throws InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch1 = new CountDownLatch(1);
        ScheduledFuture<Boolean> scheduled = this.executor.schedule(() -> this.awaitLatch(latch1), 1L, TimeUnit.SECONDS);
        Assertions.assertThrows(TimeoutException.class, () -> scheduled.get(1L, TimeUnit.SECONDS));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that calling shutdown() on a Scheduler with a Runnable scheduled in the future will wait for that task to finish")
    public void scheduleRunnableShutdownBeforeFire() throws InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        long scheduleNanos = System.nanoTime();
        ScheduledFuture<?> scheduled = this.executor.schedule(() -> {
            MatcherAssert.assertThat((Object)this.executor.isShutdown(), (Matcher)Is.is((Object)true));
            latch2.countDown();
            this.awaitLatch(latch1);
        }, 1L, TimeUnit.SECONDS);
        this.executor.shutdown();
        MatcherAssert.assertThat((Object)latch2.await(2L, TimeUnit.SECONDS), (Matcher)Is.is((Object)true));
        latch1.countDown();
        scheduled.get(2L, TimeUnit.SECONDS);
        long finishNanos = System.nanoTime();
        MatcherAssert.assertThat((Object)(finishNanos - scheduleNanos), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toNanos(1L))));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that calling shutdown() on a Scheduler with a Callable scheduled in the future will wait for that task to finish")
    public void scheduleCallableShutdownBeforeFire() throws InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        long scheduleNanos = System.nanoTime();
        ScheduledFuture<Boolean> scheduled = this.executor.schedule(() -> {
            MatcherAssert.assertThat((Object)this.executor.isShutdown(), (Matcher)Is.is((Object)true));
            latch2.countDown();
            return this.awaitLatch(latch1);
        }, 1L, TimeUnit.SECONDS);
        this.executor.shutdown();
        MatcherAssert.assertThat((Object)latch2.await(2L, TimeUnit.SECONDS), (Matcher)Is.is((Object)true));
        latch1.countDown();
        scheduled.get(2L, TimeUnit.SECONDS);
        long finishNanos = System.nanoTime();
        MatcherAssert.assertThat((Object)(finishNanos - scheduleNanos), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toNanos(1L))));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that calling shutdownNow() on a Scheduler with a Runnable scheduled in the future will cancel that task")
    public void scheduleRunnableShutdownNowBeforeFire() throws InterruptedException, ExecutionException, TimeoutException {
        this.executor.schedule(() -> Assert.fail((String)"Called after shutdown"), 1000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat(this.executor.shutdownNow(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that calling shutdownNow() on a Scheduler with a Callable scheduled in the future will cancel that task")
    public void scheduleCallableShutdownNowBeforeFire() throws InterruptedException, ExecutionException, TimeoutException {
        this.executor.schedule(() -> Assert.fail((String)"Called after shutdown"), 1L, TimeUnit.SECONDS);
        MatcherAssert.assertThat(this.executor.shutdownNow(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture is properly cancelled for a one-shot Runnable before it starts executing")
    public void cancelRunnableBeforeFire() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> scheduled = this.executor.schedule(() -> this.awaitLatch(latch), 60L, TimeUnit.SECONDS);
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed(this.executor);
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture is properly cancelled for a one-shot Runnable while it's executing")
    public void cancelRunnableWhileRunning() throws InterruptedException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ScheduledFuture<?> scheduled = this.executor.schedule(() -> {
            latch1.countDown();
            this.awaitLatch(latch2);
        }, 1L, TimeUnit.SECONDS);
        latch1.await();
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed(this.executor);
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that a delayed task is eventually triggered if at the original trigger time the target scheduler was busy")
    public void scheduleWhileBusy() throws InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        try {
            for (int i = 0; i < 20; ++i) {
                this.executor.execute(() -> {
                    try {
                        latch1.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.executor.schedule(() -> latch2.countDown(), 1L, TimeUnit.SECONDS);
        Thread.sleep(2000L);
        latch1.countDown();
        MatcherAssert.assertThat((Object)latch2.await(5L, TimeUnit.SECONDS), (Matcher)Is.is((Object)true));
        this.assertRejections();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture is properly cancelled for a one-shot Callable before it starts executing")
    public void cancelCallableBeforeFire() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<Boolean> scheduled = this.executor.schedule(() -> this.awaitLatch(latch), 60L, TimeUnit.SECONDS);
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed(this.executor);
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture is properly cancelled for a one-shot Callable while it's executing")
    public void cancelCallableWhileRunning() throws InterruptedException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ScheduledFuture<Boolean> scheduled = this.executor.schedule(() -> {
            latch1.countDown();
            return this.awaitLatch(latch2);
        }, 1000L, TimeUnit.MILLISECONDS);
        latch1.await();
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed(this.executor);
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture is properly cancelled for a fixed-rate Callable before it starts executing")
    public void cancelFixedRateBeforeFire() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> scheduled = this.executor.scheduleAtFixedRate(() -> this.awaitLatch(latch), TimeUnit.SECONDS.toMillis(60L), 10000L, TimeUnit.MILLISECONDS);
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed(this.executor);
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture is properly cancelled for a fixed-rate Callable while it's executing")
    public void cancelFixedRateWhileRunning() throws InterruptedException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ScheduledFuture<?> scheduled = this.executor.scheduleAtFixedRate(() -> {
            latch1.countDown();
            this.awaitLatch(latch2);
        }, 1000L, 10000L, TimeUnit.MILLISECONDS);
        latch1.await();
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed(this.executor);
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture is properly cancelled for a fixed-rate Callable in-between executions")
    public void cancelFixedRateInBetweenRuns() throws InterruptedException, ExecutionException {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> scheduled = this.executor.scheduleAtFixedRate(() -> this.sharedScheduledExecutor.schedule(() -> latch.countDown(), 0L, TimeUnit.SECONDS), 1000L, 10000L, TimeUnit.MILLISECONDS);
        latch.await();
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed(this.executor);
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture is properly cancelled for a fixed-delay Callable before it starts executing")
    public void cancelFixedDelayBeforeFire() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> scheduled = this.executor.scheduleWithFixedDelay(() -> this.awaitLatch(latch), 60L, 10000L, TimeUnit.MILLISECONDS);
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed(this.executor);
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture is properly cancelled for a fixed-delay Callable while it's executing")
    public void cancelFixedDelayWhileRunning() throws InterruptedException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ScheduledFuture<?> scheduled = this.executor.scheduleWithFixedDelay(() -> {
            latch1.countDown();
            this.awaitLatch(latch2);
        }, 1000L, 10000L, TimeUnit.MILLISECONDS);
        latch1.await();
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed(this.executor);
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture is properly cancelled for a fixed-delay Callable in-between executions")
    public void cancelFixedDelayInBetweenRuns() throws InterruptedException, ExecutionException {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<?> scheduled = this.executor.scheduleWithFixedDelay(() -> this.sharedScheduledExecutor.schedule(() -> latch.countDown(), 0L, TimeUnit.SECONDS), 0L, 60L, TimeUnit.SECONDS);
        latch.await();
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed(this.executor);
        this.assertNoRejections();
    }

    private void assertCancelled(ScheduledFuture<?> scheduled) {
        MatcherAssert.assertThat((Object)scheduled.isCancelled(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)scheduled.isDone(), (Matcher)Is.is((Object)true));
    }

    @Test
    @Description(value="Tests that shutdownNow after cancelling a running ScheduledFuture before being fired returns the cancelled task")
    public void shutdownNowAfterCancelCallableBeforeFire() {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture<Boolean> scheduled = this.executor.schedule(() -> this.awaitLatch(latch), 60L, TimeUnit.SECONDS);
        scheduled.cancel(true);
        List<Runnable> notStartedTasks = this.executor.shutdownNow();
        MatcherAssert.assertThat(notStartedTasks, (Matcher)IsCollectionWithSize.hasSize((int)0));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that shutdownNow after cancelling a running ScheduledFuture after being fired at least once doesn't return the cancelled task")
    public void shutdownNowAfterCancelCallableAfterFire() throws Exception {
        ScheduledFuture<Boolean> scheduled = this.executor.schedule(() -> true, 0L, TimeUnit.SECONDS);
        scheduled.get(1L, TimeUnit.SECONDS);
        scheduled.cancel(true);
        List<Runnable> notStartedTasks = this.executor.shutdownNow();
        MatcherAssert.assertThat(notStartedTasks, (Matcher)IsCollectionWithSize.hasSize((int)0));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that shutdownNow after cancelling a running ScheduledFuture returns the cancelled task")
    public void shutdownNowAfterCancelCallableWhileRunning() throws InterruptedException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ScheduledFuture<Boolean> scheduled = this.executor.schedule(() -> {
            latch1.countDown();
            return this.awaitLatch(latch2);
        }, 1000L, TimeUnit.MILLISECONDS);
        latch1.await();
        scheduled.cancel(true);
        this.executor.shutdownNow();
        List<Runnable> notStartedTasks = this.executor.shutdownNow();
        MatcherAssert.assertThat(notStartedTasks, (Matcher)Is.is((Matcher)IsEmptyCollection.empty()));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that scheduleAtFixedRate parameters are honored")
    public void fixedRateRepeats() {
        ArrayList startTimes = new ArrayList();
        ArrayList endTimes = new ArrayList();
        CountDownLatch latch = new CountDownLatch(2);
        ScheduledFuture<?> scheduled = this.executor.scheduleAtFixedRate(() -> {
            startTimes.add(System.nanoTime());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            latch.countDown();
            endTimes.add(System.nanoTime());
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)this.awaitLatch(latch), (Matcher)Is.is((Object)true));
        scheduled.cancel(true);
        ((ScheduledThreadPoolExecutor)Mockito.verify((Object)this.sharedScheduledExecutor)).scheduleAtFixedRate((Runnable)ArgumentMatchers.any(), ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)1000L), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        MatcherAssert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis((Long)startTimes.get(1) - (Long)endTimes.get(0)), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(700L)));
        this.assertNoRejections();
    }

    @Test
    @Description(value="Tests that scheduleAtFixedRate parameters are honored even if the task takes longer than the rate")
    public void fixedRateExceeds() {
        ArrayList startTimes = new ArrayList();
        ArrayList endTimes = new ArrayList();
        CountDownLatch latch = new CountDownLatch(2);
        ScheduledFuture<?> scheduled = this.executor.scheduleAtFixedRate(() -> {
            startTimes.add(System.nanoTime());
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            latch.countDown();
            endTimes.add(System.nanoTime());
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
        MatcherAssert.assertThat((Object)this.awaitLatch(latch), (Matcher)Is.is((Object)true));
        scheduled.cancel(true);
        MatcherAssert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis((Long)startTimes.get(1) - (Long)endTimes.get(0)), (Matcher)(this.executor instanceof DefaultScheduler && this.sharedExecutorQueue instanceof SynchronousQueue ? IsCloseTo.closeTo((double)800.0, (double)100.0) : IsCloseTo.closeTo((double)0.0, (double)100.0)));
    }

    private void assertNoRejections() {
        ScheduledExecutorService scheduledExecutorService = this.executor;
        if (scheduledExecutorService instanceof ReportableScheduler) {
            ReportableScheduler reportable = (ReportableScheduler)scheduledExecutorService;
            TimedDataAggregation rejectionsAggregation = reportable.getRejectionsOverTime().aggregate((Object)0, (a, t) -> a + 1);
            MatcherAssert.assertThat((Object)((Integer)rejectionsAggregation.forLast60MinsInterval()), (Matcher)Is.is((Object)0));
        }
    }

    private void assertRejections() {
        ScheduledExecutorService scheduledExecutorService = this.executor;
        if (scheduledExecutorService instanceof ReportableScheduler) {
            ReportableScheduler reportable = (ReportableScheduler)scheduledExecutorService;
            TimedDataAggregation rejectionsAggregation = reportable.getRejectionsOverTime().aggregate((Object)0, (a, t) -> a + 1);
            MatcherAssert.assertThat((Object)((Integer)rejectionsAggregation.forLast1MinInterval()), (Matcher)Is.is((Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        }
    }
}

