/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Feature;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerBusyException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;
import org.mule.runtime.api.scheduler.SchedulerView;
import org.mule.service.scheduler.internal.config.ContainerThreadPoolsConfig;
import org.mule.service.scheduler.internal.service.DefaultSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.slf4j.Logger;

@Feature(value="Scheduler Service")
public abstract class SchedulerServiceContractTestCase
extends AbstractMuleTestCase {
    private static final String SCHEDULER_MAINTENANCE_THREAD_PREFIX = "CUSTOM - Scheduler Maintenance";
    protected DefaultSchedulerService service;
    protected ContainerThreadPoolsConfig config;

    @Before
    public void before() throws MuleException {
        this.service = new DefaultSchedulerService();
        this.startService(this.service);
    }

    private void startService(DefaultSchedulerService service) throws MuleException {
        try (MockedStatic containerThreadPoolsConfig = Mockito.mockStatic(ContainerThreadPoolsConfig.class);){
            this.config = this.getMockConfig();
            containerThreadPoolsConfig.when(ContainerThreadPoolsConfig::loadThreadPoolsConfig).thenReturn((Object)this.config);
            service.start();
        }
    }

    @After
    public void after() throws MuleException {
        this.service.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void usageTraceEnabled() throws Throwable {
        ArrayList maintenanceMessage = new ArrayList();
        Logger testLogger = (Logger)Mockito.mock(Logger.class);
        ((Logger)Mockito.doAnswer(invocation -> {
            maintenanceMessage.add((String)invocation.getArgument(0));
            return null;
        }).when((Object)testLogger)).warn(ArgumentMatchers.anyString());
        try (MockedStatic serviceClass = Mockito.mockStatic(DefaultSchedulerService.class);){
            serviceClass.when(DefaultSchedulerService::getTraceLogger).thenReturn((Object)testLogger);
            serviceClass.when(DefaultSchedulerService::getUsageTraceIntervalSecs).thenReturn((Object)1L);
            DefaultSchedulerService service = new DefaultSchedulerService();
            try {
                this.startService(service);
                new PollingProber(10000L, 500L).check((Probe)new JUnitLambdaProbe(() -> {
                    MatcherAssert.assertThat((Object)maintenanceMessage, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.containsString((String)"Schedulers Usage Report")));
                    return true;
                }));
            }
            finally {
                service.stop();
            }
        }
    }

    @Test
    public void defaultNoConfig() {
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.service.getSchedulers(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.getSchedulersRepresentation(this.service), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)SCHEDULER_MAINTENANCE_THREAD_PREFIX)));
        this.service.cpuLightScheduler();
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.service.getSchedulers(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(this.getSchedulersRepresentation(this.service), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)this.getCpuLightPrefix())));
        this.service.cpuLightScheduler();
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.service.getSchedulers(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(this.getSchedulersRepresentation(this.service), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{CoreMatchers.startsWith((String)this.getCpuLightPrefix()), CoreMatchers.startsWith((String)this.getCpuLightPrefix())}));
        MatcherAssert.assertThat((Object)this.areSchedulersActive(this.service), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void artifactConfig() {
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.service.getSchedulers(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.getSchedulersRepresentation(this.service), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)SCHEDULER_MAINTENANCE_THREAD_PREFIX)));
        SchedulerPoolsConfigFactory configFactory = this.getMockConfigFactory();
        this.service.cpuLightScheduler(SchedulerConfig.config(), configFactory);
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)this.service.getSchedulers(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(this.getSchedulersRepresentation(this.service), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)this.getCpuLightPrefix())));
        this.service.cpuLightScheduler(SchedulerConfig.config(), configFactory);
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)this.service.getSchedulers(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(this.getSchedulersRepresentation(this.service), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{CoreMatchers.startsWith((String)this.getCpuLightPrefix()), CoreMatchers.startsWith((String)this.getCpuLightPrefix())}));
    }

    @Test
    public void addWithArtifactConfig() {
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        this.service.cpuLightScheduler(SchedulerConfig.config());
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.service.getSchedulers(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(this.getSchedulersRepresentation(this.service), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)this.getCpuLightPrefix())));
        this.service.cpuLightScheduler(SchedulerConfig.config(), this.getMockConfigFactory());
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)this.service.getSchedulers(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat(this.getSchedulersRepresentation(this.service), (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{CoreMatchers.startsWith((String)this.getCpuLightPrefix()), CoreMatchers.startsWith((String)this.getCpuLightPrefix())}));
    }

    @Test
    public void artifactGarbageCollectedConfig() {
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        SchedulerPoolsConfigFactory config = () -> Optional.of(this.config);
        PhantomReference<SchedulerPoolsConfigFactory> configFactoryRef = new PhantomReference<SchedulerPoolsConfigFactory>(config, new ReferenceQueue());
        this.service.cpuLightScheduler(SchedulerConfig.config(), config);
        MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)2));
        config = null;
        new PollingProber(10000L, 500L).check((Probe)new JUnitLambdaProbe(() -> {
            System.gc();
            MatcherAssert.assertThat((Object)configFactoryRef.isEnqueued(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
            return true;
        }));
    }

    @Test
    public void stoppedScheduler() {
        Scheduler scheduler = this.service.cpuLightScheduler();
        MatcherAssert.assertThat((Object)this.service.getSchedulers(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(this.getSchedulersRepresentation(this.service), (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.startsWith((String)this.getCpuLightPrefix())));
        scheduler.stop();
        MatcherAssert.assertThat((Object)this.service.getSchedulers(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testWaitGroups() throws ExecutionException, InterruptedException {
        MatcherAssert.assertThat((Object)this.isScheduledTaskInWaitGroup(this.service.cpuLightScheduler(SchedulerConfig.config())), (Matcher)CoreMatchers.is((Object)this.areCpuLightTasksInWaitGroup()));
        MatcherAssert.assertThat((Object)this.isScheduledTaskInWaitGroup(this.service.ioScheduler(SchedulerConfig.config())), (Matcher)CoreMatchers.is((Object)this.areIoTasksInWaitGroup()));
        MatcherAssert.assertThat((Object)this.isScheduledTaskInWaitGroup(this.service.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1))), (Matcher)CoreMatchers.is((Object)false));
    }

    private boolean isScheduledTaskInWaitGroup(Scheduler scheduler) throws ExecutionException, InterruptedException {
        return (Boolean)scheduler.submit(() -> this.service.isCurrentThreadInWaitGroup()).get();
    }

    @Test
    public void testCpuWorkGroups() throws ExecutionException, InterruptedException {
        MatcherAssert.assertThat((Object)this.isScheduledTaskInCpuWorkGroup(this.service.cpuLightScheduler(SchedulerConfig.config())), (Matcher)CoreMatchers.is((Object)this.areCpuLightTasksInCpuWorkGroup()));
        MatcherAssert.assertThat((Object)this.isScheduledTaskInCpuWorkGroup(this.service.ioScheduler(SchedulerConfig.config())), (Matcher)CoreMatchers.is((Object)this.areIoTasksInCpuWorkGroup()));
        MatcherAssert.assertThat((Object)this.isScheduledTaskInCpuWorkGroup(this.service.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1))), (Matcher)CoreMatchers.is((Object)false));
    }

    private boolean isScheduledTaskInCpuWorkGroup(Scheduler scheduler) throws ExecutionException, InterruptedException {
        return (Boolean)scheduler.submit(() -> this.service.isCurrentThreadForCpuWork()).get();
    }

    protected abstract boolean areCpuLightTasksInWaitGroup();

    protected abstract boolean areIoTasksInWaitGroup();

    protected abstract boolean areCpuLightTasksInCpuWorkGroup();

    protected abstract boolean areIoTasksInCpuWorkGroup();

    @Test
    public void customSchedulerWithoutPoolSize() {
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows((String)"Custom scheduler is still created", IllegalArgumentException.class, () -> this.service.customScheduler(SchedulerConfig.config(), 1));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.is((Object)"Custom schedulers must define a thread pool size by calling `config.withMaxConcurrentTasks()`"));
    }

    @Test
    public void customSchedulerWithCustomQueueSize() throws ExecutionException, InterruptedException {
        Scheduler sourceScheduler = this.service.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1), 1);
        sourceScheduler.submit(() -> {
            try {
                sourceScheduler.submit(() -> {});
                sourceScheduler.submit(() -> {});
                Assert.fail((String)"Task should have been rejected");
            }
            catch (Exception e) {
                MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(SchedulerBusyException.class));
            }
        }).get();
    }

    @Test
    public void splashMessage() {
        String expectedSplashMessage = "Resolved configuration values:" + System.lineSeparator() + System.lineSeparator() + "Pooling strategy:       " + this.config.getSchedulerPoolStrategy().name() + System.lineSeparator() + "gracefulShutdownTimeout:       " + this.config.getGracefulShutdownTimeout().getAsLong() + " ms" + System.lineSeparator() + this.getSplashMessage() + System.lineSeparator() + "These can be modified by editing 'conf/scheduler-pools.conf'" + System.lineSeparator();
        MatcherAssert.assertThat((Object)this.service.getSplashMessage(), (Matcher)CoreMatchers.is((Object)expectedSplashMessage));
    }

    @Test
    public void unknownPoolStrategy() {
        DefaultSchedulerService service = new DefaultSchedulerService();
        try (MockedStatic containerThreadPoolsConfig = Mockito.mockStatic(ContainerThreadPoolsConfig.class);){
            ContainerThreadPoolsConfig config = this.getMockConfig();
            Mockito.when((Object)config.getSchedulerPoolStrategy()).thenReturn((Object)((SchedulerPoolStrategy)Mockito.mock(SchedulerPoolStrategy.class)));
            containerThreadPoolsConfig.when(ContainerThreadPoolsConfig::loadThreadPoolsConfig).thenReturn((Object)config);
            IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows((String)"service is still started", IllegalArgumentException.class, () -> ((DefaultSchedulerService)service).start());
            MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)CoreMatchers.startsWith((String)"Unsupported pool strategy type"));
        }
    }

    protected abstract String getSplashMessage();

    protected abstract String getCpuLightPrefix();

    private Set<String> getSchedulersRepresentation(DefaultSchedulerService service) {
        return service.getSchedulers().stream().map(Object::toString).collect(Collectors.toSet());
    }

    private boolean areSchedulersActive(DefaultSchedulerService service) {
        return service.getSchedulers().stream().noneMatch(SchedulerView::isShutdown) && service.getSchedulers().stream().noneMatch(SchedulerView::isTerminated);
    }

    private SchedulerPoolsConfigFactory getMockConfigFactory() {
        SchedulerPoolsConfigFactory configFactory = (SchedulerPoolsConfigFactory)Mockito.mock(SchedulerPoolsConfigFactory.class);
        Mockito.when((Object)configFactory.getConfig()).thenReturn(Optional.of(this.config));
        return configFactory;
    }

    private ContainerThreadPoolsConfig getMockConfig() {
        ContainerThreadPoolsConfig config = (ContainerThreadPoolsConfig)Mockito.mock(ContainerThreadPoolsConfig.class);
        Mockito.when((Object)config.getGracefulShutdownTimeout()).thenReturn((Object)OptionalLong.of(30000L));
        Mockito.when((Object)config.getThreadNamePrefix()).thenReturn((Object)"test");
        this.configure((SchedulerPoolsConfig)config);
        return config;
    }

    protected abstract void configure(SchedulerPoolsConfig var1);
}

