/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.threads;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.ThrottledScheduler;
import org.mule.service.scheduler.internal.executor.ByCallerThreadGroupPolicy;
import org.mule.service.scheduler.internal.executor.ByCallerThrottlingPolicy;
import org.mule.service.scheduler.internal.threads.SchedulerThreadFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerThreadPools {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerThreadPools.class);
    private static final String CPU_LIGHT_THREADS_NAME = ThreadType.CPU_LIGHT.getName();
    private static final String IO_THREADS_NAME = ThreadType.IO.getName();
    private static final String COMPUTATION_THREADS_NAME = ThreadType.CPU_INTENSIVE.getName();
    private static final String TIMER_THREADS_NAME = "timer";
    private static final String CUSTOM_THREADS_NAME = ThreadType.CUSTOM.getName();
    private static final boolean ALWAYS_SHOW_SCHEDULER_CREATION_LOCATION = System.getProperties().containsKey("mule.scheduler.alwaysShowSchedulerCreationLocation");
    private final String name;
    private final SchedulerPoolsConfig threadPoolsConfig;
    private final ThreadGroup schedulerGroup;
    private final ThreadGroup cpuLightGroup;
    private final ThreadGroup ioGroup;
    private final ThreadGroup computationGroup;
    private final ThreadGroup timerGroup;
    private final ThreadGroup customGroup;
    private final ThreadGroup customWaitGroup;
    private final ThreadGroup customCallerRunsGroup;
    private final ThreadGroup customCallerRunsAnsWaitGroup;
    private final Function<String, RejectedExecutionHandler> byCallerThreadGroupPolicy;
    private final Predicate<ThreadGroup> cpuWorkChecker;
    private ThreadPoolExecutor cpuLightExecutor;
    private ThreadPoolExecutor ioExecutor;
    private ThreadPoolExecutor computationExecutor;
    private final Set<ThreadPoolExecutor> customSchedulersExecutors = new HashSet<ThreadPoolExecutor>();
    private ScheduledThreadPoolExecutor scheduledExecutor;
    private Scheduler quartzScheduler;
    private final ReadWriteLock activeSchedulersLock = new ReentrantReadWriteLock();
    private final Lock activeSchedulersReadLock = this.activeSchedulersLock.readLock();
    private final Lock activeSchedulersWriteLock = this.activeSchedulersLock.writeLock();
    private final List<org.mule.runtime.api.scheduler.Scheduler> activeCpuLightSchedulers = new ArrayList<org.mule.runtime.api.scheduler.Scheduler>();
    private final List<org.mule.runtime.api.scheduler.Scheduler> activeIoSchedulers = new ArrayList<org.mule.runtime.api.scheduler.Scheduler>();
    private final List<org.mule.runtime.api.scheduler.Scheduler> activeCpuIntensiveSchedulers = new ArrayList<org.mule.runtime.api.scheduler.Scheduler>();
    private final List<org.mule.runtime.api.scheduler.Scheduler> activeCustomSchedulers = new ArrayList<org.mule.runtime.api.scheduler.Scheduler>();

    public SchedulerThreadPools(String name, SchedulerPoolsConfig threadPoolsConfig) {
        this.name = name;
        this.threadPoolsConfig = threadPoolsConfig;
        this.schedulerGroup = new ThreadGroup(name){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error("Thread '" + t.getName() + "' stopped.", e);
            }
        };
        this.cpuLightGroup = new ThreadGroup(this.schedulerGroup, threadPoolsConfig.getThreadNamePrefix() + CPU_LIGHT_THREADS_NAME);
        this.ioGroup = new ThreadGroup(this.schedulerGroup, threadPoolsConfig.getThreadNamePrefix() + IO_THREADS_NAME);
        this.computationGroup = new ThreadGroup(this.schedulerGroup, threadPoolsConfig.getThreadNamePrefix() + COMPUTATION_THREADS_NAME);
        this.timerGroup = new ThreadGroup(this.schedulerGroup, threadPoolsConfig.getThreadNamePrefix() + TIMER_THREADS_NAME);
        this.customGroup = new ThreadGroup(this.schedulerGroup, threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME);
        this.customWaitGroup = new ThreadGroup(this.customGroup, threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME);
        this.customCallerRunsGroup = new ThreadGroup(this.customGroup, threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME);
        this.customCallerRunsAnsWaitGroup = new ThreadGroup(this.customGroup, threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME);
        HashSet<ThreadGroup> waitGroups = new HashSet<ThreadGroup>(Arrays.asList(this.ioGroup, this.customWaitGroup, this.customCallerRunsAnsWaitGroup));
        HashSet<ThreadGroup> cpuWorkGroups = new HashSet<ThreadGroup>(Arrays.asList(this.cpuLightGroup, this.computationGroup));
        this.byCallerThreadGroupPolicy = schedulerName -> new ByCallerThreadGroupPolicy((Set<ThreadGroup>)waitGroups, (Set<ThreadGroup>)new HashSet<ThreadGroup>(Arrays.asList(this.cpuLightGroup, this.computationGroup, this.customCallerRunsGroup, this.customCallerRunsAnsWaitGroup)), this.cpuLightGroup, this.schedulerGroup, (String)schedulerName);
        this.cpuWorkChecker = threadGroup -> {
            if (threadGroup != null) {
                while (threadGroup.getParent() != null) {
                    if (cpuWorkGroups.contains(threadGroup)) {
                        return true;
                    }
                    threadGroup = threadGroup.getParent();
                }
            }
            return false;
        };
    }

    public void start() throws MuleException {
        if (SystemUtils.IS_JAVA_1_8) {
            this.prestartCoreThreads(ForkJoinPool.commonPool(), ForkJoinPool.getCommonPoolParallelism());
        }
        this.cpuLightExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getCpuLightPoolSize().getAsInt(), this.threadPoolsConfig.getCpuLightPoolSize().getAsInt(), 0L, TimeUnit.SECONDS, this.createQueue(this.threadPoolsConfig.getCpuLightQueueSize().getAsInt()), new SchedulerThreadFactory(this.cpuLightGroup), this.byCallerThreadGroupPolicy.apply(this.cpuLightGroup.getName()));
        this.ioExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getIoCorePoolSize().getAsInt(), this.threadPoolsConfig.getIoMaxPoolSize().getAsInt(), this.threadPoolsConfig.getIoKeepAlive().getAsLong(), TimeUnit.MILLISECONDS, this.createQueue(this.threadPoolsConfig.getIoQueueSize().getAsInt()), new SchedulerThreadFactory(this.ioGroup), this.byCallerThreadGroupPolicy.apply(this.ioGroup.getName()));
        this.computationExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getCpuIntensivePoolSize().getAsInt(), this.threadPoolsConfig.getCpuIntensivePoolSize().getAsInt(), 0L, TimeUnit.SECONDS, this.createQueue(this.threadPoolsConfig.getCpuIntensiveQueueSize().getAsInt()), new SchedulerThreadFactory(this.computationGroup), this.byCallerThreadGroupPolicy.apply(this.computationGroup.getName()));
        this.prestartCoreThreads(this.cpuLightExecutor, this.threadPoolsConfig.getCpuLightPoolSize().getAsInt());
        this.prestartCoreThreads(this.ioExecutor, this.threadPoolsConfig.getIoCorePoolSize().getAsInt());
        this.prestartCoreThreads(this.computationExecutor, this.threadPoolsConfig.getCpuIntensivePoolSize().getAsInt());
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, new SchedulerThreadFactory(this.timerGroup, "%s"));
        this.scheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduledExecutor.setRemoveOnCancelPolicy(true);
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        try {
            schedulerFactory.initialize(this.defaultQuartzProperties());
            this.quartzScheduler = schedulerFactory.getScheduler();
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    private BlockingQueue<Runnable> createQueue(int size) {
        return size == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(size);
    }

    private Properties defaultQuartzProperties() {
        Properties factoryProperties = new Properties();
        factoryProperties.setProperty("org.quartz.scheduler.instanceName", this.threadPoolsConfig.getThreadNamePrefix());
        factoryProperties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        factoryProperties.setProperty("org.quartz.threadPool.threadNamePrefix", this.threadPoolsConfig.getThreadNamePrefix() + "_qz");
        factoryProperties.setProperty("org.quartz.threadPool.threadCount", "1");
        factoryProperties.setProperty("org.quartz.jobStore.misfireThreshold", "" + TimeUnit.SECONDS.toMillis(5L));
        return factoryProperties;
    }

    public void stop() throws MuleException, InterruptedException {
        this.cpuLightExecutor.shutdown();
        this.ioExecutor.shutdown();
        this.computationExecutor.shutdown();
        for (ThreadPoolExecutor customSchedulerExecutor : this.customSchedulersExecutors) {
            customSchedulerExecutor.shutdown();
        }
        this.scheduledExecutor.shutdown();
        try {
            this.quartzScheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
        long startMillis = System.currentTimeMillis();
        this.waitForExecutorTermination(startMillis, this.scheduledExecutor, this.threadPoolsConfig.getThreadNamePrefix() + TIMER_THREADS_NAME);
        this.waitForExecutorTermination(startMillis, this.cpuLightExecutor, this.threadPoolsConfig.getThreadNamePrefix() + CPU_LIGHT_THREADS_NAME);
        this.waitForExecutorTermination(startMillis, this.ioExecutor, this.threadPoolsConfig.getThreadNamePrefix() + IO_THREADS_NAME);
        this.waitForExecutorTermination(startMillis, this.computationExecutor, this.threadPoolsConfig.getThreadNamePrefix() + COMPUTATION_THREADS_NAME);
        for (ThreadPoolExecutor customSchedulerExecutor : new ArrayList<ThreadPoolExecutor>(this.customSchedulersExecutors)) {
            this.waitForExecutorTermination(startMillis, customSchedulerExecutor, ((SchedulerThreadFactory)customSchedulerExecutor.getThreadFactory()).getGroup().getName());
        }
        this.cpuLightExecutor = null;
        this.ioExecutor = null;
        this.computationExecutor = null;
        this.scheduledExecutor = null;
        this.quartzScheduler = null;
    }

    protected void waitForExecutorTermination(long startMillis, ExecutorService executor, String executorLabel) throws InterruptedException {
        if (!executor.awaitTermination(this.threadPoolsConfig.getGracefulShutdownTimeout().getAsLong() - (System.currentTimeMillis() - startMillis), TimeUnit.MILLISECONDS)) {
            List<Runnable> cancelledJobs = executor.shutdownNow();
            logger.warn("'" + executorLabel + "' " + executor.toString() + " did not shutdown gracefully after " + this.threadPoolsConfig.getGracefulShutdownTimeout() + " milliseconds.");
            if (logger.isDebugEnabled()) {
                logger.debug("The jobs " + cancelledJobs + " were cancelled.");
            } else {
                logger.info(cancelledJobs.size() + " jobs were cancelled.");
            }
        }
    }

    public org.mule.runtime.api.scheduler.Scheduler createCpuLightScheduler(SchedulerConfig config, int parallelTasksEstimate, Supplier<Long> stopTimeout) {
        this.validateCustomSchedulerOnlyConfigNotChanged(config);
        String schedulerName = this.resolveCpuLightSchedulerName(config);
        DefaultScheduler scheduler = this.shouldThrottle(config, this.threadPoolsConfig.getCpuLightPoolSize()) ? new ThrottledScheduler(schedulerName, this.cpuLightExecutor, parallelTasksEstimate, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_LIGHT, new ByCallerThrottlingPolicy(config.getMaxConcurrentTasks(), new HashSet<ThreadGroup>(Arrays.asList(this.ioGroup, this.customWaitGroup)), this.schedulerGroup), stopTimeout, this.shutdownCallback(this.activeCpuLightSchedulers)) : new DefaultScheduler(schedulerName, this.cpuLightExecutor, parallelTasksEstimate, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_LIGHT, stopTimeout, this.shutdownCallback(this.activeCpuLightSchedulers));
        this.addScheduler(this.activeCpuLightSchedulers, scheduler);
        return scheduler;
    }

    public org.mule.runtime.api.scheduler.Scheduler createIoScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout) {
        this.validateCustomSchedulerOnlyConfigNotChanged(config);
        String schedulerName = this.resolveIoSchedulerName(config);
        DefaultScheduler scheduler = this.shouldThrottle(config, this.threadPoolsConfig.getIoMaxPoolSize()) ? new ThrottledScheduler(schedulerName, this.ioExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, new ByCallerThrottlingPolicy(config.getMaxConcurrentTasks(), new HashSet<ThreadGroup>(Arrays.asList(this.ioGroup, this.customWaitGroup)), this.schedulerGroup), stopTimeout, this.shutdownCallback(this.activeIoSchedulers)) : new DefaultScheduler(schedulerName, this.ioExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, stopTimeout, this.shutdownCallback(this.activeIoSchedulers));
        this.addScheduler(this.activeIoSchedulers, scheduler);
        return scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addScheduler(List<org.mule.runtime.api.scheduler.Scheduler> activeSchedulers, org.mule.runtime.api.scheduler.Scheduler scheduler) {
        this.activeSchedulersWriteLock.lock();
        try {
            boolean bl = activeSchedulers.add(scheduler);
            return bl;
        }
        finally {
            this.activeSchedulersWriteLock.unlock();
        }
    }

    private Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback(List<org.mule.runtime.api.scheduler.Scheduler> activeSchedulers) {
        return schr -> {
            this.activeSchedulersWriteLock.lock();
            try {
                activeSchedulers.remove(schr);
            }
            finally {
                this.activeSchedulersWriteLock.unlock();
            }
        };
    }

    public org.mule.runtime.api.scheduler.Scheduler createCpuIntensiveScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout) {
        this.validateCustomSchedulerOnlyConfigNotChanged(config);
        String schedulerName = this.resolveComputationSchedulerName(config);
        DefaultScheduler scheduler = this.shouldThrottle(config, this.threadPoolsConfig.getCpuIntensivePoolSize()) ? new ThrottledScheduler(schedulerName, this.computationExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_INTENSIVE, new ByCallerThrottlingPolicy(config.getMaxConcurrentTasks(), new HashSet<ThreadGroup>(Arrays.asList(this.ioGroup, this.customWaitGroup)), this.schedulerGroup), stopTimeout, this.shutdownCallback(this.activeCpuIntensiveSchedulers)) : new DefaultScheduler(schedulerName, this.computationExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_INTENSIVE, stopTimeout, this.shutdownCallback(this.activeCpuIntensiveSchedulers));
        this.addScheduler(this.activeCpuIntensiveSchedulers, scheduler);
        return scheduler;
    }

    private void validateCustomSchedulerOnlyConfigNotChanged(SchedulerConfig config) {
        if (config.getWaitAllowed().isPresent()) {
            throw new IllegalArgumentException("Only custom schedulers may define 'waitAllowed' behaviour");
        }
        if (config.getDirectRunCpuLightWhenTargetBusy().isPresent()) {
            throw new IllegalArgumentException("Only custom schedulers may define 'directRunCpuLightWhenTargetBusy' behaviour");
        }
    }

    private boolean shouldThrottle(SchedulerConfig config, OptionalInt backingPoolMaxSize) {
        return config.getMaxConcurrentTasks() != null && config.getMaxConcurrentTasks() < backingPoolMaxSize.orElse(Integer.MAX_VALUE);
    }

    public org.mule.runtime.api.scheduler.Scheduler createCustomScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout) {
        String threadsName = this.resolveCustomThreadsName(config);
        return this.doCreateCustomScheduler(config, workers, stopTimeout, this.resolveCustomSchedulerName(config), this.createQueue(config.getMaxConcurrentTasks()), threadsName);
    }

    public org.mule.runtime.api.scheduler.Scheduler createCustomScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout, int queueSize) {
        String threadsName = this.resolveCustomThreadsName(config);
        return this.doCreateCustomScheduler(config, workers, stopTimeout, this.resolveCustomSchedulerName(config), this.createQueue(queueSize), threadsName);
    }

    private org.mule.runtime.api.scheduler.Scheduler doCreateCustomScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout, String schedulerName, BlockingQueue<Runnable> workQueue, String threadsName) {
        if (config.getMaxConcurrentTasks() == null) {
            throw new IllegalArgumentException("Custom schedulers must define a thread pool size bi calling `config.withMaxConcurrentTasks()`");
        }
        ThreadGroup customChildGroup = new ThreadGroup(this.resolveThreadGroupForCustomScheduler(config), threadsName);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(config.getMaxConcurrentTasks(), config.getMaxConcurrentTasks(), 0L, TimeUnit.MILLISECONDS, workQueue, new SchedulerThreadFactory(customChildGroup, "%s.%02d"), this.byCallerThreadGroupPolicy.apply(customChildGroup.getName()));
        this.prestartCoreThreads(executor, config.getMaxConcurrentTasks());
        Set<ThreadPoolExecutor> executors = this.customSchedulersExecutors;
        CustomScheduler customScheduler = new CustomScheduler(schedulerName, executor, customChildGroup, workers, this.scheduledExecutor, this.quartzScheduler, this.ioExecutor, ThreadType.CUSTOM, stopTimeout, this.shutdownCallback(this.activeCustomSchedulers).andThen(s -> executors.remove(executor)));
        executors.add(executor);
        this.addScheduler(this.activeCustomSchedulers, customScheduler);
        return customScheduler;
    }

    private void prestartCoreThreads(AbstractExecutorService executor, int corePoolSize) {
        CountDownLatch prestartWaitLatch = new CountDownLatch(1);
        CountDownLatch prestartLatch = new CountDownLatch(corePoolSize);
        ArrayList prestartFutures = new ArrayList(corePoolSize);
        String executorAsString = executor.toString();
        for (int i = 0; i < corePoolSize; ++i) {
            try {
                prestartFutures.add(executor.submit(() -> {
                    try {
                        prestartWaitLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new MuleRuntimeException((Throwable)e);
                    }
                    this.prestartCallback(prestartLatch);
                }));
                continue;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                executor.shutdownNow();
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to prestart all core threads for executor:" + executorAsString)));
            }
        }
        prestartWaitLatch.countDown();
        try {
            if (!prestartLatch.await(30L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to prestart all core threads for executor:" + executorAsString)));
            }
            try {
                for (Future future : prestartFutures) {
                    future.get(30L, TimeUnit.SECONDS);
                }
            }
            catch (ExecutionException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to prestart all core threads for executor:" + executorAsString)), e.getCause());
            }
            catch (TimeoutException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to prestart all core threads for executor:" + executorAsString)), (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected void prestartCallback(CountDownLatch prestartLatch) {
        prestartLatch.countDown();
    }

    private ThreadGroup resolveThreadGroupForCustomScheduler(SchedulerConfig config) {
        if (config.getDirectRunCpuLightWhenTargetBusy().orElse(false).booleanValue() && config.getWaitAllowed().orElse(false).booleanValue()) {
            return this.customCallerRunsAnsWaitGroup;
        }
        if (config.getDirectRunCpuLightWhenTargetBusy().orElse(false).booleanValue()) {
            return this.customCallerRunsGroup;
        }
        if (config.getWaitAllowed().orElse(false).booleanValue()) {
            return this.customWaitGroup;
        }
        return this.customGroup;
    }

    private String resolveCpuLightSchedulerName(SchedulerConfig config) {
        return this.resolveSchedulerName(config, CPU_LIGHT_THREADS_NAME);
    }

    private String resolveIoSchedulerName(SchedulerConfig config) {
        return this.resolveSchedulerName(config, IO_THREADS_NAME);
    }

    private String resolveComputationSchedulerName(SchedulerConfig config) {
        return this.resolveSchedulerName(config, COMPUTATION_THREADS_NAME);
    }

    private String resolveCustomSchedulerName(SchedulerConfig config) {
        return this.resolveSchedulerName(config, CUSTOM_THREADS_NAME);
    }

    private String resolveSchedulerName(SchedulerConfig config, String prefix) {
        if (!config.hasName()) {
            config = config.withName(this.resolveSchedulerCreationLocation(prefix));
            return config.getSchedulerName();
        }
        if (ALWAYS_SHOW_SCHEDULER_CREATION_LOCATION) {
            return config.getSchedulerName() + " " + this.resolveSchedulerCreationLocation(null);
        }
        return config.getSchedulerName();
    }

    private String resolveCustomThreadsName(SchedulerConfig config) {
        if (config.hasName()) {
            return config.getSchedulerName();
        }
        return this.threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME;
    }

    private String resolveSchedulerCreationLocation(String prefix) {
        int i = 0;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement ste = stackTrace[i++];
        while (this.skip(ste) && i < stackTrace.length) {
            ste = stackTrace[i++];
        }
        ste = this.skip(ste) ? stackTrace[4] : stackTrace[i];
        return (prefix != null ? prefix : "") + "@" + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber();
    }

    private boolean skip(StackTraceElement ste) {
        return !ste.getClassName().contains("$Proxy");
    }

    public boolean isCurrentThreadForCpuWork() {
        return this.cpuWorkChecker.test(Thread.currentThread().getThreadGroup());
    }

    public List<org.mule.runtime.api.scheduler.Scheduler> getSchedulers() {
        this.activeSchedulersReadLock.lock();
        try {
            ImmutableList immutableList = ImmutableList.builder().addAll(this.activeCpuLightSchedulers).addAll(this.activeIoSchedulers).addAll(this.activeCpuIntensiveSchedulers).addAll(this.activeCustomSchedulers).build();
            return immutableList;
        }
        finally {
            this.activeSchedulersReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildReportString() {
        int schedulersCustom;
        int schedulersCpuIntensive;
        int schedulersIo;
        int schedulersCpuLight;
        StringBuilder threadPoolsReportBuilder = new StringBuilder();
        this.activeSchedulersReadLock.lock();
        try {
            schedulersCpuLight = this.activeCpuLightSchedulers.size();
            schedulersIo = this.activeIoSchedulers.size();
            schedulersCpuIntensive = this.activeCpuIntensiveSchedulers.size();
            schedulersCustom = this.activeCustomSchedulers.size();
        }
        finally {
            this.activeSchedulersReadLock.unlock();
        }
        int cpuLightActiveCount = this.cpuLightExecutor.getActiveCount();
        long cpuLightTaskCount = this.cpuLightExecutor.getTaskCount();
        long cpuLightRejected = ((ByCallerThreadGroupPolicy)this.cpuLightExecutor.getRejectedExecutionHandler()).getRejectedCount();
        int ioActiveCount = this.ioExecutor.getActiveCount();
        long ioTaskCount = this.ioExecutor.getTaskCount();
        long ioRejected = ((ByCallerThreadGroupPolicy)this.ioExecutor.getRejectedExecutionHandler()).getRejectedCount();
        int cpuIntensiveActiveCount = this.computationExecutor.getActiveCount();
        long cpuIntensiveTaskCount = this.computationExecutor.getTaskCount();
        long cpuIntensiveRejected = ((ByCallerThreadGroupPolicy)this.computationExecutor.getRejectedExecutionHandler()).getRejectedCount();
        int customActiveCount = 0;
        int customUsedCount = 0;
        int customQueued = 0;
        long customTaskCount = 0L;
        long customRejected = 0L;
        for (ThreadPoolExecutor customExecutor : this.customSchedulersExecutors) {
            int currentCustomActive = customExecutor.getActiveCount();
            customActiveCount += currentCustomActive;
            customUsedCount += customExecutor.getPoolSize() - currentCustomActive;
            customQueued += customExecutor.getQueue().size();
            customTaskCount += customExecutor.getTaskCount();
            customRejected += ((ByCallerThreadGroupPolicy)customExecutor.getRejectedExecutionHandler()).getRejectedCount();
        }
        threadPoolsReportBuilder.append(System.lineSeparator() + this.name + System.lineSeparator());
        threadPoolsReportBuilder.append("--------------------------------------------------------------------------------------" + System.lineSeparator());
        threadPoolsReportBuilder.append("Pool          | Schedulers | Idle threads | Used threads | Queued tasks | Rejection % " + System.lineSeparator());
        threadPoolsReportBuilder.append("--------------------------------------------------------------------------------------" + System.lineSeparator());
        threadPoolsReportBuilder.append(String.format("CPU Light     | %10d | %12d | %12d | %12d | ~ %9.2f", schedulersCpuLight, this.cpuLightExecutor.getPoolSize() - cpuLightActiveCount, cpuLightActiveCount, this.cpuLightExecutor.getQueue().size(), cpuLightRejected > 0L ? 100.0 * (double)(cpuLightRejected / (cpuLightTaskCount + cpuLightRejected)) : 0.0) + System.lineSeparator());
        threadPoolsReportBuilder.append(String.format("IO            | %10d | %12d | %12d | %12d | ~ %9.2f", schedulersIo, this.ioExecutor.getPoolSize() - ioActiveCount, ioActiveCount, this.ioExecutor.getQueue().size(), ioRejected > 0L ? 100.0 * (double)(ioRejected / (ioTaskCount + ioRejected)) : 0.0) + System.lineSeparator());
        threadPoolsReportBuilder.append(String.format("CPU Intensive | %10d | %12d | %12d | %12d | ~ %9.2f", schedulersCpuIntensive, this.computationExecutor.getPoolSize() - cpuIntensiveActiveCount, cpuIntensiveActiveCount, this.computationExecutor.getQueue().size(), cpuIntensiveRejected > 0L ? 100.0 * (double)(cpuIntensiveRejected / (cpuIntensiveTaskCount + cpuIntensiveRejected)) : 0.0) + System.lineSeparator());
        threadPoolsReportBuilder.append(String.format("Custom        | %10d | %12d | %12d | %12d | ~ %9.2f", schedulersCustom, customUsedCount, customActiveCount, customQueued, customRejected > 0L ? 100.0 * (double)(customRejected / (customTaskCount + customRejected)) : 0.0) + System.lineSeparator());
        threadPoolsReportBuilder.append("--------------------------------------------------------------------------------------" + System.lineSeparator() + System.lineSeparator());
        return threadPoolsReportBuilder.toString();
    }

    private static class CustomScheduler
    extends DefaultScheduler {
        private static final float THREADS_IN_GROUP_SIZE_MARGIN = 1.5f;
        private final ExecutorService executor;
        private final ThreadGroup threadGroup;
        private final ThreadPoolExecutor groupDestroyerExecutor;

        private CustomScheduler(String name, ExecutorService executor, ThreadGroup threadGroup, int workers, ScheduledExecutorService scheduledExecutor, Scheduler quartzScheduler, ThreadPoolExecutor groupDestroyerExecutor, ThreadType threadsType, Supplier<Long> shutdownTimeoutMillis, Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback) {
            super(name, executor, workers, scheduledExecutor, quartzScheduler, threadsType, shutdownTimeoutMillis, shutdownCallback);
            this.executor = executor;
            this.threadGroup = threadGroup;
            this.groupDestroyerExecutor = groupDestroyerExecutor;
        }

        @Override
        public void shutdown() {
            logger.debug("Shutting down " + this.toString());
            this.doShutdown();
            this.executor.shutdown();
            this.shutdownCallback.accept(this);
        }

        @Override
        public List<Runnable> shutdownNow() {
            logger.debug("Shutting down NOW " + this.toString());
            try {
                List<Runnable> cancelledTasks = this.doShutdownNow();
                this.executor.shutdownNow();
                List<Runnable> list = cancelledTasks;
                return list;
            }
            finally {
                this.shutdownWrapUp();
            }
        }

        @Override
        protected void stopFinally() {
            this.executor.shutdownNow();
            this.shutdownWrapUp();
        }

        private void shutdownWrapUp() {
            this.shutdownCallback.accept(this);
            if (this.threadGroup.equals(Thread.currentThread().getThreadGroup())) {
                this.groupDestroyerExecutor.execute(() -> this.destroyThreadGroup());
            } else {
                this.destroyThreadGroup();
            }
        }

        private void destroyThreadGroup() {
            IllegalThreadStateException destroyException = this.doDestroyThreadGroup();
            if (destroyException != null) {
                this.threadGroup.interrupt();
                destroyException = this.doDestroyThreadGroup();
            }
            this.tryTerminate();
            if (destroyException != null) {
                Thread[] threads = new Thread[(int)((float)this.threadGroup.activeCount() * 1.5f)];
                this.threadGroup.enumerate(threads, true);
                StringBuilder threadNamesBuilder = new StringBuilder();
                for (Thread thread : threads) {
                    if (thread == null) continue;
                    threadNamesBuilder.append("\t* " + thread.getName() + System.lineSeparator());
                    if (!logger.isDebugEnabled()) continue;
                    StackTraceElement[] stackTrace = thread.getStackTrace();
                    for (int i = 1; i < stackTrace.length; ++i) {
                        threadNamesBuilder.append("\t\tat ").append(stackTrace[i]).append(System.lineSeparator());
                    }
                }
                logger.error("Unable to destroy ThreadGroup '{}' of Scheduler '{}' ({}). Remaining threads in the group are:" + System.lineSeparator() + "{}", new Object[]{this.threadGroup.getName(), this.getName(), destroyException.toString(), threadNamesBuilder});
            }
        }

        private IllegalThreadStateException doDestroyThreadGroup() {
            IllegalThreadStateException destroyException = null;
            long durationMillis = (Long)this.shutdownTimeoutMillis.get();
            long stopNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos((Long)this.shutdownTimeoutMillis.get()) + TimeUnit.SECONDS.toNanos(1L);
            while (System.nanoTime() <= stopNanos && !this.threadGroup.isDestroyed()) {
                try {
                    this.threadGroup.destroy();
                    destroyException = null;
                }
                catch (IllegalThreadStateException e) {
                    destroyException = e;
                    try {
                        Thread.yield();
                        Thread.sleep(Math.min(50L, durationMillis));
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
                break;
            }
            return destroyException;
        }

        public String getThreadNameSuffix() {
            return null;
        }
    }
}

