/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.service.scheduler.internal.DefaultSchedulerService;
import org.mule.service.scheduler.internal.ThrottledScheduler;
import org.mule.service.scheduler.internal.executor.AbstractByCallerPolicy;
import org.mule.service.scheduler.internal.executor.SchedulerTaskThrottledException;

public final class ByCallerThrottlingPolicy
extends AbstractByCallerPolicy {
    private final int maxConcurrentTasks;
    private final AtomicInteger runningTasks = new AtomicInteger();
    private volatile long rejectedCount;

    public ByCallerThrottlingPolicy(int maxConcurrentTasks, Set<ThreadGroup> waitGroups, ThreadGroup parentGroup) {
        super(waitGroups, Collections.emptySet(), parentGroup);
        this.maxConcurrentTasks = maxConcurrentTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throttle(Runnable throttledCallback, RunnableFuture<?> task, ThrottledScheduler scheduler) {
        ThreadGroup currentThreadGroup = Thread.currentThread().getThreadGroup();
        if (!this.isSchedulerThread(currentThreadGroup) || this.isWaitGroupThread(currentThreadGroup)) {
            try {
                AtomicInteger atomicInteger = this.runningTasks;
                synchronized (atomicInteger) {
                    if (this.runningTasks.get() + 1 > this.maxConcurrentTasks) {
                        ++this.rejectedCount;
                    }
                    while (this.runningTasks.incrementAndGet() > this.maxConcurrentTasks) {
                        if (this.isLogThrottleEnabled()) {
                            this.logThrottle(task.toString(), "WaitPolicy", scheduler.toString());
                        }
                        this.runningTasks.getAndDecrement();
                        this.runningTasks.wait();
                    }
                }
                throttledCallback.run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        AtomicInteger atomicInteger = this.runningTasks;
        synchronized (atomicInteger) {
            if (this.runningTasks.incrementAndGet() > this.maxConcurrentTasks) {
                ++this.rejectedCount;
                if (this.isLogThrottleEnabled()) {
                    this.logThrottle(task.toString(), "AbortPolicy", scheduler.toString());
                }
                this.runningTasks.getAndDecrement();
                throw new SchedulerTaskThrottledException("Task '" + task.toString() + "' throttled back from '" + scheduler.toString() + "'");
            }
            throttledCallback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throttleWrapUp() {
        AtomicInteger atomicInteger = this.runningTasks;
        synchronized (atomicInteger) {
            this.runningTasks.decrementAndGet();
            this.runningTasks.notify();
        }
    }

    private boolean isLogThrottleEnabled() {
        return DefaultSchedulerService.USAGE_TRACE_INTERVAL_SECS != null ? DefaultSchedulerService.traceLogger.isWarnEnabled() : DefaultSchedulerService.traceLogger.isDebugEnabled();
    }

    private void logThrottle(String taskAsString, String strategy, String targetAsString) {
        if (DefaultSchedulerService.USAGE_TRACE_INTERVAL_SECS != null) {
            DefaultSchedulerService.traceLogger.warn("Task throttled back ({}) from '{}' scheduler: {}", new Object[]{StringUtils.rightPad((String)strategy, (int)16), targetAsString, taskAsString});
        } else {
            DefaultSchedulerService.traceLogger.debug("Task throttled back ({}) from '{}' scheduler: {}", new Object[]{StringUtils.rightPad((String)strategy, (int)16), targetAsString, taskAsString});
        }
    }

    public long getRejectedCount() {
        return this.rejectedCount;
    }

    public String toString() {
        return "(throttling: " + this.runningTasks.get() + "/" + this.maxConcurrentTasks + ")";
    }
}

