/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.threads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.ThrottledScheduler;
import org.mule.service.scheduler.internal.executor.ByCallerThreadGroupPolicy;
import org.mule.service.scheduler.internal.executor.ByCallerThrottlingPolicy;
import org.mule.service.scheduler.internal.threads.SchedulerThreadFactory;
import org.mule.service.scheduler.internal.threads.SchedulerThreadPools;
import org.slf4j.Logger;

class UberSchedulerThreadPools
extends SchedulerThreadPools {
    private static final String UBER_THREADS_NAME = "uber";
    private final List<Scheduler> activeSchedulers = new ArrayList<Scheduler>();
    private ThreadGroup uberGroup;
    private ThreadPoolExecutor uberExecutor;

    public UberSchedulerThreadPools(String name, SchedulerPoolsConfig threadPoolsConfig, boolean preStartThreads, Consumer<AbstractExecutorService> preStartCallback, Logger traceLogger) {
        super(name, threadPoolsConfig, preStartThreads, preStartCallback, traceLogger);
    }

    @Override
    protected void doStart(boolean preStartThreads) throws MuleException {
        this.uberExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getUberCorePoolSize().getAsInt(), this.threadPoolsConfig.getUberMaxPoolSize().getAsInt(), this.threadPoolsConfig.getUberKeepAlive().getAsLong(), TimeUnit.MILLISECONDS, this.createQueue(this.threadPoolsConfig.getUberQueueSize().getAsInt()), new SchedulerThreadFactory(this.uberGroup), (RejectedExecutionHandler)this.byCallerThreadGroupPolicy.apply(this.uberGroup.getName()));
        if (preStartThreads) {
            this.prestartCoreThreads(this.uberExecutor, this.threadPoolsConfig.getUberCorePoolSize().getAsInt());
        }
    }

    @Override
    public Scheduler createCpuLightScheduler(SchedulerConfig config, int parallelTasksEstimate, Supplier<Long> stopTimeout) {
        return this.createIoScheduler(config, parallelTasksEstimate, stopTimeout);
    }

    @Override
    public Scheduler createIoScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout) {
        this.validateCustomSchedulerOnlyConfigNotChanged(config);
        String schedulerName = this.resolveSchedulerName(config, UBER_THREADS_NAME);
        DefaultScheduler scheduler = this.shouldThrottle(config, this.threadPoolsConfig.getUberMaxPoolSize()) ? new ThrottledScheduler(schedulerName, this.uberExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, new ByCallerThrottlingPolicy(config.getMaxConcurrentTasks(), new HashSet<ThreadGroup>(Arrays.asList(this.uberGroup, this.customWaitGroup)), this.parentGroup, this.traceLogger), stopTimeout, this.shutdownCallback(this.activeSchedulers)) : new DefaultScheduler(schedulerName, this.uberExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, stopTimeout, this.shutdownCallback(this.activeSchedulers));
        this.addScheduler(this.activeSchedulers, scheduler);
        return scheduler;
    }

    @Override
    public Scheduler createCpuIntensiveScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout) {
        return this.createIoScheduler(config, workers, stopTimeout);
    }

    @Override
    protected void createCustomThreadGroups() {
        this.uberGroup = new ThreadGroup(this.parentGroup, this.threadPoolsConfig.getThreadNamePrefix() + UBER_THREADS_NAME);
    }

    @Override
    protected ByCallerThreadGroupPolicy createThreadGroupPolicy(String schedulerName) {
        HashSet<ThreadGroup> waitGroups = new HashSet<ThreadGroup>(Arrays.asList(this.uberGroup, this.customWaitGroup, this.customCallerRunsAnsWaitGroup));
        return new ByCallerThreadGroupPolicy(waitGroups, new HashSet<ThreadGroup>(Arrays.asList(this.customCallerRunsGroup, this.customCallerRunsAnsWaitGroup)), this.uberGroup, this.parentGroup, schedulerName, this.traceLogger);
    }

    @Override
    protected ThreadPoolExecutor getCustomSchedulerDestroyerExecutor() {
        return this.uberExecutor;
    }

    @Override
    protected void shutdownPools() throws MuleException, InterruptedException {
        this.uberExecutor.shutdown();
    }

    @Override
    protected void waitForExecutorTermination(long shutdownStartMillis) throws InterruptedException {
        this.waitForExecutorTermination(shutdownStartMillis, this.uberExecutor, this.threadPoolsConfig.getThreadNamePrefix() + UBER_THREADS_NAME);
    }

    @Override
    protected void onStopCompleted() {
        this.uberExecutor = null;
    }

    @Override
    public boolean isCurrentThreadForCpuWork() {
        return Thread.currentThread().getThreadGroup() == this.uberGroup;
    }

    @Override
    protected List<Scheduler> getOwnSchedulers() {
        return new ArrayList<Scheduler>(this.activeSchedulers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String buildReportString() {
        int schedulersCustom;
        int uberSchedulers;
        StringBuilder threadPoolsReportBuilder = new StringBuilder();
        this.activeSchedulersReadLock.lock();
        try {
            uberSchedulers = this.activeSchedulers.size();
            schedulersCustom = this.activeCustomSchedulers.size();
        }
        finally {
            this.activeSchedulersReadLock.unlock();
        }
        int activeCount = this.uberExecutor.getActiveCount();
        long taskCount = this.uberExecutor.getTaskCount();
        long rejectedCount = ((ByCallerThreadGroupPolicy)this.uberExecutor.getRejectedExecutionHandler()).getRejectedCount();
        int customActiveCount = 0;
        int customUsedCount = 0;
        int customQueued = 0;
        long customTaskCount = 0L;
        long customRejected = 0L;
        for (ThreadPoolExecutor customExecutor : this.customSchedulersExecutors) {
            int currentCustomActive = customExecutor.getActiveCount();
            customActiveCount += currentCustomActive;
            customUsedCount += customExecutor.getPoolSize() - currentCustomActive;
            customQueued += customExecutor.getQueue().size();
            customTaskCount += customExecutor.getTaskCount();
            customRejected += ((ByCallerThreadGroupPolicy)customExecutor.getRejectedExecutionHandler()).getRejectedCount();
        }
        threadPoolsReportBuilder.append(System.lineSeparator() + this.name + System.lineSeparator());
        threadPoolsReportBuilder.append("--------------------------------------------------------------------------------------" + System.lineSeparator());
        threadPoolsReportBuilder.append("Pool          | Schedulers | Idle threads | Used threads | Queued tasks | Rejection % " + System.lineSeparator());
        threadPoolsReportBuilder.append("--------------------------------------------------------------------------------------" + System.lineSeparator());
        threadPoolsReportBuilder.append(String.format("Uber            | %10d | %12d | %12d | %12d | ~ %9.2f", uberSchedulers, this.uberExecutor.getPoolSize() - activeCount, activeCount, this.uberExecutor.getQueue().size(), rejectedCount > 0L ? 100.0 * (double)(rejectedCount / (taskCount + rejectedCount)) : 0.0) + System.lineSeparator());
        threadPoolsReportBuilder.append(String.format("Custom        | %10d | %12d | %12d | %12d | ~ %9.2f", schedulersCustom, customUsedCount, customActiveCount, customQueued, customRejected > 0L ? 100.0 * (double)(customRejected / (customTaskCount + customRejected)) : 0.0) + System.lineSeparator());
        threadPoolsReportBuilder.append("--------------------------------------------------------------------------------------" + System.lineSeparator() + System.lineSeparator());
        return threadPoolsReportBuilder.toString();
    }
}

