/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.threads;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.executor.ByCallerThreadGroupPolicy;
import org.mule.service.scheduler.internal.threads.CronSchedulerHandler;
import org.mule.service.scheduler.internal.threads.DedicatedSchedulerThreadPools;
import org.mule.service.scheduler.internal.threads.SchedulerThreadFactory;
import org.mule.service.scheduler.internal.threads.UberSchedulerThreadPools;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SchedulerThreadPools {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerThreadPools.class);
    private static final String TIMER_THREADS_NAME = "timer";
    private static final String CUSTOM_THREADS_NAME = ThreadType.CUSTOM.getName();
    private static final boolean ALWAYS_SHOW_SCHEDULER_CREATION_LOCATION = System.getProperties().containsKey("mule.scheduler.alwaysShowSchedulerCreationLocation");
    private final boolean preStartThreads;
    private final Consumer<AbstractExecutorService> preStartCallback;
    private final ReadWriteLock activeSchedulersLock = new ReentrantReadWriteLock();
    protected final String name;
    protected final ThreadGroup parentGroup;
    protected final SchedulerPoolsConfig threadPoolsConfig;
    protected final ThreadGroup timerGroup;
    protected final ThreadGroup customGroup;
    protected final ThreadGroup customWaitGroup;
    protected final ThreadGroup customCallerRunsGroup;
    protected final ThreadGroup customCallerRunsAnsWaitGroup;
    protected final Set<ThreadPoolExecutor> customSchedulersExecutors = new HashSet<ThreadPoolExecutor>();
    protected final Function<String, RejectedExecutionHandler> byCallerThreadGroupPolicy;
    protected final Lock activeSchedulersReadLock = this.activeSchedulersLock.readLock();
    protected final List<org.mule.runtime.api.scheduler.Scheduler> activeCustomSchedulers = new ArrayList<org.mule.runtime.api.scheduler.Scheduler>();
    protected final Lock activeSchedulersWriteLock = this.activeSchedulersLock.writeLock();
    protected final Logger traceLogger;
    protected ScheduledThreadPoolExecutor scheduledExecutor;
    private CronSchedulerHandler cronSchedulerHandler;
    protected Scheduler quartzScheduler;

    public static Builder builder(String name, SchedulerPoolsConfig config) {
        return new Builder(name, config);
    }

    protected SchedulerThreadPools(String name, SchedulerPoolsConfig threadPoolsConfig, boolean preStartThreads, Consumer<AbstractExecutorService> preStartCallback, Logger traceLogger) {
        this.name = name;
        this.threadPoolsConfig = threadPoolsConfig;
        this.preStartThreads = preStartThreads;
        this.preStartCallback = preStartCallback;
        this.traceLogger = traceLogger;
        this.parentGroup = new ThreadGroup(name){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error("Thread '" + t.getName() + "' stopped.", e);
            }
        };
        this.createCustomThreadGroups();
        this.timerGroup = new ThreadGroup(this.parentGroup, threadPoolsConfig.getThreadNamePrefix() + TIMER_THREADS_NAME);
        this.customGroup = new ThreadGroup(this.parentGroup, threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME);
        this.customWaitGroup = new ThreadGroup(this.customGroup, threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME);
        this.customCallerRunsGroup = new ThreadGroup(this.customGroup, threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME);
        this.customCallerRunsAnsWaitGroup = new ThreadGroup(this.customGroup, threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME);
        this.byCallerThreadGroupPolicy = this::createThreadGroupPolicy;
    }

    protected abstract ByCallerThreadGroupPolicy createThreadGroupPolicy(String var1);

    protected abstract void createCustomThreadGroups();

    public final void start() throws MuleException {
        if (SystemUtils.IS_JAVA_1_8) {
            this.prestartCoreThreads(ForkJoinPool.commonPool(), ForkJoinPool.getCommonPoolParallelism());
        }
        this.doStart(this.preStartThreads);
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, new SchedulerThreadFactory(this.timerGroup, "%s"));
        this.scheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduledExecutor.setRemoveOnCancelPolicy(true);
        this.cronSchedulerHandler = new CronSchedulerHandler(this.parentGroup, this.threadPoolsConfig.getThreadNamePrefix());
        try {
            this.quartzScheduler = this.cronSchedulerHandler.getScheduler();
            this.quartzScheduler.start();
        }
        catch (InterruptedException | SchedulerException e) {
            throw new LifecycleException(e, (Object)this);
        }
    }

    protected abstract void doStart(boolean var1) throws MuleException;

    protected BlockingQueue<Runnable> createQueue(int size) {
        return size == 0 ? new SynchronousQueue() : new LinkedBlockingQueue(size);
    }

    protected abstract void shutdownPools() throws MuleException, InterruptedException;

    public final void stop() throws MuleException, InterruptedException {
        this.shutdownPools();
        for (ThreadPoolExecutor customSchedulerExecutor : this.customSchedulersExecutors) {
            customSchedulerExecutor.shutdown();
        }
        this.scheduledExecutor.shutdown();
        try {
            this.quartzScheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
        long startMillis = System.currentTimeMillis();
        this.waitForExecutorTermination(startMillis, this.scheduledExecutor, this.threadPoolsConfig.getThreadNamePrefix() + TIMER_THREADS_NAME);
        this.waitForExecutorTermination(startMillis);
        for (ThreadPoolExecutor customSchedulerExecutor : new ArrayList<ThreadPoolExecutor>(this.customSchedulersExecutors)) {
            this.waitForExecutorTermination(startMillis, customSchedulerExecutor, ((SchedulerThreadFactory)customSchedulerExecutor.getThreadFactory()).getGroup().getName());
        }
        this.onStopCompleted();
        this.scheduledExecutor = null;
        this.quartzScheduler = null;
    }

    protected abstract void waitForExecutorTermination(long var1) throws InterruptedException;

    protected abstract void onStopCompleted();

    protected void waitForExecutorTermination(long startMillis, ExecutorService executor, String executorLabel) throws InterruptedException {
        if (!executor.awaitTermination(this.threadPoolsConfig.getGracefulShutdownTimeout().getAsLong() - (System.currentTimeMillis() - startMillis), TimeUnit.MILLISECONDS)) {
            List<Runnable> cancelledJobs = executor.shutdownNow();
            LOGGER.warn("'" + executorLabel + "' " + executor.toString() + " did not shutdown gracefully after " + this.threadPoolsConfig.getGracefulShutdownTimeout() + " milliseconds.");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The jobs " + cancelledJobs + " were cancelled.");
            } else {
                LOGGER.info(cancelledJobs.size() + " jobs were cancelled.");
            }
        }
    }

    public abstract org.mule.runtime.api.scheduler.Scheduler createCpuLightScheduler(SchedulerConfig var1, int var2, Supplier<Long> var3);

    public abstract org.mule.runtime.api.scheduler.Scheduler createIoScheduler(SchedulerConfig var1, int var2, Supplier<Long> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addScheduler(List<org.mule.runtime.api.scheduler.Scheduler> activeSchedulers, org.mule.runtime.api.scheduler.Scheduler scheduler) {
        this.activeSchedulersWriteLock.lock();
        try {
            boolean bl = activeSchedulers.add(scheduler);
            return bl;
        }
        finally {
            this.activeSchedulersWriteLock.unlock();
        }
    }

    public abstract org.mule.runtime.api.scheduler.Scheduler createCpuIntensiveScheduler(SchedulerConfig var1, int var2, Supplier<Long> var3);

    protected Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback(List<org.mule.runtime.api.scheduler.Scheduler> activeSchedulers) {
        return schr -> {
            this.activeSchedulersWriteLock.lock();
            try {
                activeSchedulers.remove(schr);
            }
            finally {
                this.activeSchedulersWriteLock.unlock();
            }
        };
    }

    protected void validateCustomSchedulerOnlyConfigNotChanged(SchedulerConfig config) {
        if (config.getWaitAllowed().isPresent()) {
            throw new IllegalArgumentException("Only custom schedulers may define 'waitAllowed' behaviour");
        }
        if (config.getDirectRunCpuLightWhenTargetBusy().isPresent()) {
            throw new IllegalArgumentException("Only custom schedulers may define 'directRunCpuLightWhenTargetBusy' behaviour");
        }
    }

    protected boolean shouldThrottle(SchedulerConfig config, OptionalInt backingPoolMaxSize) {
        return config.getMaxConcurrentTasks() != null && config.getMaxConcurrentTasks() < backingPoolMaxSize.orElse(Integer.MAX_VALUE);
    }

    public org.mule.runtime.api.scheduler.Scheduler createCustomScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout) {
        String threadsName = this.resolveCustomThreadsName(config);
        return this.doCreateCustomScheduler(config, workers, stopTimeout, this.resolveCustomSchedulerName(config), this.createQueue(config.getMaxConcurrentTasks()), threadsName);
    }

    public org.mule.runtime.api.scheduler.Scheduler createCustomScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout, int queueSize) {
        String threadsName = this.resolveCustomThreadsName(config);
        return this.doCreateCustomScheduler(config, workers, stopTimeout, this.resolveCustomSchedulerName(config), this.createQueue(queueSize), threadsName);
    }

    private org.mule.runtime.api.scheduler.Scheduler doCreateCustomScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout, String schedulerName, BlockingQueue<Runnable> workQueue, String threadsName) {
        if (config.getMaxConcurrentTasks() == null) {
            throw new IllegalArgumentException("Custom schedulers must define a thread pool size bi calling `config.withMaxConcurrentTasks()`");
        }
        ThreadGroup customChildGroup = new ThreadGroup(this.resolveThreadGroupForCustomScheduler(config), threadsName);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(config.getMaxConcurrentTasks(), config.getMaxConcurrentTasks(), 0L, TimeUnit.MILLISECONDS, workQueue, new SchedulerThreadFactory(customChildGroup, "%s.%02d"), this.byCallerThreadGroupPolicy.apply(customChildGroup.getName()));
        this.prestartCoreThreads(executor, config.getMaxConcurrentTasks());
        Set<ThreadPoolExecutor> executors = this.customSchedulersExecutors;
        CustomScheduler customScheduler = new CustomScheduler(schedulerName, executor, customChildGroup, workers, this.scheduledExecutor, this.quartzScheduler, this.getCustomSchedulerDestroyerExecutor(), ThreadType.CUSTOM, stopTimeout, this.shutdownCallback(this.activeCustomSchedulers).andThen(s -> executors.remove(executor)));
        executors.add(executor);
        this.addScheduler(this.activeCustomSchedulers, customScheduler);
        return customScheduler;
    }

    protected abstract ThreadPoolExecutor getCustomSchedulerDestroyerExecutor();

    protected void prestartCoreThreads(AbstractExecutorService executor, int corePoolSize) {
        CountDownLatch prestartWaitLatch = new CountDownLatch(1);
        CountDownLatch prestartLatch = new CountDownLatch(corePoolSize);
        ArrayList prestartFutures = new ArrayList(corePoolSize);
        String executorAsString = executor.toString();
        for (int i = 0; i < corePoolSize; ++i) {
            try {
                prestartFutures.add(executor.submit(() -> {
                    try {
                        prestartWaitLatch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new MuleRuntimeException((Throwable)e);
                    }
                    prestartLatch.countDown();
                    this.preStartCallback.accept(executor);
                }));
                continue;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                executor.shutdownNow();
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to prestart all core threads for executor:" + executorAsString)));
            }
        }
        prestartWaitLatch.countDown();
        try {
            if (!prestartLatch.await(30L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to prestart all core threads for executor:" + executorAsString)));
            }
            try {
                for (Future future : prestartFutures) {
                    future.get(30L, TimeUnit.SECONDS);
                }
            }
            catch (ExecutionException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to prestart all core threads for executor:" + executorAsString)), e.getCause());
            }
            catch (TimeoutException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to prestart all core threads for executor:" + executorAsString)), (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private ThreadGroup resolveThreadGroupForCustomScheduler(SchedulerConfig config) {
        if (config.getDirectRunCpuLightWhenTargetBusy().orElse(false).booleanValue() && config.getWaitAllowed().orElse(false).booleanValue()) {
            return this.customCallerRunsAnsWaitGroup;
        }
        if (config.getDirectRunCpuLightWhenTargetBusy().orElse(false).booleanValue()) {
            return this.customCallerRunsGroup;
        }
        if (config.getWaitAllowed().orElse(false).booleanValue()) {
            return this.customWaitGroup;
        }
        return this.customGroup;
    }

    private String resolveCustomSchedulerName(SchedulerConfig config) {
        return this.resolveSchedulerName(config, CUSTOM_THREADS_NAME);
    }

    protected String resolveSchedulerName(SchedulerConfig config, String prefix) {
        if (!config.hasName()) {
            config = config.withName(this.resolveSchedulerCreationLocation(prefix));
            return config.getSchedulerName();
        }
        if (ALWAYS_SHOW_SCHEDULER_CREATION_LOCATION) {
            return config.getSchedulerName() + " " + this.resolveSchedulerCreationLocation(null);
        }
        return config.getSchedulerName();
    }

    private String resolveCustomThreadsName(SchedulerConfig config) {
        if (config.hasName()) {
            return config.getSchedulerName();
        }
        return this.threadPoolsConfig.getThreadNamePrefix() + CUSTOM_THREADS_NAME;
    }

    private String resolveSchedulerCreationLocation(String prefix) {
        int i = 0;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement ste = stackTrace[i++];
        while (this.skip(ste) && i < stackTrace.length) {
            ste = stackTrace[i++];
        }
        ste = this.skip(ste) ? stackTrace[4] : stackTrace[i];
        return (prefix != null ? prefix : "") + "@" + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber();
    }

    private boolean skip(StackTraceElement ste) {
        return !ste.getClassName().contains("$Proxy");
    }

    public abstract boolean isCurrentThreadForCpuWork();

    public List<org.mule.runtime.api.scheduler.Scheduler> getSchedulers() {
        this.activeSchedulersReadLock.lock();
        try {
            LinkedList<org.mule.runtime.api.scheduler.Scheduler> schedulers = new LinkedList<org.mule.runtime.api.scheduler.Scheduler>(this.getOwnSchedulers());
            schedulers.addAll(this.activeCustomSchedulers);
            LinkedList<org.mule.runtime.api.scheduler.Scheduler> linkedList = schedulers;
            return linkedList;
        }
        finally {
            this.activeSchedulersReadLock.unlock();
        }
    }

    protected abstract List<org.mule.runtime.api.scheduler.Scheduler> getOwnSchedulers();

    public abstract String buildReportString();

    private static class CustomScheduler
    extends DefaultScheduler {
        private static final float THREADS_IN_GROUP_SIZE_MARGIN = 1.5f;
        private final ExecutorService executor;
        private final ThreadGroup threadGroup;
        private final ThreadPoolExecutor groupDestroyerExecutor;

        private CustomScheduler(String name, ExecutorService executor, ThreadGroup threadGroup, int workers, ScheduledExecutorService scheduledExecutor, Scheduler quartzScheduler, ThreadPoolExecutor groupDestroyerExecutor, ThreadType threadsType, Supplier<Long> shutdownTimeoutMillis, Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback) {
            super(name, executor, workers, scheduledExecutor, quartzScheduler, threadsType, shutdownTimeoutMillis, shutdownCallback);
            this.executor = executor;
            this.threadGroup = threadGroup;
            this.groupDestroyerExecutor = groupDestroyerExecutor;
        }

        @Override
        public void shutdown() {
            LOGGER.debug("Shutting down " + this.toString());
            this.doShutdown();
            this.executor.shutdown();
            this.shutdownCallback.accept(this);
        }

        @Override
        public List<Runnable> shutdownNow() {
            LOGGER.debug("Shutting down NOW " + this.toString());
            try {
                List<Runnable> cancelledTasks = this.doShutdownNow();
                this.executor.shutdownNow();
                List<Runnable> list = cancelledTasks;
                return list;
            }
            finally {
                this.shutdownWrapUp();
            }
        }

        @Override
        protected void stopFinally() {
            this.executor.shutdownNow();
            this.shutdownWrapUp();
        }

        private void shutdownWrapUp() {
            this.shutdownCallback.accept(this);
            if (this.threadGroup.equals(Thread.currentThread().getThreadGroup())) {
                this.groupDestroyerExecutor.execute(() -> this.destroyThreadGroup());
            } else {
                this.destroyThreadGroup();
            }
        }

        private void destroyThreadGroup() {
            IllegalThreadStateException destroyException = this.doDestroyThreadGroup();
            if (destroyException != null) {
                this.threadGroup.interrupt();
                destroyException = this.doDestroyThreadGroup();
            }
            this.tryTerminate();
            if (destroyException != null) {
                Thread[] threads = new Thread[(int)((float)this.threadGroup.activeCount() * 1.5f)];
                this.threadGroup.enumerate(threads, true);
                StringBuilder threadNamesBuilder = new StringBuilder();
                for (Thread thread : threads) {
                    if (thread == null) continue;
                    threadNamesBuilder.append("\t* " + thread.getName() + System.lineSeparator());
                    if (!LOGGER.isDebugEnabled()) continue;
                    StackTraceElement[] stackTrace = thread.getStackTrace();
                    for (int i = 1; i < stackTrace.length; ++i) {
                        threadNamesBuilder.append("\t\tat ").append(stackTrace[i]).append(System.lineSeparator());
                    }
                }
                LOGGER.error("Unable to destroy ThreadGroup '{}' of Scheduler '{}' ({}). Remaining threads in the group are:" + System.lineSeparator() + "{}", new Object[]{this.threadGroup.getName(), this.getName(), destroyException.toString(), threadNamesBuilder});
            }
        }

        private IllegalThreadStateException doDestroyThreadGroup() {
            IllegalThreadStateException destroyException = null;
            long durationMillis = (Long)this.shutdownTimeoutMillis.get();
            long stopNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(durationMillis) + TimeUnit.SECONDS.toNanos(1L);
            while (System.nanoTime() <= stopNanos && !this.threadGroup.isDestroyed()) {
                try {
                    this.threadGroup.destroy();
                    destroyException = null;
                }
                catch (IllegalThreadStateException e) {
                    destroyException = e;
                    try {
                        Thread.yield();
                        Thread.sleep(Math.min(50L, durationMillis));
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
                break;
            }
            return destroyException;
        }

        public String getThreadNameSuffix() {
            return null;
        }
    }

    public static class Builder {
        private final String name;
        private final SchedulerPoolsConfig threadPoolsConfig;
        private boolean preStartThreads = true;
        private Logger traceLogger = SchedulerThreadPools.access$000();
        private Consumer<AbstractExecutorService> preStartCallback = executor -> {};

        private Builder(String name, SchedulerPoolsConfig threadPoolsConfig) {
            this.name = name;
            this.threadPoolsConfig = threadPoolsConfig;
        }

        public Builder preStartThreads(boolean prestart) {
            this.preStartThreads = prestart;
            return this;
        }

        public Builder setTraceLogger(Logger traceLogger) {
            this.traceLogger = traceLogger;
            return this;
        }

        public Builder setPreStartCallback(Consumer<AbstractExecutorService> preStartCallback) {
            this.preStartCallback = preStartCallback;
            return this;
        }

        public SchedulerThreadPools build() {
            if (this.threadPoolsConfig.getSchedulerPoolStrategy() == SchedulerPoolStrategy.DEDICATED) {
                return new DedicatedSchedulerThreadPools(this.name, this.threadPoolsConfig, this.preStartThreads, this.preStartCallback, this.traceLogger);
            }
            if (this.threadPoolsConfig.getSchedulerPoolStrategy() == SchedulerPoolStrategy.UBER) {
                return new UberSchedulerThreadPools(this.name, this.threadPoolsConfig, this.preStartThreads, this.preStartCallback, this.traceLogger);
            }
            throw new IllegalArgumentException("Unsupported pool strategy type " + this.threadPoolsConfig.getSchedulerPoolStrategy());
        }
    }
}

