/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.junit.Test;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;

@Feature(value="Scheduler Service")
@Story(value="Exhaustion")
public class DefaultSchedulerExhaustionTestCase
extends BaseDefaultSchedulerTestCase {
    @Test
    @Description(value="Tests that trying to execute a runnable on a full executor fails due to exhaustion")
    public void failOnExhaustedExecute() {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        this.failOnExhausted(executor, exec -> exec.execute(() -> this.awaitLatch(latch)), EXECUTE_EMPTY_RUNNABLE, EXECUTE_EMPTY_RUNNABLE);
    }

    @Test
    @Description(value="Tests that trying to submit a runnable on a full executor fails due to exhaustion")
    public void failOnExhaustedSubmitRunnable() {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        this.failOnExhausted(executor, exec -> exec.submit(() -> this.awaitLatch(latch)), SUBMIT_EMPTY_RUNNABLE, SUBMIT_EMPTY_RUNNABLE);
    }

    @Test
    @Description(value="Tests that trying to submit a callable on a full executor fails due to exhaustion")
    public void failOnExhaustedSubmitCallable() {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        this.failOnExhausted(executor, exec -> exec.submit(() -> {
            this.awaitLatch(latch);
            return 0;
        }), SUBMIT_EMPTY_CALLABLE, SUBMIT_EMPTY_CALLABLE);
    }

    @Test
    @Description(value="Tests that trying to submit a runnable with result on a full executor fails due to exhaustion")
    public void failOnExhaustedSubmitCallableWithResult() {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        this.failOnExhausted(executor, exec -> exec.submit(() -> this.awaitLatch(latch), 0), SUBMIT_RESULT_RUNNABLE, SUBMIT_RESULT_RUNNABLE);
    }

    @Test
    public void failOnExhaustedMixed() {
        ScheduledExecutorService executor = this.createExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        this.failOnExhausted(executor, exec -> exec.submit(() -> this.awaitLatch(latch), 0), EXECUTE_EMPTY_RUNNABLE, SUBMIT_EMPTY_RUNNABLE);
    }

    private void failOnExhausted(ScheduledExecutorService executor, Consumer<ScheduledExecutorService> execute1, Consumer<ScheduledExecutorService> execute2, Consumer<ScheduledExecutorService> execute3) {
        execute1.accept(executor);
        execute2.accept(executor);
        this.expected.expect(CoreMatchers.instanceOf(RejectedExecutionException.class));
        execute3.accept(executor);
    }
}

