/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.number.IsCloseTo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class BaseDefaultSchedulerTestCase
extends AbstractMuleTestCase {
    protected static final int DELTA_MILLIS = 50;
    protected static final int EXECUTOR_TIMEOUT_SECS = 1;
    protected static final Runnable EMPTY_RUNNABLE = () -> {};
    protected static final Consumer<ScheduledExecutorService> SUBMIT_EMPTY_CALLABLE = exec -> exec.submit(() -> 0);
    protected static final Consumer<ScheduledExecutorService> SUBMIT_EMPTY_RUNNABLE = exec -> exec.submit(EMPTY_RUNNABLE);
    protected static final Consumer<ScheduledExecutorService> SUBMIT_RESULT_RUNNABLE = exec -> exec.submit(EMPTY_RUNNABLE, 0);
    protected static final Consumer<ScheduledExecutorService> EXECUTE_EMPTY_RUNNABLE = exec -> exec.execute(EMPTY_RUNNABLE);
    protected static final Consumer<org.mule.runtime.api.scheduler.Scheduler> EMPTY_SHUTDOWN_CALLBACK = sched -> {};
    @Rule
    public ExpectedException expected = ExpectedException.none();
    protected BlockingQueue<Runnable> sharedExecutorQueue = new ArrayBlockingQueue<Runnable>(1);
    protected ExecutorService sharedExecutor;
    protected ScheduledThreadPoolExecutor sharedScheduledExecutor;
    protected Scheduler sharedQuartzScheduler;

    @Before
    public void before() throws Exception {
        this.sharedExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, this.sharedExecutorQueue, Executors.defaultThreadFactory());
        this.sharedScheduledExecutor = (ScheduledThreadPoolExecutor)Mockito.spy((Object)new ScheduledThreadPoolExecutor(1, Executors.defaultThreadFactory()));
        this.sharedScheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.sharedScheduledExecutor.setRemoveOnCancelPolicy(true);
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        schedulerFactory.initialize(this.defaultQuartzProperties());
        this.sharedQuartzScheduler = (Scheduler)Mockito.spy((Object)schedulerFactory.getScheduler());
        this.sharedQuartzScheduler.start();
    }

    private Properties defaultQuartzProperties() {
        Properties factoryProperties = new Properties();
        factoryProperties.setProperty("org.quartz.scheduler.instanceName", ((Object)((Object)this)).getClass().getSimpleName());
        factoryProperties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        factoryProperties.setProperty("org.quartz.threadPool.threadNamePrefix", ((Object)((Object)this)).getClass().getSimpleName() + "_qz");
        factoryProperties.setProperty("org.quartz.threadPool.threadCount", "1");
        return factoryProperties;
    }

    @After
    public void after() throws Exception {
        this.sharedScheduledExecutor.shutdownNow();
        this.sharedQuartzScheduler.shutdown(true);
        this.sharedExecutor.shutdownNow();
        this.sharedScheduledExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        this.sharedExecutor.awaitTermination(5L, TimeUnit.SECONDS);
    }

    protected void assertTerminationIsNotDelayed(ScheduledExecutorService executor) throws InterruptedException {
        long startTime = System.nanoTime();
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime), (Matcher)IsCloseTo.closeTo((double)0.0, (double)50.0));
    }

    protected ScheduledExecutorService createExecutor() {
        return new DefaultScheduler(BaseDefaultSchedulerTestCase.class.getSimpleName(), this.sharedExecutor, 1, (ScheduledExecutorService)this.sharedScheduledExecutor, this.sharedQuartzScheduler, ThreadType.CUSTOM, () -> 5000L, EMPTY_SHUTDOWN_CALLBACK);
    }

    protected boolean awaitLatch(CountDownLatch latch) {
        try {
            return latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

