/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.service.scheduler.internal.SchedulerThreadPoolsTestCase;
import org.mule.service.scheduler.internal.config.ContainerThreadPoolsConfig;
import org.mule.service.scheduler.internal.threads.SchedulerThreadPools;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Scheduler Service")
@Story(value="Shutdown")
public class CustomSchedulerShutdownTestCase
extends AbstractMuleTestCase {
    private ContainerThreadPoolsConfig threadPoolsConfig;
    private SchedulerThreadPools service;
    private final long prestarCallbackSleepTime = 0L;

    @Before
    public void before() throws MuleException {
        this.threadPoolsConfig = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        this.service = SchedulerThreadPools.builder((String)SchedulerThreadPoolsTestCase.class.getName(), (SchedulerPoolsConfig)this.threadPoolsConfig).setPreStartCallback(executor -> {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new MuleRuntimeException((Throwable)e);
            }
        }).build();
        this.service.start();
    }

    @After
    public void after() throws MuleException, InterruptedException {
        if (this.service == null) {
            return;
        }
        for (Scheduler scheduler : new ArrayList(this.service.getSchedulers())) {
            scheduler.stop();
        }
        this.service.stop();
    }

    @Test
    public void shutdownDoesntDestroyThreadGroup() throws InterruptedException, ExecutionException {
        Scheduler customScheduler = this.service.createCustomScheduler(SchedulerConfig.config().withMaxConcurrentTasks(2), 2, () -> 10L);
        Latch latch = new Latch();
        AtomicReference executedThread = new AtomicReference();
        Future interrupted = customScheduler.submit(() -> {
            executedThread.set(Thread.currentThread());
            try {
                latch.await();
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return true;
            }
        });
        customScheduler.shutdown();
        Thread.sleep(5000L);
        latch.release();
        Assert.assertThat(interrupted.get(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shutdownNowDestroysThreadGroup() throws InterruptedException, ExecutionException {
        Scheduler customScheduler = this.service.createCustomScheduler(SchedulerConfig.config().withMaxConcurrentTasks(2), 2, () -> 10L);
        Latch latch = new Latch();
        AtomicReference executedThread = new AtomicReference();
        Future interrupted = customScheduler.submit(() -> {
            executedThread.set(Thread.currentThread());
            try {
                latch.await();
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return true;
            }
        });
        customScheduler.shutdownNow();
        Assert.assertThat((Object)interrupted.isCancelled(), (Matcher)Matchers.is((Object)true));
    }
}

