/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.number.IsCloseTo;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.QuartzCronJob;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

@Feature(value="Scheduler Service")
@Story(value="Quartz Task Scheduling")
public class DefaultSchedulerQuartzTestCase
extends BaseDefaultSchedulerTestCase {
    private static final int DELTA_MILLIS = 30;
    private DefaultScheduler executor;

    @Override
    public void before() throws Exception {
        super.before();
        this.executor = new DefaultScheduler(DefaultSchedulerQuartzTestCase.class.getSimpleName(), this.sharedExecutor, 1, (ScheduledExecutorService)this.sharedScheduledExecutor, this.sharedQuartzScheduler, ThreadType.CUSTOM, () -> 5000L, EMPTY_SHUTDOWN_CALLBACK);
    }

    @Override
    public void after() throws Exception {
        this.executor.shutdownNow();
        this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        super.after();
    }

    @Test
    @Description(value="Tests that a ScheduledFuture from a cron is properly cancelled before it starts executing")
    public void cancelCronBeforeFire() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture scheduled = this.executor.scheduleWithCronExpression(() -> this.awaitLatch(latch), "* * * ? * * 2099");
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed((ScheduledExecutorService)this.executor);
    }

    @Test
    @Description(value="Tests that a ScheduledFuture from a cron is properly cancelled while it's executing")
    public void cancelCronWhileRunning() throws InterruptedException {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ScheduledFuture scheduled = this.executor.scheduleWithCronExpression(() -> {
            latch1.countDown();
            this.awaitLatch(latch2);
        }, "1/10 * * ? * *");
        latch1.await();
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed((ScheduledExecutorService)this.executor);
    }

    @Test
    @Description(value="Tests that a ScheduledFuture from a cron is properly cancelled in-between executions")
    public void cancelCronInBetweenRuns() throws InterruptedException, ExecutionException {
        CountDownLatch latch = new CountDownLatch(1);
        ScheduledFuture scheduled = this.executor.scheduleWithCronExpression(() -> this.sharedScheduledExecutor.schedule(() -> latch.countDown(), 0L, TimeUnit.SECONDS), "0/30 * * ? * *");
        latch.await();
        scheduled.cancel(true);
        this.assertCancelled(scheduled);
        this.assertTerminationIsNotDelayed((ScheduledExecutorService)this.executor);
    }

    private void assertCancelled(ScheduledFuture<?> scheduled) {
        Assert.assertThat((Object)scheduled.isCancelled(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)scheduled.isDone(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Override
    protected void assertTerminationIsNotDelayed(ScheduledExecutorService executor) throws InterruptedException {
        long startTime = System.nanoTime();
        executor.shutdown();
        executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime), (Matcher)IsCloseTo.closeTo((double)0.0, (double)30.0));
    }

    @Test
    @Description(value="Tests that cron schedule parameters are honored")
    public void cronRepeats() throws SchedulerException {
        ArrayList startTimes = new ArrayList();
        ArrayList endTimes = new ArrayList();
        CountDownLatch latch = new CountDownLatch(3);
        String everyTwoSeconds = "0/2 * * ? * *";
        ScheduledFuture scheduled = this.executor.scheduleWithCronExpression(() -> {
            startTimes.add(System.nanoTime());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            latch.countDown();
            endTimes.add(System.nanoTime());
        }, "0/2 * * ? * *");
        Assert.assertThat((Object)this.awaitLatch(latch), (Matcher)CoreMatchers.is((Object)true));
        scheduled.cancel(true);
        ((Scheduler)Mockito.verify((Object)this.sharedQuartzScheduler)).scheduleJob((JobDetail)ArgumentMatchers.any(JobDetail.class), (Trigger)ArgumentMatchers.argThat((ArgumentMatcher)new CronTriggerMatcher("0/2 * * ? * *")));
    }

    @Test
    @Description(value="Tests that cron schedule parameters are honored even if the task takes longer than the interval")
    public void cronExceeds() throws SchedulerException {
        ArrayList startTimes = new ArrayList();
        ArrayList endTimes = new ArrayList();
        CountDownLatch latch = new CountDownLatch(2);
        String everySecond = "0/1 * * ? * *";
        ScheduledFuture scheduled = this.executor.scheduleWithCronExpression(() -> {
            startTimes.add(System.nanoTime());
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            latch.countDown();
            endTimes.add(System.nanoTime());
        }, "0/1 * * ? * *");
        Assert.assertThat((Object)this.awaitLatch(latch), (Matcher)CoreMatchers.is((Object)true));
        scheduled.cancel(true);
        ((Scheduler)Mockito.verify((Object)this.sharedQuartzScheduler)).scheduleJob((JobDetail)ArgumentMatchers.any(JobDetail.class), (Trigger)ArgumentMatchers.argThat((ArgumentMatcher)new CronTriggerMatcher("0/1 * * ? * *")));
        new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis((Long)startTimes.get(2) - (Long)endTimes.get(1)), (Matcher)IsCloseTo.closeTo((double)0.0, (double)30.0));
            return true;
        }));
    }

    @Test
    @Description(value="Tests that when scheduling with cron with no timezone, the default is passed on to quartz")
    public void cronWithDefaultTimezone() {
        this.executor.setJobClass(StoresTimeZoneJob.class);
        this.executor.scheduleWithCronExpression(() -> {}, "0/1 * * ? * *");
        new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)StoresTimeZoneJob.getTimeZone(), (Matcher)CoreMatchers.is((Object)TimeZone.getDefault()));
            return true;
        }));
    }

    @Test
    @Description(value="Tests that the timezone when scheduling with cron is passed on to quartz")
    public void cronWithCustom1Timezone() {
        this.executor.setJobClass(StoresTimeZoneJob.class);
        TimeZone timeZone = TimeZone.getTimeZone("America/Argentina/Buenos_Aires");
        this.executor.scheduleWithCronExpression(() -> {}, "0/1 * * ? * *", timeZone);
        new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)StoresTimeZoneJob.getTimeZone(), (Matcher)CoreMatchers.is((Object)timeZone));
            return true;
        }));
    }

    @Test
    @Description(value="Tests that the timezone when scheduling with cron is passed on to quartz. This test is needed in case that the previous test's timezone is the same as the default.")
    public void cronWithCustom2Timezone() {
        this.executor.setJobClass(StoresTimeZoneJob.class);
        TimeZone timeZone = TimeZone.getTimeZone("Europe/London");
        this.executor.scheduleWithCronExpression(() -> {}, "0/1 * * ? * *", timeZone);
        new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)StoresTimeZoneJob.getTimeZone(), (Matcher)CoreMatchers.is((Object)timeZone));
            return true;
        }));
    }

    public static class StoresTimeZoneJob
    extends QuartzCronJob
    implements Job {
        private static TimeZone timeZone;

        public void execute(JobExecutionContext context) throws JobExecutionException {
            timeZone = ((CronTrigger)context.getTrigger()).getTimeZone();
            super.execute(context);
        }

        public static TimeZone getTimeZone() {
            return timeZone;
        }
    }

    private static final class CronTriggerMatcher
    implements ArgumentMatcher<CronTrigger> {
        final String cronExpression;
        final TimeZone timeZone;

        public CronTriggerMatcher(String cronExpression) {
            this(cronExpression, TimeZone.getDefault());
        }

        public CronTriggerMatcher(String cronExpression, TimeZone timeZone) {
            this.cronExpression = cronExpression;
            this.timeZone = timeZone;
        }

        public boolean matches(CronTrigger item) {
            return item.getCronExpression().equals(this.cronExpression) && item.getTimeZone().equals(this.timeZone);
        }
    }
}

