/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import io.qameta.allure.Feature;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Optional;
import java.util.OptionalLong;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;
import org.mule.service.scheduler.internal.DefaultSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Feature(value="Scheduler Service")
public abstract class SchedulerServiceContractTestCase
extends AbstractMuleTestCase {
    protected DefaultSchedulerService service;

    @Before
    public void before() throws MuleException {
        this.service = new DefaultSchedulerService();
        this.service.start();
    }

    @After
    public void after() throws MuleException {
        this.service.stop();
    }

    @Test
    public void defaultNoConfig() {
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        this.service.cpuLightScheduler();
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        this.service.cpuLightScheduler();
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void artifactConfig() {
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        SchedulerPoolsConfigFactory configFactory = this.getMockConfigFactory();
        this.service.cpuLightScheduler(SchedulerConfig.config(), configFactory);
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)2));
        this.service.cpuLightScheduler(SchedulerConfig.config(), configFactory);
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void addWithArtifactConfig() {
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        this.service.cpuLightScheduler();
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        this.service.cpuLightScheduler(SchedulerConfig.config(), this.getMockConfigFactory());
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void artifactGarbageCollectedConfig() {
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
        SchedulerPoolsConfigFactory config = () -> Optional.of(this.getMockConfig());
        PhantomReference<SchedulerPoolsConfigFactory> configFactoryRef = new PhantomReference<SchedulerPoolsConfigFactory>(config, new ReferenceQueue());
        this.service.cpuLightScheduler(SchedulerConfig.config(), config);
        Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)2));
        config = null;
        new PollingProber(10000L, 500L).check((Probe)new JUnitLambdaProbe(() -> {
            System.gc();
            Assert.assertThat((Object)configFactoryRef.isEnqueued(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)this.service.getPools(), (Matcher)Matchers.hasSize((int)1));
            return true;
        }));
    }

    private SchedulerPoolsConfigFactory getMockConfigFactory() {
        SchedulerPoolsConfigFactory configFactory = (SchedulerPoolsConfigFactory)Mockito.mock(SchedulerPoolsConfigFactory.class);
        SchedulerPoolsConfig config = this.getMockConfig();
        Mockito.when((Object)configFactory.getConfig()).thenReturn(Optional.of(config));
        return configFactory;
    }

    private SchedulerPoolsConfig getMockConfig() {
        SchedulerPoolsConfig config = (SchedulerPoolsConfig)Mockito.mock(SchedulerPoolsConfig.class);
        Mockito.when((Object)config.getGracefulShutdownTimeout()).thenReturn((Object)OptionalLong.of(30000L));
        Mockito.when((Object)config.getThreadNamePrefix()).thenReturn((Object)"test");
        this.configure(config);
        return config;
    }

    protected abstract void configure(SchedulerPoolsConfig var1);
}

