/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;
import org.mule.service.scheduler.internal.DefaultScheduler;

@RunWith(value=Parameterized.class)
public class DefaultSchedulerProfilingTestCase
extends BaseDefaultSchedulerTestCase {
    private DefaultScheduler scheduler;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.scheduler = (DefaultScheduler)this.createExecutor();
    }

    @Parameterized.Parameters(name="Profiling feature: {0}")
    public static List<Object[]> parameters() {
        return Arrays.asList({Boolean.FALSE}, {Boolean.TRUE});
    }

    public DefaultSchedulerProfilingTestCase(Boolean isProfilingServiceEnabled) {
        this.isProfilingServiceEnabled = isProfilingServiceEnabled;
    }

    @Override
    @After
    public void after() throws Exception {
        this.scheduler.stop();
        this.scheduler = null;
        super.after();
    }

    @Test
    public void defaultSchedulerSubmitProfiling() throws InterruptedException {
        CountDownLatch remainingTasks = new CountDownLatch(2);
        this.scheduler.submit(remainingTasks::countDown);
        this.scheduler.submit(remainingTasks::countDown);
        this.assertProfiling(remainingTasks);
    }

    @Test
    public void defaultSchedulerScheduleProfiling() throws InterruptedException {
        CountDownLatch remainingTasks = new CountDownLatch(2);
        this.scheduler.scheduleWithFixedDelay(() -> {
            remainingTasks.countDown();
            throw new RuntimeException("Subsequent executions should be cancelled by this error");
        }, 0L, 365L, TimeUnit.DAYS);
        this.scheduler.scheduleWithFixedDelay(() -> {
            remainingTasks.countDown();
            throw new RuntimeException("Subsequent executions should be cancelled by this error");
        }, 0L, 365L, TimeUnit.DAYS);
        this.assertProfiling(remainingTasks);
    }

    private void assertProfiling(CountDownLatch remainingTasks) throws InterruptedException {
        remainingTasks.await();
        if (this.isProfilingServiceEnabled) {
            ((ProfilingDataProducer)Mockito.verify((Object)this.schedulingTaskDataProducer, (VerificationMode)Mockito.times((int)2))).triggerProfilingEvent((ProfilingEventContext)ArgumentMatchers.any());
            ((ProfilingDataProducer)Mockito.verify((Object)this.executingTaskDataProducer, (VerificationMode)Mockito.times((int)2))).triggerProfilingEvent((ProfilingEventContext)ArgumentMatchers.any());
            ((ProfilingDataProducer)Mockito.verify((Object)this.executedTaskDataProducer, (VerificationMode)Mockito.atLeastOnce())).triggerProfilingEvent((ProfilingEventContext)ArgumentMatchers.any());
        } else {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.schedulingTaskDataProducer});
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.executingTaskDataProducer});
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.executedTaskDataProducer});
        }
    }
}

