/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.alert.TimedDataBuffer;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.NullScheduledFuture;
import org.mule.service.scheduler.internal.executor.ByCallerThrottlingPolicy;
import org.quartz.Scheduler;

public class ThrottledScheduler
extends DefaultScheduler {
    private final ByCallerThrottlingPolicy throttlingPolicy;

    public ThrottledScheduler(String name, ExecutorService executor, int parallelTasksEstimate, ScheduledExecutorService scheduledExecutor, Scheduler quartzScheduler, ThreadType threadsType, ByCallerThrottlingPolicy throttingPolicy, Supplier<Long> shutdownTimeoutMillis, Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback, ProfilingService profilingService) {
        super(name, executor, parallelTasksEstimate, scheduledExecutor, quartzScheduler, threadsType, shutdownTimeoutMillis, shutdownCallback, profilingService);
        this.throttlingPolicy = throttingPolicy;
    }

    @Override
    protected void putTask(RunnableFuture<?> task, ScheduledFuture<?> scheduledFuture) {
        if (scheduledFuture instanceof NullScheduledFuture) {
            this.throttlingPolicy.throttle(() -> super.putTask(task, scheduledFuture), task, this);
        }
    }

    @Override
    protected ScheduledFuture<?> removeTask(RunnableFuture<?> task) {
        ScheduledFuture<?> removedTask = super.removeTask(task);
        if (removedTask != null) {
            this.throttlingPolicy.throttleWrapUp();
        }
        return removedTask;
    }

    @Override
    protected <T> Runnable schedulableTask(RunnableFuture<T> task, Runnable rejectionCallback) {
        return () -> this.throttlingPolicy.throttle(() -> {
            super.schedulableTask(task, rejectionCallback).run();
            this.throttlingPolicy.throttleWrapUp();
        }, task, this);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.throttlingPolicy.toString();
    }

    @Override
    public TimedDataBuffer<String> getThrottlesOverTime() {
        return this.throttlingPolicy.getThrottlesOverTime();
    }
}

