/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.config;

import io.qameta.allure.Description;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.service.scheduler.internal.config.ContainerThreadPoolsConfig;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

public class ThreadPoolsConfigTestCase
extends AbstractMuleTestCase {
    private static int CORES = Runtime.getRuntime().availableProcessors();
    private static long MEM = Runtime.getRuntime().maxMemory() / 1024L;
    @Rule
    public SystemProperty configFile = new SystemProperty("mule.schedulerPools.configFile", null);
    @Rule
    public SystemProperty configOverrideFile = new SystemProperty("org.mule.runtime.scheduler.io.threadPool.maxSize", null);
    @Rule
    public TemporaryFolder tempMuleHome = new TemporaryFolder();
    @Rule
    public TemporaryFolder tempOtherDir = new TemporaryFolder();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private File schedulerConfigFile;

    @Before
    public void before() {
        File confDir = new File(this.tempMuleHome.getRoot(), "conf");
        confDir.mkdir();
        this.schedulerConfigFile = new File(confDir, "scheduler-pools.conf");
        System.setProperty("mule.home", this.tempMuleHome.getRoot().getAbsolutePath());
    }

    @After
    public void after() {
        System.clearProperty("mule.home");
    }

    protected Properties buildDefaultConfigProps() {
        Properties props = new Properties();
        props.setProperty("org.mule.runtime.scheduler.gracefulShutdownTimeout", "15000");
        props.setProperty(ContainerThreadPoolsConfig.STRATEGY_PROPERTY_NAME, SchedulerPoolStrategy.UBER.name());
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.coreSize", "cores");
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.maxSize", "max(2, cores + ((mem - 245760) / 5120))");
        props.setProperty("org.mule.runtime.scheduler.uber.workQueue.size", "mem / (2*3*32)");
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.threadKeepAlive", "30000");
        return props;
    }

    @Test
    public void noMuleHome() throws IOException, MuleException {
        System.clearProperty("mule.home");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        this.assertDefaultSettings((SchedulerPoolsConfig)config);
    }

    private void assertDefaultSettings(SchedulerPoolsConfig config) {
        Assert.assertThat((Object)config.getGracefulShutdownTimeout().getAsLong(), (Matcher)CoreMatchers.is((Object)15000L));
        Assert.assertThat((Object)config.getSchedulerPoolStrategy(), (Matcher)CoreMatchers.is((Object)SchedulerPoolStrategy.UBER));
        Assert.assertThat((Object)config.getCpuLightPoolSize().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)config.getCpuLightQueueSize().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)config.getIoCorePoolSize().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)config.getIoMaxPoolSize().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)config.getIoKeepAlive().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)config.getUberCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)CORES));
        Assert.assertThat((Object)config.getUberMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)ContainerThreadPoolsConfig.BIG_POOL_DEFAULT_SIZE));
        Assert.assertThat((Object)config.getUberQueueSize().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        int queueSize = config.getUberQueueSize().getAsInt();
        if (queueSize > 0) {
            Assert.assertThat((Object)queueSize, (Matcher)CoreMatchers.is((Object)((int)MEM / 192)));
        } else {
            Assert.assertThat((Object)queueSize, (Matcher)CoreMatchers.is((Object)0));
        }
        Assert.assertThat((Object)config.getUberKeepAlive().getAsLong(), (Matcher)CoreMatchers.is((Object)30000L));
        Assert.assertThat((Object)config.getCpuIntensivePoolSize().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)config.getCpuIntensiveQueueSize().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void noConfigFile() throws MuleException {
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        this.assertDefaultSettings((SchedulerPoolsConfig)config);
    }

    @Test
    public void defaultConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.store(new FileOutputStream(this.schedulerConfigFile), "defaultConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        this.assertDefaultSettings((SchedulerPoolsConfig)config);
    }

    @Test
    public void dedicatedConfigSpaced() throws IOException, MuleException {
        Properties props = new Properties();
        props.setProperty(ContainerThreadPoolsConfig.STRATEGY_PROPERTY_NAME, SchedulerPoolStrategy.DEDICATED.name());
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.coreSize", "2 *cores");
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "workQueue.size", "mem/ (2* 3*32 )");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.maxSize", "cores* cores");
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "workQueue.size", "mem /( 2*3*32)");
        props.setProperty(ContainerThreadPoolsConfig.CPU_INTENSIVE_PREFIX + "." + "threadPool.coreSize", "2  *   cores");
        props.setProperty(ContainerThreadPoolsConfig.CPU_INTENSIVE_PREFIX + "." + "workQueue.size", "mem / ( 2*3*32) ");
        props.store(new FileOutputStream(this.schedulerConfigFile), "defaultConfigSpaced");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getSchedulerPoolStrategy(), (Matcher)CoreMatchers.is((Object)SchedulerPoolStrategy.DEDICATED));
        Assert.assertThat((Object)config.getGracefulShutdownTimeout().getAsLong(), (Matcher)CoreMatchers.is((Object)15000L));
        Assert.assertThat((Object)config.getCpuLightPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * CORES)));
        Assert.assertThat((Object)config.getCpuLightQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)(MEM / 192L))));
        Assert.assertThat((Object)config.getIoCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)CORES));
        Assert.assertThat((Object)config.getIoMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(CORES * CORES)));
        Assert.assertThat((Object)config.getIoQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)(MEM / 192L))));
        Assert.assertThat((Object)config.getIoKeepAlive().getAsLong(), (Matcher)CoreMatchers.is((Object)30000L));
        Assert.assertThat((Object)config.getCpuIntensivePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * CORES)));
        Assert.assertThat((Object)config.getCpuIntensiveQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)(MEM / 192L))));
    }

    @Test
    public void withDecimalsConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.coreSize", "0.5 *cores");
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.maxSize", "mem / (2* 2.5 *32)");
        props.store(new FileOutputStream(this.schedulerConfigFile), "withDecimalsConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getUberCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(CORES / 2)));
        Assert.assertThat((Object)config.getUberMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)((int)((double)MEM / 160.0))));
    }

    @Test
    public void withPlusAndMinusConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.coreSize", "cores - 1");
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.maxSize", "cores + cores");
        props.store(new FileOutputStream(this.schedulerConfigFile), "withPlusAndMinusConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getUberCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(CORES - 1)));
        Assert.assertThat((Object)config.getUberMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(CORES + CORES)));
    }

    @Test
    public void withMultiplyAndDivisionConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.coreSize", "cores / 0.5");
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.maxSize", "cores * 2");
        props.store(new FileOutputStream(this.schedulerConfigFile), "withMultiplyAndDivisionConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getUberCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * CORES)));
        Assert.assertThat((Object)config.getUberMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * CORES)));
    }

    @Test
    public void withParenthesisConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.coreSize", "cores * (1+1)");
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.maxSize", "(cores + 1) * 2");
        props.store(new FileOutputStream(this.schedulerConfigFile), "withParenthesisConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getUberCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * CORES)));
        Assert.assertThat((Object)config.getUberMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)(2 * (1 + CORES))));
    }

    @Test
    public void expressionConfigFixed() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.coreSize", "2");
        props.setProperty("org.mule.runtime.scheduler.uber.threadPool.maxSize", "8");
        props.setProperty("org.mule.runtime.scheduler.uber.workQueue.size", "4");
        props.store(new FileOutputStream(this.schedulerConfigFile), "expressionConfigFixed");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getUberCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)config.getUberMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)8));
        Assert.assertThat((Object)config.getUberQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)4));
    }

    @Test
    public void expressionConfigNegative() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.STRATEGY_PROPERTY_NAME, SchedulerPoolStrategy.DEDICATED.name());
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "cores - " + (CORES + 1));
        props.store(new FileOutputStream(this.schedulerConfigFile), "expressionConfigNegative");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.is((Object)(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size" + ": Value has to be greater than 0")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void zeroWorkQueueSize() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty("org.mule.runtime.scheduler.uber.workQueue.size", "0");
        props.store(new FileOutputStream(this.schedulerConfigFile), "expressionConfigNegative");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getUberQueueSize().getAsInt(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void invalidExpressionConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.STRATEGY_PROPERTY_NAME, SchedulerPoolStrategy.DEDICATED.name());
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "invalid");
        props.store(new FileOutputStream(this.schedulerConfigFile), "invalidExpressionConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.is((Object)(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size" + ": Expression not valid")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void nastyExpressionConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.STRATEGY_PROPERTY_NAME, SchedulerPoolStrategy.DEDICATED.name());
        props.setProperty(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size", "; print('aha!')");
        props.store(new FileOutputStream(this.schedulerConfigFile), "nastyExpressionConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.is((Object)(ContainerThreadPoolsConfig.CPU_LIGHT_PREFIX + "." + "threadPool.size" + ": Expression not valid")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void invalidShutdownTimeConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty("org.mule.runtime.scheduler.gracefulShutdownTimeout", "cores");
        props.store(new FileOutputStream(this.schedulerConfigFile), "invalidShutdownTimeConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectCause(CoreMatchers.instanceOf(NumberFormatException.class));
        this.expected.expectMessage(CoreMatchers.is((Object)"org.mule.runtime.scheduler.gracefulShutdownTimeout: For input string: \"cores\""));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void invalidIoKeepAliveConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.STRATEGY_PROPERTY_NAME, SchedulerPoolStrategy.DEDICATED.name());
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.threadKeepAlive", "notANumber");
        props.store(new FileOutputStream(this.schedulerConfigFile), "invalidIoKeepAliveConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectCause(CoreMatchers.instanceOf(NumberFormatException.class));
        this.expected.expectMessage(CoreMatchers.is((Object)(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.threadKeepAlive" + ": For input string: \"notANumber\"")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void negativeShutdownTimeConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.STRATEGY_PROPERTY_NAME, SchedulerPoolStrategy.UBER.name());
        props.setProperty("org.mule.runtime.scheduler.gracefulShutdownTimeout", "-1");
        props.store(new FileOutputStream(this.schedulerConfigFile), "negativeShutdownTimeConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.is((Object)"org.mule.runtime.scheduler.gracefulShutdownTimeout: Value has to be greater than or equal to 0"));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void negativeIoKeepAliveConfig() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.STRATEGY_PROPERTY_NAME, SchedulerPoolStrategy.DEDICATED.name());
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.threadKeepAlive", "-2");
        props.store(new FileOutputStream(this.schedulerConfigFile), "negativeIoKeepAliveConfig");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.is((Object)(ContainerThreadPoolsConfig.IO_PREFIX + "." + "threadPool.threadKeepAlive" + ": Value has to be greater than or equal to 0")));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    public void unevenParenthesis() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.setProperty(ContainerThreadPoolsConfig.STRATEGY_PROPERTY_NAME, SchedulerPoolStrategy.DEDICATED.name());
        props.setProperty(ContainerThreadPoolsConfig.IO_PREFIX + "." + "workQueue.size", "(-2");
        props.store(new FileOutputStream(this.schedulerConfigFile), "unevenParenthesis");
        this.expected.expect(DefaultMuleException.class);
        this.expected.expectMessage(CoreMatchers.startsWith((String)(ContainerThreadPoolsConfig.IO_PREFIX + "." + "workQueue.size")));
        this.expected.expectMessage(CoreMatchers.containsString((String)"<eval>:1:3 Expected ) but found eof"));
        ContainerThreadPoolsConfig.loadThreadPoolsConfig();
    }

    @Test
    @Description(value="For a missing entry in the config file, the default value is used")
    public void missingExpression() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.remove("org.mule.runtime.scheduler.uber.threadPool.maxSize");
        props.store(new FileOutputStream(this.schedulerConfigFile), "defaultConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getUberMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)ContainerThreadPoolsConfig.BIG_POOL_DEFAULT_SIZE));
    }

    @Test
    @Description(value="For a missing entry in the config file, the default value is used")
    public void missingValue() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.remove("org.mule.runtime.scheduler.uber.threadPool.threadKeepAlive");
        props.store(new FileOutputStream(this.schedulerConfigFile), "defaultConfig");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getUberKeepAlive().getAsLong(), (Matcher)CoreMatchers.is((Object)30000L));
    }

    @Test
    @Description(value="Tests that the mule.schedulerPools.configFile property is honored if present")
    public void overrideConfigFile() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.put("org.mule.runtime.scheduler.uber.threadPool.maxSize", "100");
        File overrideConfigFile = new File(this.tempOtherDir.getRoot(), "overriding.conf");
        props.store(new FileOutputStream(overrideConfigFile), "defaultConfig");
        System.setProperty("mule.schedulerPools.configFile", overrideConfigFile.getPath());
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getUberMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)100));
    }

    @Test
    @Description(value="Tests that the mule.schedulerPools.configFile pointing to an external url property is honored if present")
    @Ignore(value="Uncomment when we actually have a url with the new parameters")
    public void overrideConfigFileWithUrl() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.put("org.mule.runtime.scheduler.uber.threadPool.maxSize", "1");
        System.setProperty("mule.schedulerPools.configFile", "https://raw.githubusercontent.com/mulesoft/mule-distributions/mule-4.2.0/standalone/src/main/resources/conf/scheduler-pools.conf");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getIoCorePoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)CORES));
    }

    @Test
    @Description(value="Tests that system properties overriding the config from the file are honored if present")
    @Ignore(value="Uncomment when we actually have a url with the new paramters")
    public void overrideConfigWithIndividualProperty() throws IOException, MuleException {
        Properties props = this.buildDefaultConfigProps();
        props.put("org.mule.runtime.scheduler.uber.threadPool.maxSize", "1");
        System.setProperty("mule.schedulerPools.configFile", "https://raw.githubusercontent.com/mulesoft/mule-distributions/mule-4.2.0/standalone/src/main/resources/conf/scheduler-pools.conf");
        System.setProperty("org.mule.runtime.scheduler.io.threadPool.maxSize", "100");
        ContainerThreadPoolsConfig config = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
        Assert.assertThat((Object)config.getUberMaxPoolSize().getAsInt(), (Matcher)CoreMatchers.is((Object)100));
    }
}

