/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.profiling.tracing.ExecutionContext;
import org.mule.runtime.api.profiling.tracing.TracingService;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.RunnableFutureDecorator;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.slf4j.MDC;

public class RunnableFutureDecoratorTestCase
extends BaseDefaultSchedulerTestCase {
    private static final long GC_POLLING_TIMEOUT = 10000L;
    private DefaultScheduler scheduler;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.scheduler = (DefaultScheduler)this.createExecutor();
    }

    @Override
    @After
    public void after() throws Exception {
        this.scheduler.stop();
        this.scheduler = null;
        super.after();
    }

    @Test
    public void threadLocalValuesNotLeaked() throws InterruptedException, ExecutionException {
        ThreadLocalHolder tlHolder = new ThreadLocalHolder();
        Object valueToStore = new Object();
        PhantomReference<Object> ref = new PhantomReference<Object>(valueToStore, new ReferenceQueue());
        this.submitStore(tlHolder, valueToStore);
        valueToStore = null;
        new PollingProber(10000L, 100L).check((Probe)new JUnitLambdaProbe(() -> {
            System.gc();
            Assert.assertThat((Object)ref.isEnqueued(), (Matcher)Is.is((Object)true));
            return true;
        }, "A hard reference is being mantained to the value stored in a thread local."));
    }

    private void submitStore(ThreadLocalHolder tlHolder, Object valueToStore) throws InterruptedException, ExecutionException {
        this.scheduler.submit(() -> tlHolder.set(valueToStore)).get();
    }

    @Test
    public void mdcValuesNotSpreadAmongTasks() throws InterruptedException, ExecutionException {
        this.submitMdcPut();
        this.submitMdcGet();
    }

    @Test
    public void executionContextPropagation() {
        ExecutionContext currentExecutionContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.when((Object)this.profilingService.getTracingService().getCurrentExecutionContext()).thenReturn((Object)currentExecutionContext);
        RunnableFutureDecorator<Object> runnableFutureDecorator = this.getRunnableFutureDecorator(() -> null);
        runnableFutureDecorator.run();
        ((TracingService)Mockito.verify((Object)this.profilingService.getTracingService())).setCurrentExecutionContext(currentExecutionContext);
        ((TracingService)Mockito.verify((Object)this.profilingService.getTracingService())).deleteCurrentExecutionContext();
    }

    @Test
    public void failedTaskExecutionContextPropagation() {
        ExecutionContext currentExecutionContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.when((Object)this.profilingService.getTracingService().getCurrentExecutionContext()).thenReturn((Object)currentExecutionContext);
        RunnableFutureDecorator<Object> runnableFutureDecorator = this.getRunnableFutureDecorator(() -> {
            throw new RuntimeException("This exception should not alter the execution context propagation");
        });
        try {
            runnableFutureDecorator.run();
        }
        catch (RuntimeException e) {
            ((TracingService)Mockito.verify((Object)this.profilingService.getTracingService())).setCurrentExecutionContext(currentExecutionContext);
            ((TracingService)Mockito.verify((Object)this.profilingService.getTracingService())).deleteCurrentExecutionContext();
        }
    }

    private <T> RunnableFutureDecorator<T> getRunnableFutureDecorator(Callable<T> task) {
        return new RunnableFutureDecorator(new FutureTask<T>(task), ((Object)((Object)this)).getClass().getClassLoader(), this.scheduler, "testTask", 1, this.profilingService);
    }

    private void submitMdcPut() throws InterruptedException, ExecutionException {
        this.scheduler.submit(() -> MDC.put((String)"key", (String)"value")).get();
    }

    private void submitMdcGet() throws InterruptedException, ExecutionException {
        Assert.assertThat((Object)((String)this.scheduler.submit(() -> MDC.get((String)"key")).get()), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    public static final class ThreadLocalHolder {
        private final ThreadLocal threadLocal = new ThreadLocal();

        public void set(Object value) {
            this.threadLocal.set(value);
        }
    }
}

