/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.profiling.tracing.ExecutionContext;
import org.mule.runtime.api.profiling.tracing.TracingService;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.RunnableRepeatableFutureDecorator;

public class RunnableRepeatableFutureDecoratorTestCase
extends BaseDefaultSchedulerTestCase {
    private DefaultScheduler scheduler;
    private RunnableRepeatableFutureDecorator<Object> taskDecorator;

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.scheduler = (DefaultScheduler)this.createExecutor();
    }

    @Override
    @After
    public void after() throws Exception {
        this.scheduler.stop();
        this.scheduler = null;
        super.after();
    }

    @Test
    public void exceptionInWrapUpCallbackCompletesWrapUp() {
        ClassLoader taskClassloader = new ClassLoader(){};
        Runnable command = () -> {};
        this.taskDecorator = new RunnableRepeatableFutureDecorator(() -> new FutureTask<Object>(command, null), command, d -> {
            throw new WrapUpException();
        }, taskClassloader, this.scheduler, "testTask", -1, null);
        this.taskDecorator.run();
        MatcherAssert.assertThat((Object)this.taskDecorator.isStarted(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)Thread.currentThread().getContextClassLoader(), (Matcher)Matchers.not((Object)taskClassloader));
    }

    @Test
    public void repeatableSecondRunBeforeFirstWrapUp() {
        AtomicInteger runCount = new AtomicInteger(0);
        Runnable command = () -> runCount.incrementAndGet();
        this.taskDecorator = new RunnableRepeatableFutureDecorator(() -> new FutureTask<Object>(command, null), command, d -> {
            if (runCount.get() < 2) {
                this.taskDecorator.run();
            }
        }, RunnableRepeatableFutureDecoratorTestCase.class.getClassLoader(), this.scheduler, "testTask", -1, null);
        this.taskDecorator.run();
        MatcherAssert.assertThat((Object)this.taskDecorator.isStarted(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)runCount.get(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void executionContextPropagation() {
        ExecutionContext currentExecutionContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.when((Object)this.profilingService.getTracingService().getCurrentExecutionContext()).thenReturn((Object)currentExecutionContext);
        RunnableRepeatableFutureDecorator<?> runnableFutureDecorator = this.getRunnableRepeatableFutureDecorator(() -> {});
        runnableFutureDecorator.run();
        ((TracingService)Mockito.verify((Object)this.profilingService.getTracingService())).setCurrentExecutionContext(currentExecutionContext);
        ((TracingService)Mockito.verify((Object)this.profilingService.getTracingService())).deleteCurrentExecutionContext();
    }

    @Test
    public void failedTaskExecutionContextPropagation() {
        ExecutionContext currentExecutionContext = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.when((Object)this.profilingService.getTracingService().getCurrentExecutionContext()).thenReturn((Object)currentExecutionContext);
        RunnableRepeatableFutureDecorator<?> runnableFutureDecorator = this.getRunnableRepeatableFutureDecorator(() -> {
            throw new RuntimeException("This exception should not alter the execution context propagation");
        });
        try {
            runnableFutureDecorator.run();
        }
        catch (RuntimeException e) {
            ((TracingService)Mockito.verify((Object)this.profilingService.getTracingService())).setCurrentExecutionContext(currentExecutionContext);
            ((TracingService)Mockito.verify((Object)this.profilingService.getTracingService())).deleteCurrentExecutionContext();
        }
    }

    private RunnableRepeatableFutureDecorator<?> getRunnableRepeatableFutureDecorator(Runnable task) {
        return new RunnableRepeatableFutureDecorator(() -> new FutureTask<Object>(task, null), task, objectRunnableRepeatableFutureDecorator -> {}, RunnableRepeatableFutureDecoratorTestCase.class.getClassLoader(), this.scheduler, "testTask", 1, this.profilingService);
    }

    private static class WrapUpException
    extends RuntimeException {
        private static final long serialVersionUID = 5170908600838156528L;

        private WrapUpException() {
        }
    }
}

