/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.scheduler.SchedulerBusyException;
import org.mule.service.scheduler.internal.executor.ExceptionCollectingThreadGroup;
import org.mule.service.scheduler.internal.executor.LastRejectedWaitPolicy;
import org.mule.service.scheduler.internal.executor.SleepyTask;

public class WaitPolicyTestCase {
    private ExceptionCollectingThreadGroup threadGroup;
    ThreadPoolExecutor executor;
    ReentrantLock executorLock;

    @Before
    public void startExecutor() {
        this.executor = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1));
        this.executor.prestartAllCoreThreads();
        this.executorLock = new ReentrantLock(true);
        this.threadGroup = new ExceptionCollectingThreadGroup();
        SleepyTask.activeTasks.set(0);
    }

    @After
    public void shutDownExecutor() {
        this.executor.shutdown();
        this.threadGroup.destroy();
    }

    protected LinkedList<Thread> execute(List<Runnable> tasks) throws InterruptedException {
        if (tasks == null || tasks.isEmpty()) {
            throw new IllegalArgumentException("List<Runnable> must not be empty");
        }
        LinkedList<Thread> submitters = new LinkedList<Thread>();
        this.executorLock.lock();
        for (Runnable task : tasks) {
            Runnable submitterAction = () -> {
                try {
                    this.executorLock.lock();
                    this.executor.execute(task);
                }
                finally {
                    this.executorLock.unlock();
                }
            };
            Thread submitter = new Thread((ThreadGroup)this.threadGroup, submitterAction);
            submitter.setDaemon(true);
            submitters.add(submitter);
            submitter.start();
            while (submitter.isAlive() && !this.executorLock.hasQueuedThread(submitter)) {
                Thread.sleep(10L);
            }
        }
        this.executorLock.unlock();
        return submitters;
    }

    @Test
    public void testWaitPolicyForever() throws Exception {
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
        LastRejectedWaitPolicy policy = new LastRejectedWaitPolicy(-1L, TimeUnit.SECONDS);
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)policy));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("run", 1000L));
        tasks.add(new SleepyTask("queued", 1000L));
        SleepyTask waiting = new SleepyTask("waitingForever", 1000L);
        tasks.add(waiting);
        LinkedList<Thread> submitters = this.execute(tasks);
        Assert.assertFalse((boolean)submitters.isEmpty());
        Assert.assertFalse((boolean)this.executor.awaitTermination(4000L, TimeUnit.MILLISECONDS));
        Assert.assertSame((Object)waiting, (Object)policy.lastRejectedRunnable());
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
    }

    @Test
    public void testWaitPolicyWithTimeout() throws Exception {
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
        LastRejectedWaitPolicy policy = new LastRejectedWaitPolicy(2500L, TimeUnit.MILLISECONDS);
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)policy));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("run", 1000L));
        tasks.add(new SleepyTask("queued", 1000L));
        SleepyTask waiting = new SleepyTask("waiting", 1000L);
        tasks.add(waiting);
        LinkedList<Thread> submitters = this.execute(tasks);
        Assert.assertFalse((boolean)submitters.isEmpty());
        Assert.assertFalse((boolean)this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS));
        Assert.assertSame((Object)waiting, (Object)policy.lastRejectedRunnable());
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
    }

    @Test
    public void testWaitPolicyWithTimeoutFailure() throws Exception {
        Assert.assertEquals((long)0L, (long)SleepyTask.activeTasks.get());
        long failureInterval = 100L;
        LastRejectedWaitPolicy policy = new LastRejectedWaitPolicy(failureInterval, TimeUnit.MILLISECONDS);
        this.executor.setRejectedExecutionHandler((RejectedExecutionHandler)((Object)policy));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(new SleepyTask("run", 1000L));
        tasks.add(new SleepyTask("queued", 1000L));
        SleepyTask failedTask = new SleepyTask("waitAndFail", 1000L);
        tasks.add(failedTask);
        LinkedList<Thread> submitters = this.execute(tasks);
        Assert.assertFalse((boolean)submitters.isEmpty());
        Thread.sleep(failureInterval * 10L);
        LinkedList<Map<Thread, Throwable>> exceptions = this.threadGroup.collectedExceptions();
        MatcherAssert.assertThat(exceptions, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Map.Entry<Thread, Throwable> threadFailure = exceptions.getFirst().entrySet().iterator().next();
        MatcherAssert.assertThat((Object)threadFailure.getKey(), (Matcher)Matchers.is((Object)submitters.getLast()));
        MatcherAssert.assertThat((Object)threadFailure.getValue(), (Matcher)IsInstanceOf.instanceOf(SchedulerBusyException.class));
        this.executor.shutdown();
        MatcherAssert.assertThat((Object)this.executor.awaitTermination(2500L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)policy.lastRejectedRunnable(), (Matcher)Matchers.sameInstance((Object)failedTask));
        MatcherAssert.assertThat((Object)SleepyTask.activeTasks.get(), (Matcher)Matchers.is((Object)0));
    }
}

