/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.service.scheduler.internal.BaseDefaultSchedulerTestCase;

@RunWith(value=Parameterized.class)
public abstract class AbstractMuleVsJavaExecutorTestCase
extends BaseDefaultSchedulerTestCase {
    private Function<AbstractMuleVsJavaExecutorTestCase, ScheduledExecutorService> executorFactory;
    protected ScheduledExecutorService executor;

    public AbstractMuleVsJavaExecutorTestCase(Function<AbstractMuleVsJavaExecutorTestCase, ScheduledExecutorService> executorFactory, BlockingQueue<Runnable> sharedExecutorQueue, String param) {
        this.executorFactory = executorFactory;
        this.sharedExecutorQueue = sharedExecutorQueue;
    }

    @Parameterized.Parameters(name="{2}")
    public static Collection<Object[]> data() {
        return Arrays.asList({test -> test.useSharedScheduledExecutor(), new SynchronousQueue(), "java,syncQueue"}, {test -> test.useSharedScheduledExecutor(), new LinkedBlockingQueue(1), "java,queue(1)"}, {test -> test.createScheduledSameThreadExecutor(), new SynchronousQueue(), "mule,syncQueue"}, {test -> test.createScheduledSameThreadExecutor(), new LinkedBlockingQueue(1), "mule,queue(1)"});
    }

    @Override
    public void before() throws Exception {
        super.before();
        this.executor = this.createExecutor();
    }

    @Override
    public void after() throws Exception {
        this.executor.shutdownNow();
        this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        super.after();
    }

    @Override
    protected ScheduledExecutorService createExecutor() {
        return this.executorFactory.apply(this);
    }

    protected ScheduledExecutorService useSharedScheduledExecutor() {
        this.sharedScheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(true);
        this.sharedScheduledExecutor.setRemoveOnCancelPolicy(true);
        return this.sharedScheduledExecutor;
    }

    protected ScheduledExecutorService createScheduledSameThreadExecutor() {
        return super.createExecutor();
    }
}

