/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.scheduler.Scheduler;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.config.ThreadPoolsConfig;
import org.mule.service.scheduler.internal.threads.SchedulerThreadFactory;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulerService
implements SchedulerService,
Startable,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSchedulerService.class);
    private static final String CPU_LIGHT_THREADS_NAME = SchedulerService.class.getSimpleName() + "_" + ThreadType.CPU_LIGHT.getName();
    private static final String IO_THREADS_NAME = SchedulerService.class.getSimpleName() + "_" + ThreadType.IO.getName();
    private static final String COMPUTATION_THREADS_NAME = SchedulerService.class.getSimpleName() + "_" + ThreadType.CPU_INTENSIVE.getName();
    private static final String TIMER_THREADS_NAME = SchedulerService.class.getSimpleName() + "_timer";
    private static final String CUSTOM_THREADS_NAME = SchedulerService.class.getSimpleName() + "_" + ThreadType.CUSTOM.getName();
    private int cores = Runtime.getRuntime().availableProcessors();
    private ThreadPoolsConfig threadPoolsConfig;
    private final ThreadGroup schedulerGroup = new ThreadGroup(this.getName());
    private final ThreadGroup cpuLightGroup = new ThreadGroup(this.schedulerGroup, CPU_LIGHT_THREADS_NAME);
    private final ThreadGroup ioGroup = new ThreadGroup(this.schedulerGroup, IO_THREADS_NAME);
    private final ThreadGroup computationGroup = new ThreadGroup(this.schedulerGroup, COMPUTATION_THREADS_NAME);
    private final ThreadGroup timerGroup = new ThreadGroup(this.schedulerGroup, TIMER_THREADS_NAME);
    private final ThreadGroup customGroup = new ThreadGroup(this.schedulerGroup, CUSTOM_THREADS_NAME);
    private ExecutorService cpuLightExecutor;
    private ExecutorService ioExecutor;
    private ExecutorService computationExecutor;
    private Set<ExecutorService> customSchedulersExecutors = new HashSet<ExecutorService>();
    private ScheduledThreadPoolExecutor scheduledExecutor;
    private org.quartz.Scheduler quartzScheduler;

    public String getName() {
        return "SchedulerService";
    }

    public Scheduler cpuLightScheduler() {
        return new DefaultScheduler(this.resolveSchedulerCreationLocation(CPU_LIGHT_THREADS_NAME), this.cpuLightExecutor, 4 * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_LIGHT);
    }

    public Scheduler ioScheduler() {
        return new DefaultScheduler(this.resolveSchedulerCreationLocation(IO_THREADS_NAME), this.ioExecutor, this.cores * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO);
    }

    public Scheduler cpuIntensiveScheduler() {
        return new DefaultScheduler(this.resolveSchedulerCreationLocation(COMPUTATION_THREADS_NAME), this.computationExecutor, 4 * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_INTENSIVE);
    }

    public Scheduler customScheduler(String name, int corePoolSize) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new SchedulerThreadFactory(this.customGroup, "%s." + name + ".%02d"));
        CustomScheduler customScheduler = new CustomScheduler(this.resolveSchedulerCreationLocation(name), executor, this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CUSTOM);
        return customScheduler;
    }

    public Scheduler customScheduler(String name, int corePoolSize, int queueSize) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, corePoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new SchedulerThreadFactory(this.customGroup, "%s." + name + ".%02d"));
        CustomScheduler customScheduler = new CustomScheduler(this.resolveSchedulerCreationLocation(name), executor, this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CUSTOM);
        this.customSchedulersExecutors.add(customScheduler);
        return customScheduler;
    }

    private String resolveSchedulerCreationLocation(String prefix) {
        int i = 0;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement ste = stackTrace[i++];
        while (!ste.getClassName().contains("$Proxy") && i < stackTrace.length) {
            ste = stackTrace[i++];
        }
        ste = ste.getClassName().contains("$Proxy") ? stackTrace[i++] : stackTrace[2];
        return prefix + "@" + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber();
    }

    public ThreadType currentThreadType() {
        if (Thread.currentThread().getThreadGroup() == this.cpuLightGroup) {
            return ThreadType.CPU_LIGHT;
        }
        if (Thread.currentThread().getThreadGroup() == this.ioGroup) {
            return ThreadType.IO;
        }
        if (Thread.currentThread().getThreadGroup() == this.computationGroup) {
            return ThreadType.CPU_INTENSIVE;
        }
        if (Thread.currentThread().getThreadGroup() == this.customGroup) {
            return ThreadType.CUSTOM;
        }
        return ThreadType.UNKNOWN;
    }

    public void start() throws MuleException {
        logger.info("Starting " + this.toString() + "...");
        this.threadPoolsConfig = ThreadPoolsConfig.loadThreadPoolsConfig();
        this.cpuLightExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getCpuLightPoolSize(), this.threadPoolsConfig.getCpuLightPoolSize(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new SchedulerThreadFactory(this.cpuLightGroup));
        this.ioExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getIoCorePoolSize(), this.threadPoolsConfig.getIoMaxPoolSize(), this.threadPoolsConfig.getIoKeepAlive(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new SchedulerThreadFactory(this.ioGroup));
        this.computationExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getCpuIntensivePoolSize(), this.threadPoolsConfig.getCpuIntensivePoolSize(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new SchedulerThreadFactory(this.computationGroup));
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, new SchedulerThreadFactory(this.timerGroup, "%s"));
        this.scheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduledExecutor.setRemoveOnCancelPolicy(true);
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        try {
            schedulerFactory.initialize(this.threadPoolsConfig.defaultQuartzProperties(this.getName()));
            this.quartzScheduler = schedulerFactory.getScheduler();
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
        ((ThreadPoolExecutor)this.cpuLightExecutor).prestartAllCoreThreads();
        ((ThreadPoolExecutor)this.ioExecutor).prestartAllCoreThreads();
        ((ThreadPoolExecutor)this.computationExecutor).prestartAllCoreThreads();
        this.scheduledExecutor.prestartAllCoreThreads();
        logger.info("Started " + this.toString());
    }

    public void stop() throws MuleException {
        logger.info("Stopping " + this.toString() + "...");
        this.cpuLightExecutor.shutdown();
        this.ioExecutor.shutdown();
        this.computationExecutor.shutdown();
        for (ExecutorService customSchedulerExecutor : this.customSchedulersExecutors) {
            customSchedulerExecutor.shutdown();
        }
        this.scheduledExecutor.shutdown();
        try {
            this.quartzScheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
        try {
            long startMillis = System.currentTimeMillis();
            this.waitForExecutorTermination(startMillis, this.scheduledExecutor, TIMER_THREADS_NAME);
            this.waitForExecutorTermination(startMillis, this.cpuLightExecutor, CPU_LIGHT_THREADS_NAME);
            this.waitForExecutorTermination(startMillis, this.ioExecutor, IO_THREADS_NAME);
            this.waitForExecutorTermination(startMillis, this.computationExecutor, COMPUTATION_THREADS_NAME);
            for (ExecutorService customSchedulerExecutor : this.customSchedulersExecutors) {
                this.waitForExecutorTermination(startMillis, customSchedulerExecutor, COMPUTATION_THREADS_NAME);
            }
            logger.info("Stopped " + this.toString());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.info("Stop of " + this.toString() + " interrupted", (Throwable)e);
        }
        this.customSchedulersExecutors.clear();
        this.cpuLightExecutor = null;
        this.ioExecutor = null;
        this.computationExecutor = null;
        this.scheduledExecutor = null;
        this.quartzScheduler = null;
    }

    protected void waitForExecutorTermination(long startMillis, ExecutorService executor, String executorLabel) throws InterruptedException {
        if (!executor.awaitTermination(this.threadPoolsConfig.getGracefulShutdownTimeout() - (System.currentTimeMillis() - startMillis), TimeUnit.MILLISECONDS)) {
            List<Runnable> cancelledJobs = executor.shutdownNow();
            logger.warn("'" + executorLabel + "' " + executor.toString() + " of " + this.toString() + " did not shutdown gracefully after " + this.threadPoolsConfig.getGracefulShutdownTimeout() + " milliseconds.");
            if (logger.isDebugEnabled()) {
                logger.debug("The jobs " + cancelledJobs + " were cancelled.");
            } else {
                logger.info(cancelledJobs.size() + " jobs were cancelled.");
            }
        }
    }

    private class CustomScheduler
    extends DefaultScheduler {
        private final ExecutorService executor;

        private CustomScheduler(String name, ExecutorService executor, int workers, ScheduledExecutorService scheduledExecutor, org.quartz.Scheduler quartzScheduler, ThreadType threadsType) {
            super(name, executor, workers, scheduledExecutor, quartzScheduler, threadsType);
            this.executor = executor;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            this.executor.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            List<Runnable> cancelledTasks = super.shutdownNow();
            this.executor.shutdownNow();
            DefaultSchedulerService.this.customSchedulersExecutors.remove(this);
            return cancelledTasks;
        }
    }
}

