/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.lang.reflect.Field;
import java.util.concurrent.RunnableFuture;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRunnableFutureDecorator<V>
implements RunnableFuture<V> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRunnableFutureDecorator.class);
    private static Field threadLocalsField;
    private final Integer id;
    private volatile boolean started = false;

    protected static void clearAllThreadLocals() {
        try {
            threadLocalsField.set(Thread.currentThread(), null);
        }
        catch (Exception e) {
            new MuleRuntimeException((Throwable)e);
        }
    }

    protected AbstractRunnableFutureDecorator(Integer id) {
        this.id = id;
    }

    protected long beforeRun() {
        long startTime = 0L;
        if (logger.isTraceEnabled()) {
            startTime = System.nanoTime();
            logger.trace("Starting task " + this.toString() + "...");
        }
        this.started = true;
        return startTime;
    }

    protected void wrapUp() {
        this.started = false;
        AbstractRunnableFutureDecorator.clearAllThreadLocals();
    }

    boolean isStarted() {
        return this.started;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    static {
        try {
            threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

