/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.scheduler.SchedulerConfig;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.ThrottledScheduler;
import org.mule.service.scheduler.internal.config.ThreadPoolsConfig;
import org.mule.service.scheduler.internal.executor.ByCallerThreadGroupPolicy;
import org.mule.service.scheduler.internal.threads.SchedulerThreadFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulerService
implements SchedulerService,
Startable,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSchedulerService.class);
    private static final String CPU_LIGHT_THREADS_NAME = SchedulerService.class.getSimpleName() + "_" + ThreadType.CPU_LIGHT.getName();
    private static final String IO_THREADS_NAME = SchedulerService.class.getSimpleName() + "_" + ThreadType.IO.getName();
    private static final String COMPUTATION_THREADS_NAME = SchedulerService.class.getSimpleName() + "_" + ThreadType.CPU_INTENSIVE.getName();
    private static final String TIMER_THREADS_NAME = SchedulerService.class.getSimpleName() + "_timer";
    private static final String CUSTOM_THREADS_NAME = SchedulerService.class.getSimpleName() + "_" + ThreadType.CUSTOM.getName();
    private int cores = Runtime.getRuntime().availableProcessors();
    private ThreadPoolsConfig threadPoolsConfig;
    private final ThreadGroup schedulerGroup = new ThreadGroup(this.getName());
    private final ThreadGroup cpuLightGroup = new ThreadGroup(this.schedulerGroup, CPU_LIGHT_THREADS_NAME);
    private final ThreadGroup ioGroup = new ThreadGroup(this.schedulerGroup, IO_THREADS_NAME);
    private final ThreadGroup computationGroup = new ThreadGroup(this.schedulerGroup, COMPUTATION_THREADS_NAME);
    private final ThreadGroup timerGroup = new ThreadGroup(this.schedulerGroup, TIMER_THREADS_NAME);
    private final ThreadGroup customGroup = new ThreadGroup(this.schedulerGroup, CUSTOM_THREADS_NAME);
    private final ThreadGroup customWaitGroup = new ThreadGroup(this.customGroup, CUSTOM_THREADS_NAME);
    private final RejectedExecutionHandler byCallerThreadGroupPolicy = new ByCallerThreadGroupPolicy(new HashSet<ThreadGroup>(Arrays.asList(this.ioGroup, this.customWaitGroup)));
    private ThreadPoolExecutor cpuLightExecutor;
    private ThreadPoolExecutor ioExecutor;
    private ThreadPoolExecutor computationExecutor;
    private Set<ExecutorService> customSchedulersExecutors = new HashSet<ExecutorService>();
    private ScheduledThreadPoolExecutor scheduledExecutor;
    private Scheduler quartzScheduler;
    private volatile boolean started = false;
    private List<org.mule.runtime.api.scheduler.Scheduler> activeSchedulers = Collections.synchronizedList(new ArrayList());

    public String getName() {
        return "SchedulerService";
    }

    public org.mule.runtime.api.scheduler.Scheduler cpuLightScheduler() {
        this.checkStarted();
        DefaultScheduler scheduler = new DefaultScheduler(this.resolveSchedulerCreationLocation(CPU_LIGHT_THREADS_NAME), this.cpuLightExecutor, 4 * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_LIGHT, schr -> this.activeSchedulers.remove(schr));
        this.activeSchedulers.add(scheduler);
        return scheduler;
    }

    public org.mule.runtime.api.scheduler.Scheduler ioScheduler() {
        this.checkStarted();
        DefaultScheduler scheduler = new DefaultScheduler(this.resolveSchedulerCreationLocation(IO_THREADS_NAME), this.ioExecutor, this.cores * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, schr -> this.activeSchedulers.remove(schr));
        this.activeSchedulers.add(scheduler);
        return scheduler;
    }

    public org.mule.runtime.api.scheduler.Scheduler cpuIntensiveScheduler() {
        this.checkStarted();
        DefaultScheduler scheduler = new DefaultScheduler(this.resolveSchedulerCreationLocation(COMPUTATION_THREADS_NAME), this.computationExecutor, 4 * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_INTENSIVE, schr -> this.activeSchedulers.remove(schr));
        this.activeSchedulers.add(scheduler);
        return scheduler;
    }

    public org.mule.runtime.api.scheduler.Scheduler cpuLightScheduler(SchedulerConfig config) {
        this.checkStarted();
        if (config.getRejectionAction() != SchedulerConfig.RejectionAction.DEFAULT) {
            throw new IllegalArgumentException("Only custom schedulers may define waitDispatchingToBusyScheduler");
        }
        String schedulerName = this.resolveSchedulerName(config, CPU_LIGHT_THREADS_NAME);
        DefaultScheduler scheduler = config.getMaxConcurrentTasks() != null ? new ThrottledScheduler(schedulerName, this.cpuLightExecutor, 4 * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_LIGHT, config.getMaxConcurrentTasks(), schr -> this.activeSchedulers.remove(schr)) : new DefaultScheduler(schedulerName, this.cpuLightExecutor, 4 * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_LIGHT, schr -> this.activeSchedulers.remove(schr));
        this.activeSchedulers.add(scheduler);
        return scheduler;
    }

    public org.mule.runtime.api.scheduler.Scheduler ioScheduler(SchedulerConfig config) {
        this.checkStarted();
        if (config.getRejectionAction() != SchedulerConfig.RejectionAction.DEFAULT) {
            throw new IllegalArgumentException("Only custom schedulers may define waitDispatchingToBusyScheduler");
        }
        String schedulerName = this.resolveSchedulerName(config, IO_THREADS_NAME);
        DefaultScheduler scheduler = config.getMaxConcurrentTasks() != null ? new ThrottledScheduler(schedulerName, this.ioExecutor, this.cores * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, config.getMaxConcurrentTasks(), schr -> this.activeSchedulers.remove(schr)) : new DefaultScheduler(schedulerName, this.ioExecutor, this.cores * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, schr -> this.activeSchedulers.remove(schr));
        this.activeSchedulers.add(scheduler);
        return scheduler;
    }

    public org.mule.runtime.api.scheduler.Scheduler cpuIntensiveScheduler(SchedulerConfig config) {
        this.checkStarted();
        if (config.getRejectionAction() != SchedulerConfig.RejectionAction.DEFAULT) {
            throw new IllegalArgumentException("Only custom schedulers may define waitDispatchingToBusyScheduler");
        }
        String schedulerName = this.resolveSchedulerName(config, COMPUTATION_THREADS_NAME);
        DefaultScheduler scheduler = config.getMaxConcurrentTasks() != null ? new ThrottledScheduler(schedulerName, this.computationExecutor, 4 * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_INTENSIVE, config.getMaxConcurrentTasks(), schr -> this.activeSchedulers.remove(schr)) : new DefaultScheduler(schedulerName, this.computationExecutor, 4 * this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_INTENSIVE, schr -> this.activeSchedulers.remove(schr));
        this.activeSchedulers.add(scheduler);
        return scheduler;
    }

    private String resolveSchedulerName(SchedulerConfig config, String prefix) {
        if (config.getSchedulerName() == null) {
            return this.resolveSchedulerCreationLocation(prefix);
        }
        return config.getSchedulerName();
    }

    public org.mule.runtime.api.scheduler.Scheduler customScheduler(SchedulerConfig config) {
        this.checkStarted();
        if (config.getMaxConcurrentTasks() == null) {
            throw new IllegalArgumentException("Custom schedulers must define a thread pool size");
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(config.getMaxConcurrentTasks(), config.getMaxConcurrentTasks(), 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new SchedulerThreadFactory(this.resolveThreadGroupForCustomScheduler(config), "%s." + this.resolveSchedulerName(config, CUSTOM_THREADS_NAME) + ".%02d"), this.byCallerThreadGroupPolicy);
        CustomScheduler customScheduler = new CustomScheduler(this.resolveSchedulerName(config, CUSTOM_THREADS_NAME), executor, this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CUSTOM, schr -> this.activeSchedulers.remove(schr));
        this.activeSchedulers.add(customScheduler);
        return customScheduler;
    }

    public org.mule.runtime.api.scheduler.Scheduler customScheduler(SchedulerConfig config, int queueSize) {
        this.checkStarted();
        if (config.getMaxConcurrentTasks() == null) {
            throw new IllegalArgumentException("Custom schedulers must define a thread pool size");
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(config.getMaxConcurrentTasks(), config.getMaxConcurrentTasks(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new SchedulerThreadFactory(this.resolveThreadGroupForCustomScheduler(config), "%s." + this.resolveSchedulerName(config, CUSTOM_THREADS_NAME) + ".%02d"), this.byCallerThreadGroupPolicy);
        CustomScheduler customScheduler = new CustomScheduler(this.resolveSchedulerName(config, CUSTOM_THREADS_NAME), executor, this.cores, this.scheduledExecutor, this.quartzScheduler, ThreadType.CUSTOM, schr -> this.activeSchedulers.remove(schr));
        this.customSchedulersExecutors.add(customScheduler);
        this.activeSchedulers.add(customScheduler);
        return customScheduler;
    }

    private ThreadGroup resolveThreadGroupForCustomScheduler(SchedulerConfig config) {
        if (config.getRejectionAction() == SchedulerConfig.RejectionAction.WAIT) {
            return this.customWaitGroup;
        }
        return this.customGroup;
    }

    private void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Service " + this.getName() + " is not started.");
        }
    }

    private String resolveSchedulerCreationLocation(String prefix) {
        int i = 0;
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement ste = stackTrace[i++];
        while (this.skip(ste) && i < stackTrace.length) {
            ste = stackTrace[i++];
        }
        ste = this.skip(ste) ? stackTrace[2] : stackTrace[i++];
        return prefix + "@" + ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber();
    }

    private boolean skip(StackTraceElement ste) {
        return !ste.getClassName().contains("$Proxy");
    }

    public void start() throws MuleException {
        logger.info("Starting " + this.toString() + "...");
        this.threadPoolsConfig = ThreadPoolsConfig.loadThreadPoolsConfig();
        this.cpuLightExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getCpuLightPoolSize(), this.threadPoolsConfig.getCpuLightPoolSize(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.threadPoolsConfig.getCpuLightQueueSize()), new SchedulerThreadFactory(this.cpuLightGroup), this.byCallerThreadGroupPolicy);
        this.ioExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getIoCorePoolSize(), this.threadPoolsConfig.getIoMaxPoolSize(), this.threadPoolsConfig.getIoKeepAlive(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new SchedulerThreadFactory(this.ioGroup), this.byCallerThreadGroupPolicy);
        this.computationExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getCpuIntensivePoolSize(), this.threadPoolsConfig.getCpuIntensivePoolSize(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.threadPoolsConfig.getCpuIntensiveQueueSize()), new SchedulerThreadFactory(this.computationGroup), this.byCallerThreadGroupPolicy);
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, new SchedulerThreadFactory(this.timerGroup, "%s"));
        this.scheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduledExecutor.setRemoveOnCancelPolicy(true);
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        try {
            schedulerFactory.initialize(this.threadPoolsConfig.defaultQuartzProperties(this.getName()));
            this.quartzScheduler = schedulerFactory.getScheduler();
            this.quartzScheduler.start();
        }
        catch (SchedulerException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
        this.cpuLightExecutor.prestartAllCoreThreads();
        this.ioExecutor.prestartAllCoreThreads();
        this.computationExecutor.prestartAllCoreThreads();
        this.scheduledExecutor.prestartAllCoreThreads();
        logger.info("Started " + this.toString());
        this.started = true;
    }

    public void stop() throws MuleException {
        this.started = false;
        logger.info("Stopping " + this.toString() + "...");
        this.cpuLightExecutor.shutdown();
        this.ioExecutor.shutdown();
        this.computationExecutor.shutdown();
        for (ExecutorService customSchedulerExecutor : this.customSchedulersExecutors) {
            customSchedulerExecutor.shutdown();
        }
        this.scheduledExecutor.shutdown();
        try {
            this.quartzScheduler.shutdown(true);
        }
        catch (SchedulerException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
        try {
            long startMillis = System.currentTimeMillis();
            this.waitForExecutorTermination(startMillis, this.scheduledExecutor, TIMER_THREADS_NAME);
            this.waitForExecutorTermination(startMillis, this.cpuLightExecutor, CPU_LIGHT_THREADS_NAME);
            this.waitForExecutorTermination(startMillis, this.ioExecutor, IO_THREADS_NAME);
            this.waitForExecutorTermination(startMillis, this.computationExecutor, COMPUTATION_THREADS_NAME);
            for (ExecutorService customSchedulerExecutor : new ArrayList<ExecutorService>(this.customSchedulersExecutors)) {
                this.waitForExecutorTermination(startMillis, customSchedulerExecutor, COMPUTATION_THREADS_NAME);
            }
            logger.info("Stopped " + this.toString());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.info("Stop of " + this.toString() + " interrupted", (Throwable)e);
        }
        this.customSchedulersExecutors.clear();
        this.cpuLightExecutor = null;
        this.ioExecutor = null;
        this.computationExecutor = null;
        this.scheduledExecutor = null;
        this.quartzScheduler = null;
    }

    protected void waitForExecutorTermination(long startMillis, ExecutorService executor, String executorLabel) throws InterruptedException {
        if (!executor.awaitTermination(this.threadPoolsConfig.getGracefulShutdownTimeout() - (System.currentTimeMillis() - startMillis), TimeUnit.MILLISECONDS)) {
            List<Runnable> cancelledJobs = executor.shutdownNow();
            logger.warn("'" + executorLabel + "' " + executor.toString() + " of " + this.toString() + " did not shutdown gracefully after " + this.threadPoolsConfig.getGracefulShutdownTimeout() + " milliseconds.");
            if (logger.isDebugEnabled()) {
                logger.debug("The jobs " + cancelledJobs + " were cancelled.");
            } else {
                logger.info(cancelledJobs.size() + " jobs were cancelled.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<org.mule.runtime.api.scheduler.Scheduler> getSchedulers() {
        List<org.mule.runtime.api.scheduler.Scheduler> list = this.activeSchedulers;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<org.mule.runtime.api.scheduler.Scheduler>(this.activeSchedulers));
        }
    }

    private class CustomScheduler
    extends DefaultScheduler {
        private final ExecutorService executor;

        private CustomScheduler(String name, ExecutorService executor, int workers, ScheduledExecutorService scheduledExecutor, Scheduler quartzScheduler, ThreadType threadsType, Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback) {
            super(name, executor, workers, scheduledExecutor, quartzScheduler, threadsType, shutdownCallback);
            this.executor = executor;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            this.executor.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            DefaultSchedulerService.this.customSchedulersExecutors.remove(this);
            List<Runnable> cancelledTasks = super.shutdownNow();
            this.executor.shutdownNow();
            return cancelledTasks;
        }
    }
}

