/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.executor;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.mule.runtime.core.api.scheduler.SchedulerBusyException;
import org.mule.service.scheduler.internal.executor.WaitPolicy;

public final class ByCallerThreadGroupPolicy
implements RejectedExecutionHandler {
    private final ThreadPoolExecutor.AbortPolicy abort = new ThreadPoolExecutor.AbortPolicy(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            throw new SchedulerBusyException("Task " + r.toString() + " rejected from " + executor.toString());
        }
    };
    private final WaitPolicy wait = new WaitPolicy();
    private final Set<ThreadGroup> waitGroups;

    public ByCallerThreadGroupPolicy(Set<ThreadGroup> waitGroups) {
        this.waitGroups = Collections.unmodifiableSet(waitGroups);
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (Thread.currentThread().getThreadGroup() != null && this.waitGroups.contains(Thread.currentThread().getThreadGroup())) {
            this.wait.rejectedExecution(r, executor);
        } else {
            this.abort.rejectedExecution(r, executor);
        }
    }
}

