/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.service.scheduler.ThreadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolsConfig {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolsConfig.class);
    public static final String PROP_PREFIX = "org.mule.runtime.scheduler.";
    public static final String CPU_LIGHT_PREFIX = "org.mule.runtime.scheduler." + ThreadType.CPU_LIGHT.getName();
    public static final String IO_PREFIX = "org.mule.runtime.scheduler." + ThreadType.IO.getName();
    public static final String CPU_INTENSIVE_PREFIX = "org.mule.runtime.scheduler." + ThreadType.CPU_INTENSIVE.getName();
    public static final String THREAD_POOL = "threadPool";
    public static final String THREAD_POOL_SIZE = "threadPool.size";
    public static final String THREAD_POOL_SIZE_MAX = "threadPool.maxSize";
    public static final String THREAD_POOL_SIZE_CORE = "threadPool.coreSize";
    public static final String THREAD_POOL_KEEP_ALIVE = "threadPool.threadKeepAlive";
    public static final String WORK_QUEUE = "workQueue";
    public static final String WORK_QUEUE_SIZE = "workQueue.size";
    private static final String NUMBER_OR_VAR_REGEXP = "([0-9]+(\\.[0-9]+)?)|cores|mem";
    private static final Pattern POOLSIZE_PATTERN = Pattern.compile("(([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*");
    private static int cores = Runtime.getRuntime().availableProcessors();
    private static long mem = Runtime.getRuntime().maxMemory() / 1024L;
    private long gracefulShutdownTimeout = 15000L;
    private int cpuLightQueueSize = 1024;
    private int cpuLightPoolSize = 2 * cores;
    private int ioQueueSize = 1024;
    private int ioCorePoolSize = cores;
    private int ioMaxPoolSize = 256;
    private long ioKeepAlive = 30000L;
    private int cpuIntensiveQueueSize = 1024;
    private int cpuIntensivePoolSize = 2 * cores;

    public static ThreadPoolsConfig loadThreadPoolsConfig() throws MuleException {
        File muleHome = System.getProperty("mule.home") != null ? new File(System.getProperty("mule.home")) : null;
        ThreadPoolsConfig config = new ThreadPoolsConfig();
        if (muleHome == null) {
            logger.info("No mule.home defined. Using default values for thread pools.");
            return config;
        }
        File defaultConfigFile = new File(muleHome, "conf" + File.separator + "scheduler-pools.conf");
        if (!defaultConfigFile.exists()) {
            logger.info("No thread pools config file found. Using default values.");
            return config;
        }
        logger.info("Loading thread pools configuration from " + defaultConfigFile.getPath());
        Properties properties = new Properties();
        try (FileInputStream configIs = new FileInputStream(defaultConfigFile);){
            properties.load(configIs);
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("js");
        engine.put("cores", cores);
        engine.put("mem", mem);
        config.setGracefulShutdownTimeout(ThreadPoolsConfig.resolveNumber(properties, "org.mule.runtime.scheduler.gracefulShutdownTimeout"));
        config.setCpuLightPoolSize(ThreadPoolsConfig.resolveExpression(properties, CPU_LIGHT_PREFIX + "." + THREAD_POOL_SIZE, config, engine));
        config.setCpuLightQueueSize(ThreadPoolsConfig.resolveExpression(properties, CPU_LIGHT_PREFIX + "." + WORK_QUEUE_SIZE, config, engine));
        config.setIoCorePoolSize(Math.max(4, ThreadPoolsConfig.resolveExpression(properties, IO_PREFIX + "." + THREAD_POOL_SIZE_CORE, config, engine)));
        config.setIoMaxPoolSize(ThreadPoolsConfig.resolveExpression(properties, IO_PREFIX + "." + THREAD_POOL_SIZE_MAX, config, engine));
        config.setIoQueueSize(ThreadPoolsConfig.resolveExpression(properties, IO_PREFIX + "." + WORK_QUEUE_SIZE, config, engine));
        config.setIoKeepAlive(ThreadPoolsConfig.resolveNumber(properties, IO_PREFIX + "." + THREAD_POOL_KEEP_ALIVE));
        config.setCpuIntensivePoolSize(ThreadPoolsConfig.resolveExpression(properties, CPU_INTENSIVE_PREFIX + "." + THREAD_POOL_SIZE, config, engine));
        config.setCpuIntensiveQueueSize(ThreadPoolsConfig.resolveExpression(properties, CPU_INTENSIVE_PREFIX + "." + WORK_QUEUE_SIZE, config, engine));
        return config;
    }

    private static long resolveNumber(Properties properties, String propName) throws DefaultMuleException {
        String property = properties.getProperty(propName);
        try {
            long result = Long.parseLong(property);
            if (result <= 0L) {
                throw new DefaultMuleException(propName + ": Value has to be greater than 0");
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new DefaultMuleException(propName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static int resolveExpression(Properties properties, String propName, ThreadPoolsConfig threadPoolsConfig, ScriptEngine engine) throws DefaultMuleException {
        String property = properties.getProperty(propName).trim().toLowerCase();
        if (!POOLSIZE_PATTERN.matcher(property).matches()) {
            throw new DefaultMuleException(propName + ": Expression not valid");
        }
        try {
            int result = ((Number)engine.eval(property)).intValue();
            if (result <= 0) {
                throw new DefaultMuleException(propName + ": Value has to be greater than 0");
            }
            return result;
        }
        catch (ScriptException e) {
            throw new DefaultMuleException(propName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private ThreadPoolsConfig() {
    }

    public long getGracefulShutdownTimeout() {
        return this.gracefulShutdownTimeout;
    }

    private void setGracefulShutdownTimeout(long gracefulShutdownTimeout) {
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
    }

    public int getCpuLightPoolSize() {
        return this.cpuLightPoolSize;
    }

    private void setCpuLightPoolSize(int cpuLightPoolSize) {
        this.cpuLightPoolSize = cpuLightPoolSize;
    }

    public int getCpuLightQueueSize() {
        return this.cpuLightQueueSize;
    }

    private void setCpuLightQueueSize(int cpuLightQueueSize) {
        this.cpuLightQueueSize = cpuLightQueueSize;
    }

    public int getIoCorePoolSize() {
        return this.ioCorePoolSize;
    }

    private void setIoCorePoolSize(int ioCorePoolSize) {
        this.ioCorePoolSize = ioCorePoolSize;
    }

    public int getIoMaxPoolSize() {
        return this.ioMaxPoolSize;
    }

    private void setIoMaxPoolSize(int ioMaxPoolSize) {
        this.ioMaxPoolSize = ioMaxPoolSize;
    }

    public int getIoQueueSize() {
        return this.ioQueueSize;
    }

    private void setIoQueueSize(int ioQueueSize) {
        this.ioQueueSize = ioQueueSize;
    }

    public long getIoKeepAlive() {
        return this.ioKeepAlive;
    }

    private void setIoKeepAlive(long ioKeepAlive) {
        this.ioKeepAlive = ioKeepAlive;
    }

    public int getCpuIntensivePoolSize() {
        return this.cpuIntensivePoolSize;
    }

    private void setCpuIntensivePoolSize(int cpuIntensivePoolSize) {
        this.cpuIntensivePoolSize = cpuIntensivePoolSize;
    }

    public int getCpuIntensiveQueueSize() {
        return this.cpuIntensiveQueueSize;
    }

    private void setCpuIntensiveQueueSize(int cpuIntensiveQueueSize) {
        this.cpuIntensiveQueueSize = cpuIntensiveQueueSize;
    }

    public Properties defaultQuartzProperties(String name) {
        Properties factoryProperties = new Properties();
        factoryProperties.setProperty("org.quartz.scheduler.instanceName", name);
        factoryProperties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        factoryProperties.setProperty("org.quartz.threadPool.threadNamePrefix", name + "_qz");
        factoryProperties.setProperty("org.quartz.threadPool.threadCount", "1");
        return factoryProperties;
    }
}

