/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mule.service.scheduler.internal.AbstractRunnableFutureDecorator;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunnableFutureDecorator<V>
extends AbstractRunnableFutureDecorator<V> {
    private static final Logger logger = LoggerFactory.getLogger(RunnableFutureDecorator.class);
    private final RunnableFuture<V> task;
    private final ClassLoader classLoader;
    private final DefaultScheduler scheduler;
    private final String taskAsString;

    RunnableFutureDecorator(RunnableFuture<V> task, ClassLoader classLoader, DefaultScheduler scheduler, String taskAsString, Integer id) {
        super(id);
        this.task = task;
        this.classLoader = classLoader;
        this.scheduler = scheduler;
        this.taskAsString = taskAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = this.beforeRun();
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.classLoader);
        try {
            this.task.run();
            this.task.get();
        }
        catch (ExecutionException e) {
            logger.error("Uncaught throwable in task " + this.toString(), (Throwable)e);
        }
        catch (CancellationException e) {
            logger.trace("Task " + this.toString() + " cancelled");
        }
        catch (InterruptedException e) {
            currentThread.interrupt();
        }
        finally {
            this.wrapUp();
            if (logger.isTraceEnabled()) {
                logger.trace("Task " + this.toString() + " finished after " + (System.nanoTime() - startTime) + " nanoseconds");
            }
            currentThread.setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    protected void wrapUp() {
        this.scheduler.taskFinished(this);
        super.wrapUp();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (logger.isDebugEnabled()) {
            logger.debug("Cancelling task " + this.toString() + " (mayInterruptIfRunning=" + mayInterruptIfRunning + ")...");
        }
        boolean success = this.task.cancel(mayInterruptIfRunning);
        this.scheduler.taskFinished(this);
        return success;
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.task.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.task.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.task.get(timeout, unit);
    }

    public String toString() {
        return this.taskAsString;
    }
}

