/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.mule.runtime.extension.api.soap.security.PasswordType;
import org.mule.runtime.extension.api.soap.security.UsernameTokenSecurityStrategy;
import org.mule.service.soap.security.SecurityStrategyCxfAdapter;
import org.mule.service.soap.security.SecurityStrategyType;
import org.mule.service.soap.security.callback.WSPasswordCallbackHandler;

public class WssUsernameTokenSecurityStrategyCxfAdapter
implements SecurityStrategyCxfAdapter {
    private String username;
    private String password;
    private PasswordType passwordType;
    private boolean addNonce;
    private boolean addCreated;

    public WssUsernameTokenSecurityStrategyCxfAdapter(UsernameTokenSecurityStrategy usernameToken) {
        this.addCreated = usernameToken.isAddCreated();
        this.addNonce = usernameToken.isAddNonce();
        this.password = usernameToken.getPassword();
        this.username = usernameToken.getUsername();
        this.passwordType = usernameToken.getPasswordType();
    }

    @Override
    public SecurityStrategyType securityType() {
        return SecurityStrategyType.OUTGOING;
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.of(new WSPasswordCallbackHandler(2, cb -> {
            if (cb.getIdentifier().equals(this.username)) {
                cb.setPassword(this.password);
            }
        }));
    }

    @Override
    public String securityAction() {
        return "UsernameToken";
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"user", (Object)this.username);
        builder.put((Object)"passwordType", (Object)this.passwordType.getType());
        if (this.addCreated || this.addNonce) {
            StringJoiner additionalElements = new StringJoiner(" ");
            if (this.addNonce) {
                additionalElements.add("Nonce");
            }
            if (this.addCreated) {
                additionalElements.add("Created");
            }
            builder.put((Object)"addUTElements", (Object)additionalElements.toString());
        }
        return builder.build();
    }
}

