/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.client;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.interceptor.CheckFaultInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap11FaultInInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.WrappedOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.mule.runtime.extension.api.soap.security.DecryptSecurityStrategy;
import org.mule.runtime.extension.api.soap.security.EncryptSecurityStrategy;
import org.mule.runtime.extension.api.soap.security.SecurityStrategy;
import org.mule.runtime.extension.api.soap.security.SecurityStrategyVisitor;
import org.mule.runtime.extension.api.soap.security.SignSecurityStrategy;
import org.mule.runtime.extension.api.soap.security.TimestampSecurityStrategy;
import org.mule.runtime.extension.api.soap.security.UsernameTokenSecurityStrategy;
import org.mule.runtime.extension.api.soap.security.VerifySignatureSecurityStrategy;
import org.mule.runtime.soap.api.SoapVersion;
import org.mule.runtime.soap.api.client.SoapClientConfiguration;
import org.mule.service.soap.interceptor.NamespaceRestorerStaxInterceptor;
import org.mule.service.soap.interceptor.NamespaceSaverStaxInterceptor;
import org.mule.service.soap.interceptor.OutputMtomSoapAttachmentsInterceptor;
import org.mule.service.soap.interceptor.OutputSoapHeadersInterceptor;
import org.mule.service.soap.interceptor.SoapActionInterceptor;
import org.mule.service.soap.interceptor.StreamClosingInterceptor;
import org.mule.service.soap.security.SecurityStrategyCxfAdapter;
import org.mule.service.soap.security.SecurityStrategyType;
import org.mule.service.soap.security.WssDecryptSecurityStrategyCxfAdapter;
import org.mule.service.soap.security.WssEncryptSecurityStrategyCxfAdapter;
import org.mule.service.soap.security.WssSignSecurityStrategyCxfAdapter;
import org.mule.service.soap.security.WssTimestampSecurityStrategyCxfAdapter;
import org.mule.service.soap.security.WssUsernameTokenSecurityStrategyCxfAdapter;
import org.mule.service.soap.security.WssVerifySignatureSecurityStrategyCxfAdapter;
import org.mule.service.soap.security.callback.CompositeCallbackHandler;
import org.mule.service.soap.transport.SoapServiceTransportFactory;

class CxfClientProvider {
    private final SoapServiceTransportFactory factory = new SoapServiceTransportFactory();

    CxfClientProvider() {
    }

    Client getClient(SoapClientConfiguration configuration) {
        boolean isMtom = configuration.isMtomEnabled();
        String address = configuration.getAddress();
        SoapVersion version = configuration.getVersion();
        Client client = this.factory.createClient(address, version.getVersion());
        this.addSecurityInterceptors(client, this.getAdaptedSecurities(configuration.getSecurities()));
        this.addRequestInterceptors(client);
        this.addResponseInterceptors(client, isMtom);
        client.getEndpoint().put((Object)"mtom-enabled", (Object)isMtom);
        this.removeUnnecessaryCxfInterceptors(client);
        return client;
    }

    private List<SecurityStrategyCxfAdapter> getAdaptedSecurities(List<SecurityStrategy> securities) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        securities.forEach(s -> s.accept(new SecurityStrategyVisitor(){

            public void visitEncrypt(EncryptSecurityStrategy encrypt) {
                builder.add((Object)new WssEncryptSecurityStrategyCxfAdapter(encrypt.getKeyStoreConfiguration()));
            }

            public void visitDecrypt(DecryptSecurityStrategy decrypt) {
                builder.add((Object)new WssDecryptSecurityStrategyCxfAdapter(decrypt.getKeyStoreConfiguration()));
            }

            public void visitUsernameToken(UsernameTokenSecurityStrategy usernameToken) {
                builder.add((Object)new WssUsernameTokenSecurityStrategyCxfAdapter(usernameToken));
            }

            public void visitSign(SignSecurityStrategy sign) {
                builder.add((Object)new WssSignSecurityStrategyCxfAdapter(sign.getKeyStoreConfiguration()));
            }

            public void visitVerify(VerifySignatureSecurityStrategy verify) {
                WssVerifySignatureSecurityStrategyCxfAdapter adapter = verify.getTrustStoreConfiguration().map(WssVerifySignatureSecurityStrategyCxfAdapter::new).orElse(new WssVerifySignatureSecurityStrategyCxfAdapter());
                builder.add((Object)adapter);
            }

            public void visitTimestamp(TimestampSecurityStrategy timestamp) {
                builder.add((Object)new WssTimestampSecurityStrategyCxfAdapter(timestamp.getTimeToLeaveInSeconds()));
            }
        }));
        return builder.build();
    }

    private void addSecurityInterceptors(Client client, List<SecurityStrategyCxfAdapter> securityStrategies) {
        Map<String, Object> responseProps;
        Map<String, Object> requestProps = this.buildSecurityProperties(securityStrategies, SecurityStrategyType.OUTGOING);
        if (!requestProps.isEmpty()) {
            client.getOutInterceptors().add(new WSS4JOutInterceptor(requestProps));
        }
        if (!(responseProps = this.buildSecurityProperties(securityStrategies, SecurityStrategyType.INCOMING)).isEmpty()) {
            client.getInInterceptors().add(new WSS4JInInterceptor(responseProps));
        }
    }

    private Map<String, Object> buildSecurityProperties(List<SecurityStrategyCxfAdapter> strategies, SecurityStrategyType type) {
        String actions;
        if (strategies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        StringJoiner actionsJoiner = new StringJoiner(" ");
        ImmutableList.Builder callbackHandlersBuilder = ImmutableList.builder();
        strategies.stream().filter(s -> s.securityType().equals((Object)type)).forEach(s -> {
            props.putAll(s.buildSecurityProperties());
            actionsJoiner.add(s.securityAction());
            s.buildPasswordCallbackHandler().ifPresent(arg_0 -> ((ImmutableList.Builder)callbackHandlersBuilder).add(arg_0));
        });
        ImmutableList handlers = callbackHandlersBuilder.build();
        if (!handlers.isEmpty()) {
            props.put("passwordCallbackRef", new CompositeCallbackHandler((List<CallbackHandler>)handlers));
        }
        if (StringUtils.isNotBlank((String)(actions = actionsJoiner.toString()))) {
            props.put("action", actions);
        }
        return props;
    }

    private void addRequestInterceptors(Client client) {
        List outInterceptors = client.getOutInterceptors();
        outInterceptors.add(new SoapActionInterceptor());
    }

    private void addResponseInterceptors(Client client, boolean mtomEnabled) {
        List inInterceptors = client.getInInterceptors();
        inInterceptors.add(new NamespaceRestorerStaxInterceptor());
        inInterceptors.add(new NamespaceSaverStaxInterceptor());
        inInterceptors.add(new StreamClosingInterceptor());
        inInterceptors.add(new CheckFaultInterceptor());
        inInterceptors.add(new OutputSoapHeadersInterceptor());
        inInterceptors.add(new SoapActionInterceptor());
        if (mtomEnabled) {
            inInterceptors.add(new OutputMtomSoapAttachmentsInterceptor());
        }
    }

    private void removeUnnecessaryCxfInterceptors(Client client) {
        Binding binding = client.getEndpoint().getBinding();
        this.removeInterceptor(binding.getOutInterceptors(), WrappedOutInterceptor.class.getName());
        this.removeInterceptor(binding.getInInterceptors(), Soap11FaultInInterceptor.class.getName());
        this.removeInterceptor(binding.getInInterceptors(), Soap12FaultInInterceptor.class.getName());
        this.removeInterceptor(binding.getInInterceptors(), CheckFaultInterceptor.class.getName());
    }

    private void removeInterceptor(List<Interceptor<? extends Message>> inInterceptors, String name) {
        inInterceptors.removeIf(i -> i instanceof PhaseInterceptor && ((PhaseInterceptor)i).getId().equals(name));
    }
}

