/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.mule.service.soap.interceptor.MessageDispatcherInterceptor;

final class SoapServiceConduit
extends AbstractConduit {
    private static final Logger LOGGER = Logger.getLogger(SoapServiceConduit.class.getSimpleName());

    SoapServiceConduit(EndpointReferenceType t) {
        super(t);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public void prepare(Message message) throws IOException {
        message.setContent(OutputStream.class, (Object)new ByteArrayOutputStream());
        this.addHeaders(message);
        this.addAttachments(message);
        this.addMessageDispatcher(message);
    }

    private void addMessageDispatcher(Message message) {
        message.getInterceptorChain().add((Interceptor)new MessageDispatcherInterceptor(this.getMessageObserver()));
    }

    private void addAttachments(Message message) {
        Map soapAttachments = (Map)message.getExchange().get((Object)"mule.wsc.attachments");
        message.setAttachments(soapAttachments.values());
    }

    private void addHeaders(Message message) {
        List soapHeaders = (List)message.getExchange().get((Object)"mule.wsc.headers");
        soapHeaders.forEach(header -> ((SoapMessage)message).getHeaders().add(header));
    }

    public void close(Message msg) throws IOException {
        OutputStream os = (OutputStream)msg.getContent(OutputStream.class);
        if (os != null) {
            os.close();
        }
    }
}

