/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.message;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.message.DefaultMultiPartPayload;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.soap.api.message.SoapAttributes;
import org.mule.runtime.soap.api.message.SoapMultipartPayload;
import org.mule.runtime.soap.api.message.SoapResponse;

public final class ImmutableSoapResponse
implements SoapResponse {
    private final InputStream content;
    private final Map<String, String> soapHeaders;
    private final Map<String, String> transportHeaders;
    private final Map<String, SoapAttachment> attachments;
    private final MediaType contentType;

    public ImmutableSoapResponse(InputStream content, Map<String, String> soapHeaders, Map<String, String> transportHeaders, Map<String, SoapAttachment> attachments, MediaType contentType) {
        this.content = content;
        this.soapHeaders = Collections.unmodifiableMap(soapHeaders);
        this.transportHeaders = Collections.unmodifiableMap(transportHeaders);
        this.attachments = Collections.unmodifiableMap(attachments);
        this.contentType = contentType;
    }

    public InputStream getContent() {
        return this.content;
    }

    public Map<String, String> getSoapHeaders() {
        return this.soapHeaders;
    }

    public Map<String, String> getTransportHeaders() {
        return this.transportHeaders;
    }

    public Map<String, SoapAttachment> getAttachments() {
        return this.attachments;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public Result<?, SoapAttributes> getAsResult() {
        SoapAttributes attributes = new SoapAttributes(this.soapHeaders, this.transportHeaders);
        if (this.attachments.isEmpty()) {
            return Result.builder().output((Object)this.content).attributes((Object)attributes).mediaType(this.contentType).build();
        }
        ImmutableList.Builder parts = ImmutableList.builder();
        parts.add((Object)Message.builder().payload((Object)this.content).mediaType(this.contentType).attributes((Object)DefaultMultiPartPayload.BODY_ATTRIBUTES).build());
        this.attachments.forEach((name, attachment) -> parts.add((Object)Message.builder().payload((Object)attachment.getContent()).mediaType(attachment.getContentType()).attributes((Object)new PartAttributes(name)).build()));
        return Result.builder().output((Object)new SoapMultipartPayload((List)parts.build())).attributes((Object)attributes).build();
    }
}

