/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.security.config;

import java.util.Properties;
import org.apache.ws.security.components.crypto.Merlin;
import org.mule.runtime.extension.api.soap.security.config.WssKeyStoreConfiguration;
import org.mule.service.soap.security.config.WssStoreConfigurationPropertiesBuilder;

public class WssKeyStoreConfigurationPropertiesBuilder
implements WssStoreConfigurationPropertiesBuilder {
    private String alias;
    private String keyPassword;
    private String password;
    private String keyStorePath;
    private String type;

    public WssKeyStoreConfigurationPropertiesBuilder(WssKeyStoreConfiguration keyStoreConfiguration) {
        this.alias = keyStoreConfiguration.getAlias();
        this.keyPassword = keyStoreConfiguration.getKeyPassword();
        this.password = keyStoreConfiguration.getPassword();
        this.keyStorePath = keyStoreConfiguration.getStorePath();
        this.type = keyStoreConfiguration.getType();
    }

    @Override
    public Properties getConfigurationProperties() {
        Properties properties = new Properties();
        properties.setProperty("org.apache.ws.security.crypto.provider", Merlin.class.getCanonicalName());
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.type", this.type);
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.password", this.password);
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.alias", this.alias);
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.file", this.keyStorePath);
        if (this.keyPassword != null) {
            properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.private.password", this.keyPassword);
        }
        return properties;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getPassword() {
        return this.password;
    }
}

