/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.client;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.cxf.endpoint.Client;
import org.mule.metadata.xml.XmlTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.soap.api.client.SoapClient;
import org.mule.runtime.soap.api.client.SoapClientConfiguration;
import org.mule.runtime.soap.api.client.SoapClientFactory;
import org.mule.service.soap.client.CxfClientProvider;
import org.mule.service.soap.client.SoapCxfClient;
import org.mule.service.soap.introspection.WsdlIntrospecter;
import org.mule.service.soap.transport.SoapServiceConduitInitiator;

public class SoapCxfClientFactory
implements SoapClientFactory {
    private CxfClientProvider cxfClientProvider = new CxfClientProvider();

    public SoapClient create(SoapClientConfiguration config) throws ConnectionException {
        WsdlIntrospecter introspecter = this.getIntrospecter(config);
        XmlTypeLoader xmlTypeLoader = new XmlTypeLoader(introspecter.getSchemas());
        Client client = this.cxfClientProvider.getClient(config);
        return new SoapCxfClient(client, introspecter, xmlTypeLoader, this.getAddress(config, introspecter), config.getDispatcher(), config.getVersion(), config.getEncoding(), config.isMtomEnabled());
    }

    private String getAddress(SoapClientConfiguration config, WsdlIntrospecter introspecter) throws ConnectionException {
        String address = config.getAddress() != null ? config.getAddress() : this.findAddress(introspecter);
        String protocol = address.substring(0, address.indexOf("://"));
        if (Arrays.stream(SoapServiceConduitInitiator.SOAP_SERVICE_KNOWN_PROTOCOLS).noneMatch(p -> p.startsWith(protocol))) {
            throw new IllegalArgumentException(String.format("cannot create a dispatcher for address [%s], known protocols are [%s]", address, Arrays.stream(SoapServiceConduitInitiator.SOAP_SERVICE_KNOWN_PROTOCOLS).collect(Collectors.joining(", "))));
        }
        return address;
    }

    private WsdlIntrospecter getIntrospecter(SoapClientConfiguration config) throws ConnectionException {
        String wsdlLocation = config.getWsdlLocation();
        WsdlIntrospecter introspecter = new WsdlIntrospecter(wsdlLocation, config.getService(), config.getPort());
        if (introspecter.isRpcStyle()) {
            throw new ConnectionException(String.format("The provided WSDL [%s] is RPC style, RPC WSDLs are not supported", wsdlLocation));
        }
        return introspecter;
    }

    private String findAddress(WsdlIntrospecter wsdlIntrospecter) throws ConnectionException {
        return wsdlIntrospecter.getSoapAddress().orElseThrow(() -> new ConnectionException("No address was specified and no one was found for the given configuration"));
    }
}

