/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.client;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.xml.XmlTypeLoader;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.soap.api.SoapVersion;
import org.mule.runtime.soap.api.client.SoapClient;
import org.mule.runtime.soap.api.client.metadata.SoapMetadataResolver;
import org.mule.runtime.soap.api.exception.BadRequestException;
import org.mule.runtime.soap.api.exception.DispatchingException;
import org.mule.runtime.soap.api.exception.SoapFaultException;
import org.mule.runtime.soap.api.exception.SoapServiceException;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.mule.service.soap.generator.SoapRequestGenerator;
import org.mule.service.soap.generator.SoapResponseGenerator;
import org.mule.service.soap.generator.attachment.AttachmentRequestEnricher;
import org.mule.service.soap.generator.attachment.AttachmentResponseEnricher;
import org.mule.service.soap.generator.attachment.MtomRequestEnricher;
import org.mule.service.soap.generator.attachment.MtomResponseEnricher;
import org.mule.service.soap.generator.attachment.SoapAttachmentRequestEnricher;
import org.mule.service.soap.generator.attachment.SoapAttachmentResponseEnricher;
import org.mule.service.soap.introspection.WsdlIntrospecter;
import org.mule.service.soap.metadata.DefaultSoapMetadataResolver;
import org.mule.service.soap.util.XmlTransformationException;
import org.mule.service.soap.util.XmlTransformationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SoapCxfClient
implements SoapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapCxfClient.class);
    public static final String WSC_DISPATCHER = "mule.wsc.dispatcher";
    public static final String MULE_ATTACHMENTS_KEY = "mule.wsc.attachments";
    public static final String MULE_WSC_ADDRESS = "mule.wsc.address";
    public static final String MULE_HEADERS_KEY = "mule.wsc.headers";
    public static final String MULE_TRANSPORT_HEADERS_KEY = "mule.wsc.transport.headers";
    public static final String MULE_SOAP_ACTION = "mule.wsc.soap.action";
    public static final String MULE_WSC_ENCODING = "mule.wsc.encoding";
    private final SoapRequestGenerator requestGenerator;
    private final SoapResponseGenerator responseGenerator;
    private final Client client;
    private final WsdlIntrospecter introspecter;
    private final XmlTypeLoader loader;
    private final String address;
    private final MessageDispatcher dispatcher;
    private final SoapVersion version;
    private final String encoding;
    private final boolean isMtom;

    SoapCxfClient(Client client, WsdlIntrospecter introspecter, XmlTypeLoader typeLoader, String address, MessageDispatcher dispatcher, SoapVersion version, String encoding, boolean isMtom) {
        this.client = client;
        this.introspecter = introspecter;
        this.loader = typeLoader;
        this.address = address;
        this.dispatcher = dispatcher;
        this.version = version;
        this.isMtom = isMtom;
        this.encoding = encoding;
        this.requestGenerator = new SoapRequestGenerator(this.getRequestEnricher(isMtom), introspecter, this.loader);
        this.responseGenerator = new SoapResponseGenerator(this.getResponseEnricher(isMtom));
    }

    public void stop() throws MuleException {
        this.dispatcher.dispose();
        this.client.destroy();
    }

    public void start() throws MuleException {
        this.dispatcher.initialise();
    }

    public SoapResponse consume(SoapRequest request) throws SoapFaultException {
        XMLStreamReader envelope;
        Map attachments = request.getAttachments();
        String operation = request.getOperation();
        try {
            String xml = request.getContent() != null ? org.apache.commons.io.IOUtils.toString((InputStream)request.getContent()) : null;
            envelope = this.requestGenerator.generate(operation, xml, attachments);
        }
        catch (IOException e) {
            throw new BadRequestException("an error occurred while parsing the provided request");
        }
        ExchangeImpl exchange = new ExchangeImpl();
        Object[] response = this.invoke(operation, envelope, request.getSoapHeaders(), request.getTransportHeaders(), attachments, (Exchange)exchange);
        return this.responseGenerator.generate(operation, response, (Exchange)exchange);
    }

    public SoapMetadataResolver getMetadataResolver() {
        return new DefaultSoapMetadataResolver(this.introspecter, (TypeLoader)this.loader);
    }

    Object[] invoke(String operation, Object payload, Map<String, String> headers, Map<String, String> transportHeaders, Map<String, SoapAttachment> attachments, Exchange exchange) {
        try {
            BindingOperationInfo bop = this.getInvocationOperation();
            Map<String, Attachment> soapAttachments = this.transformToCxfAttachments(attachments);
            List<SoapHeader> soapHeaders = this.transformToCxfHeaders(headers);
            Map<String, Object> ctx = this.getInvocationContext(operation, soapHeaders, transportHeaders, soapAttachments);
            return this.client.invoke(bop, new Object[]{payload}, ctx, exchange);
        }
        catch (SoapFault sf) {
            throw new SoapFaultException(sf.getFaultCode(), sf.getSubCode(), (String)this.parseExceptionDetail(sf.getDetail()).orElse(null), sf.getReason(), sf.getNode(), sf.getRole(), (Throwable)sf);
        }
        catch (Fault f) {
            if (f.getMessage().contains("COULD_NOT_READ_XML")) {
                throw new BadRequestException(String.format("Error consuming the operation [%s], the request body is not a valid XML", operation));
            }
            throw new SoapFaultException(f.getFaultCode(), (String)this.parseExceptionDetail(f.getDetail()).orElse(null), (Throwable)f);
        }
        catch (DispatchingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SoapServiceException(String.format("An unexpected error occur while consuming the [%s] web service operation", operation), (Throwable)e);
        }
    }

    private BindingOperationInfo getInvocationOperation() throws Exception {
        Endpoint ep = this.client.getEndpoint();
        QName q = new QName(ep.getService().getName().getNamespaceURI(), "invoke");
        BindingOperationInfo bop = ep.getBinding().getBindingInfo().getOperation(q);
        if (bop.isUnwrappedCapable()) {
            bop = bop.getUnwrappedOperation();
        }
        return bop;
    }

    private Map<String, Object> getInvocationContext(String operation, List<SoapHeader> headers, Map<String, String> transportHeaders, Map<String, Attachment> attachments) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.isMtom) {
            props.put(MULE_ATTACHMENTS_KEY, attachments);
        } else {
            props.put(MULE_ATTACHMENTS_KEY, Collections.emptyMap());
        }
        props.put(MULE_WSC_ADDRESS, this.address);
        props.put(MULE_WSC_ENCODING, this.encoding);
        props.put(MULE_HEADERS_KEY, headers);
        if (this.version == SoapVersion.SOAP12) {
            props.put(MULE_SOAP_ACTION, operation);
        }
        props.put(MULE_TRANSPORT_HEADERS_KEY, transportHeaders != null ? transportHeaders : Collections.emptyMap());
        props.put(WSC_DISPATCHER, this.dispatcher);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("RequestContext", props);
        return ctx;
    }

    private List<SoapHeader> transformToCxfHeaders(Map<String, String> headers) {
        if (headers == null) {
            return Collections.emptyList();
        }
        return headers.entrySet().stream().map(header -> {
            try {
                return new SoapHeader(new QName(null, (String)header.getKey()), (Object)XmlTransformationUtils.stringToDomElement((String)header.getValue()));
            }
            catch (Exception e) {
                throw new BadRequestException("Cannot parse input header [" + (String)header.getKey() + "]", (Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    private Map<String, Attachment> transformToCxfAttachments(Map<String, SoapAttachment> attachments) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        attachments.forEach((name, value) -> {
            try {
                builder.put(name, (Object)new AttachmentImpl(name, IOUtils.toDataHandler((String)name, (Object)value.getContent(), (MediaType)value.getContentType())));
            }
            catch (IOException e) {
                throw new BadRequestException(String.format("Error while preparing attachment [%s] for upload", name), (Throwable)e);
            }
        });
        return builder.build();
    }

    private AttachmentRequestEnricher getRequestEnricher(boolean isMtom) {
        return isMtom ? new MtomRequestEnricher(this.introspecter, (TypeLoader)this.loader) : new SoapAttachmentRequestEnricher(this.introspecter, (TypeLoader)this.loader);
    }

    private AttachmentResponseEnricher getResponseEnricher(boolean isMtom) {
        return isMtom ? new MtomResponseEnricher(this.introspecter, (TypeLoader)this.loader) : new SoapAttachmentResponseEnricher(this.introspecter, (TypeLoader)this.loader);
    }

    private Optional<String> parseExceptionDetail(Element detail) {
        try {
            return Optional.ofNullable(XmlTransformationUtils.nodeToString(detail));
        }
        catch (XmlTransformationException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error while parsing Soap Exception detail: " + detail.toString(), (Throwable)e);
            }
            return Optional.empty();
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

