/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.introspection;

import com.ibm.wsdl.extensions.schema.SchemaSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.runtime.soap.api.exception.InvalidWsdlException;
import org.mule.runtime.soap.api.transport.NullTransportResourceLocator;
import org.mule.runtime.soap.api.transport.TransportResourceLocator;
import org.mule.service.soap.introspection.OperationDefinition;
import org.mule.service.soap.introspection.WsdlLocator;
import org.mule.service.soap.introspection.WsdlSchemasCollector;

public class ServiceDefinition {
    private static final String DOCUMENT_STYLE = "document";
    private static final String RPC_STYLE = "rpc";
    private final WsdlSchemasCollector schemaCollector;
    private final Definition definition;
    private final Service service;
    private final Port port;
    private final Map<String, OperationDefinition> operations;

    public ServiceDefinition(String wsdlLocation, String serviceName, String portName) {
        this(wsdlLocation, serviceName, portName, (TransportResourceLocator)new NullTransportResourceLocator());
    }

    public ServiceDefinition(String wsdlLocation, String serviceName, String portName, TransportResourceLocator locator) {
        this.validateBlankString(wsdlLocation, "WSDL Location");
        this.validateNotNull(locator, "ResourceLocator cannot be null");
        this.definition = this.parseWsdl(new WsdlLocator(wsdlLocation, locator));
        this.service = this.findService(serviceName);
        this.port = this.findPort(portName);
        this.schemaCollector = new WsdlSchemasCollector(this.definition);
        this.operations = this.findOperations();
    }

    private Service findService(String serviceName) {
        this.validateBlankString(serviceName, "service name");
        Service service = this.definition.getService(new QName(this.definition.getTargetNamespace(), serviceName));
        this.validateNotNull(service, "The service name [" + serviceName + "] was not found in the current wsdl file.");
        return service;
    }

    private Port findPort(String portName) {
        this.validateBlankString(portName, "port name");
        Port port = this.service.getPort(portName.trim());
        this.validateNotNull(port, "The port name [" + portName + "] was not found in the current wsdl file.");
        return port;
    }

    private Map<String, OperationDefinition> findOperations() {
        List ops = this.port.getBinding().getBindingOperations();
        return ops.stream().map(bop -> new OperationDefinition((BindingOperation)bop)).collect(Collectors.toMap(o -> o.getName(), o -> o));
    }

    public List<OperationDefinition> getOperations() {
        return new ArrayList<OperationDefinition>(this.operations.values());
    }

    public OperationDefinition getOperation(String operationName) {
        this.validateBlankString(operationName, "operation name");
        OperationDefinition operation = this.operations.get(operationName);
        this.validateNotNull(operation, "The operation name [" + operationName + "] was not found in the current wsdl file.");
        return operation;
    }

    public Fault getFault(Operation operation, String faultName) {
        this.validateBlankString(faultName, "fault name");
        Fault fault = operation.getFault(faultName);
        this.validateNotNull(fault, "The fault name [" + faultName + "] was not found in the current wsdl file.");
        return fault;
    }

    public Message getMessage(QName qName) {
        return this.definition.getMessage(qName);
    }

    public SchemaCollector getSchemas() {
        return this.schemaCollector.collect();
    }

    public Service getService() {
        return this.service;
    }

    public Port getPort() {
        return this.port;
    }

    public Optional<String> getSoapAddress() {
        String address = null;
        if (this.port != null) {
            for (Object element : this.port.getExtensibilityElements()) {
                if (element instanceof SOAPAddress) {
                    address = ((SOAPAddress)element).getLocationURI();
                    break;
                }
                if (element instanceof SOAP12Address) {
                    address = ((SOAP12Address)element).getLocationURI();
                    break;
                }
                if (!(element instanceof HTTPAddress)) continue;
                address = ((HTTPAddress)element).getLocationURI();
                break;
            }
        }
        return Optional.ofNullable(address);
    }

    public boolean isRpcStyle() {
        return this.isWsdlStyle(RPC_STYLE);
    }

    public boolean isDocumentStyle() {
        return this.isWsdlStyle(DOCUMENT_STYLE);
    }

    private boolean isWsdlStyle(String style) {
        List elements = this.port.getBinding().getExtensibilityElements();
        Optional<Object> bindingStyle = elements.stream().filter(e -> e instanceof SOAP12Binding || e instanceof SOAPBinding).map(e -> e instanceof SOAP12Binding ? ((SOAP12Binding)e).getStyle() : ((SOAPBinding)e).getStyle()).filter(Objects::nonNull).findAny();
        List bindingOperations = this.port.getBinding().getBindingOperations();
        if (!bindingStyle.isPresent() && !bindingOperations.isEmpty()) {
            BindingOperation bop = (BindingOperation)bindingOperations.get(0);
            bindingStyle = bop.getExtensibilityElements().stream().filter(e -> e instanceof SOAP12Operation || e instanceof SOAPOperation).map(e -> e instanceof SOAPOperation ? ((SOAPOperation)e).getStyle() : ((SOAP12Operation)e).getStyle()).filter(Objects::nonNull).findAny();
        }
        return ((String)bindingStyle.orElse(DOCUMENT_STYLE)).equalsIgnoreCase(style);
    }

    private Definition parseWsdl(WSDLLocator locator) {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            ExtensionRegistry registry = this.initExtensionRegistry(factory);
            WSDLReader wsdlReader = factory.newWSDLReader();
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            wsdlReader.setExtensionRegistry(registry);
            return wsdlReader.readWSDL(locator);
        }
        catch (WSDLException e) {
            throw new InvalidWsdlException(String.format("Error processing WSDL file [%s]: %s", locator.getBaseURI(), e.getMessage()), (Throwable)e);
        }
    }

    private ExtensionRegistry initExtensionRegistry(WSDLFactory factory) throws WSDLException {
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        registry.registerSerializer(Types.class, new QName("http://www.w3.org/2001/XMLSchema", "schema"), (ExtensionSerializer)new SchemaSerializer());
        QName header = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
        registry.registerDeserializer(MIMEPart.class, header, registry.queryDeserializer(BindingInput.class, header));
        registry.registerSerializer(MIMEPart.class, header, registry.querySerializer(BindingInput.class, header));
        Class<?> clazz = registry.createExtension(BindingInput.class, header).getClass();
        registry.mapExtensionTypes(MIMEPart.class, header, clazz);
        return registry;
    }

    private void validateNotNull(Object paramValue, String errorMessage) {
        if (paramValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void validateBlankString(String paramValue, String paramName) {
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            throw new IllegalArgumentException("The [" + paramName + "] can not be blank nor null.");
        }
    }
}

