/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.interceptor;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import javax.activation.DataHandler;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.soap.SoapAttachment;

public class OutputMtomSoapAttachmentsInterceptor
extends AbstractPhaseInterceptor<Message> {
    public OutputMtomSoapAttachmentsInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(Message message) throws Fault {
        ImmutableMap.Builder result = ImmutableMap.builder();
        Collection attachments = message.getAttachments();
        if (attachments != null && !attachments.isEmpty()) {
            attachments.forEach(a -> result.put((Object)this.getName((Attachment)a), (Object)this.getSoapAttachment((Attachment)a)));
        }
        message.getExchange().put((Object)"mule.wsc.attachments", (Object)result.build());
    }

    private String getName(Attachment attachment) {
        DataHandler dataHandler = attachment.getDataHandler();
        return dataHandler.getName() != null ? dataHandler.getName() : attachment.getId();
    }

    private SoapAttachment getSoapAttachment(Attachment attachment) {
        DataHandler dataHandler = attachment.getDataHandler();
        try {
            MediaType contentType = MediaType.parse((String)dataHandler.getContentType());
            return new SoapAttachment(dataHandler.getInputStream(), contentType);
        }
        catch (IOException e) {
            throw new SoapFault("Error copying received attachment [" + this.getName(attachment) + "]", (Throwable)e, Fault.FAULT_CODE_SERVER);
        }
    }
}

