/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.client;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.cxf.endpoint.Client;
import org.mule.metadata.xml.XmlTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.soap.api.client.SoapClient;
import org.mule.runtime.soap.api.client.SoapClientConfiguration;
import org.mule.runtime.soap.api.client.SoapClientFactory;
import org.mule.service.soap.client.CxfClientProvider;
import org.mule.service.soap.client.SoapCxfClient;
import org.mule.service.soap.conduit.SoapServiceConduitInitiator;
import org.mule.service.soap.introspection.WsdlDefinition;

public class SoapCxfClientFactory
implements SoapClientFactory {
    private CxfClientProvider cxfClientProvider = new CxfClientProvider();

    public SoapClient create(SoapClientConfiguration config) throws ConnectionException {
        WsdlDefinition definition = this.getWsdlDefinition(config);
        XmlTypeLoader xmlTypeLoader = new XmlTypeLoader(definition.getSchemas());
        Client client = this.cxfClientProvider.getClient(config);
        return new SoapCxfClient(client, definition, xmlTypeLoader, this.getAddress(config, definition), config.getDispatcher(), config.getVersion(), config.getEncoding(), config.isMtomEnabled());
    }

    private String getAddress(SoapClientConfiguration config, WsdlDefinition definition) throws ConnectionException {
        String protocolSeparator;
        String address = config.getAddress() != null ? config.getAddress() : this.findAddress(definition);
        if (address.contains(protocolSeparator = "://")) {
            String protocol = address.substring(0, address.indexOf(protocolSeparator));
            if (Arrays.stream(SoapServiceConduitInitiator.SOAP_SERVICE_KNOWN_PROTOCOLS).noneMatch(p -> p.startsWith(protocol))) {
                throw new IllegalArgumentException(String.format("cannot create a dispatcher for address [%s], known protocols are [%s]", address, Arrays.stream(SoapServiceConduitInitiator.SOAP_SERVICE_KNOWN_PROTOCOLS).collect(Collectors.joining(", "))));
            }
        }
        return address;
    }

    private WsdlDefinition getWsdlDefinition(SoapClientConfiguration config) throws ConnectionException {
        String wsdlLocation = config.getWsdlLocation();
        WsdlDefinition definition = new WsdlDefinition(wsdlLocation, config.getService(), config.getPort(), config.getLocator());
        if (definition.isRpcStyle()) {
            throw new ConnectionException(String.format("The provided WSDL [%s] is RPC style, RPC WSDLs are not supported", wsdlLocation));
        }
        return definition;
    }

    private String findAddress(WsdlDefinition wsdldefinition) throws ConnectionException {
        return wsdldefinition.getSoapAddress().orElseThrow(() -> new ConnectionException("No address was specified and no one was found for the given configuration"));
    }
}

