/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collections;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.runtime.soap.api.exception.BadRequestException;
import org.mule.runtime.soap.api.exception.InvalidWsdlException;
import org.mule.service.soap.SoapTestUtils;
import org.mule.service.soap.generator.AbstractEnricherTestCase;
import org.mule.service.soap.generator.EmptyRequestGenerator;
import org.mule.service.soap.introspection.OperationDefinition;
import org.mule.service.soap.introspection.ServiceDefinition;

@Feature(value="WSC Extension")
@Story(value="Request Generation")
public class EmptyRequestGeneratorTestCase
extends AbstractEnricherTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private EmptyRequestGenerator generator;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.generator = new EmptyRequestGenerator(this.definition, this.loader);
    }

    @Test
    @Description(value="Checks the generation of a body request for an operation that don't require any parameters")
    public void noParams() throws Exception {
        String request = this.generator.generateRequest("noParams");
        SoapTestUtils.assertSimilarXml(request, this.testValues.getNoParamsRequest());
    }

    @Test
    @Description(value="Checks that the generation of a body request for an operation that require parameters fails")
    public void withParams() throws Exception {
        this.exception.expect(BadRequestException.class);
        this.exception.expectMessage("Cannot build default body request for operation [echo], the operation requires input parameters");
        this.generator.generateRequest("echo");
    }

    @Test
    @Description(value="Checks that the generation of a body request for an operation without a body part fails")
    public void noBodyPart() throws Exception {
        this.exception.expect(InvalidWsdlException.class);
        this.exception.expectMessage("No SOAP body defined in the WSDL for the specified operation");
        ServiceDefinition definition = (ServiceDefinition)Mockito.mock(ServiceDefinition.class);
        BindingOperation bop = (BindingOperation)Mockito.mock(BindingOperation.class);
        BindingInput bi = (BindingInput)Mockito.mock(BindingInput.class);
        Mockito.when((Object)bi.getExtensibilityElements()).thenReturn(Collections.emptyList());
        Mockito.when((Object)bop.getBindingInput()).thenReturn((Object)bi);
        OperationDefinition operationDefinition = (OperationDefinition)Mockito.mock(OperationDefinition.class);
        Mockito.when((Object)operationDefinition.getBindingOperation()).thenReturn((Object)bop);
        Mockito.when((Object)definition.getOperation(Matchers.anyString())).thenReturn((Object)operationDefinition);
        EmptyRequestGenerator emptyRequestGenerator = new EmptyRequestGenerator(definition, this.loader);
        emptyRequestGenerator.generateRequest("fail");
    }
}

