/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator;

import io.qameta.allure.Description;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.junit.Test;
import org.mule.service.soap.SoapTestUtils;
import org.mule.service.soap.generator.AbstractEnricherTestCase;
import org.mule.service.soap.generator.attachment.AttachmentResponseEnricher;
import org.mule.service.soap.util.XmlTransformationUtils;
import org.w3c.dom.Document;

abstract class ResponseEnricherTestCase
extends AbstractEnricherTestCase {
    ResponseEnricherTestCase() {
    }

    @Test
    @Description(value="Enrich a response that contains attachments")
    public void enrich() throws Exception {
        ExchangeImpl exchange = new ExchangeImpl();
        Document doc = XmlTransformationUtils.stringToDocument((String)this.getResponse());
        AttachmentResponseEnricher enricher = this.getEnricher();
        String result = enricher.enrich(doc, "downloadAttachment", (Exchange)exchange);
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), result);
        this.assertAttachment((Exchange)exchange);
    }

    protected abstract AttachmentResponseEnricher getEnricher();

    protected abstract String getResponse();

    protected abstract void assertAttachment(Exchange var1);
}

