/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.introspection;

import java.io.File;
import java.net.URISyntaxException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.soap.api.exception.InvalidWsdlException;
import org.mule.runtime.soap.api.transport.TransportResourceLocator;
import org.mule.service.soap.introspection.HttpBasicAuthResourceLocator;
import org.mule.service.soap.introspection.ServiceDefinition;
import org.mule.service.soap.server.BasicAuthHttpServer;
import org.mule.service.soap.service.Soap11Service;
import org.mule.tck.junit4.rule.DynamicPort;

public class WsdlDefinitionTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public DynamicPort port = new DynamicPort("testPort");

    @Test
    public void getWsdlStyleFromOperations() throws URISyntaxException {
        String resourceLocation = this.getResourceLocation("wsdl/document.wsdl");
        ServiceDefinition definition = new ServiceDefinition(resourceLocation, "Dilbert", "DilbertSoap");
        MatcherAssert.assertThat((Object)definition.isDocumentStyle(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void getWsdlStyleDefault() throws URISyntaxException {
        String resourceLocation = this.getResourceLocation("wsdl/no-style-defined.wsdl");
        ServiceDefinition definition = new ServiceDefinition(resourceLocation, "messagingService", "messagingPort");
        MatcherAssert.assertThat((Object)definition.isDocumentStyle(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void getWsdlStyleFromBinding() throws URISyntaxException {
        String resourceLocation = this.getResourceLocation("wsdl/rpc.wsdl");
        ServiceDefinition definition = new ServiceDefinition(resourceLocation, "SoapResponder", "SoapResponderPortType");
        MatcherAssert.assertThat((Object)definition.isRpcStyle(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void cannotAccess() throws Exception {
        this.expectedException.expect(InvalidWsdlException.class);
        this.expectedException.expectMessage("faultCode=OTHER_ERROR: Unable to locate document at");
        BasicAuthHttpServer server = new BasicAuthHttpServer(this.port.getNumber(), null, null, new Soap11Service());
        String resourceLocation = server.getDefaultAddress() + "?wsdl";
        new ServiceDefinition(resourceLocation, "TestService", "TestPort");
        server.stop();
    }

    @Test
    public void protectedWsdl() throws Exception {
        BasicAuthHttpServer server = new BasicAuthHttpServer(this.port.getNumber(), null, null, new Soap11Service());
        HttpBasicAuthResourceLocator resourceLocator = new HttpBasicAuthResourceLocator();
        resourceLocator.start();
        String resourceLocation = server.getDefaultAddress() + "?wsdl";
        ServiceDefinition definition = new ServiceDefinition(resourceLocation, "TestService", "TestPort", (TransportResourceLocator)resourceLocator);
        resourceLocator.stop();
        server.stop();
        MatcherAssert.assertThat((Object)definition.isDocumentStyle(), (Matcher)Is.is((Object)true));
    }

    private String getResourceLocation(String name) throws URISyntaxException {
        return new File(Thread.currentThread().getContextClassLoader().getResource(name).toURI()).getPath();
    }
}

