/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.introspection;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.service.soap.SoapTestUtils;
import org.mule.service.soap.introspection.ServiceDefinition;

public class WsdlSchemasCollectorTestCase {
    private static final String RECURSIVE_WSDL_FOLDER = "wsdl/recursive/";

    @Test
    public void wsdlWithEmbeddedTypeSchema() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL wsdl = cl.getResource("wsdl/simple-service.wsdl");
        ServiceDefinition definition = new ServiceDefinition(wsdl.getPath(), "TestService", "TestPort");
        Map schemas = definition.getSchemas().collect();
        MatcherAssert.assertThat((Object)schemas.size(), (Matcher)Is.is((Object)1));
        String expected = IOUtils.toString((InputStream)cl.getResource("schemas/simple-service-types.xsd").openStream());
        String result = IOUtils.toString((InputStream)((InputStream)schemas.entrySet().iterator().next().getValue()));
        SoapTestUtils.assertSimilarXml(expected, result);
    }

    @Test
    public void wsdlWithLocalRecursiveSchemas() throws Exception {
        String wsdl = this.getResourceLocation("wsdl/recursive/main.wsdl");
        ServiceDefinition definition = new ServiceDefinition(wsdl, "RecursiveService", "RecursivePort");
        Map schemas = definition.getSchemas().collect();
        MatcherAssert.assertThat(schemas.values(), (Matcher)Matchers.hasSize((int)6));
    }

    @Test
    public void wsdlWithSchemaThatDoesNotHaveALocation() throws Exception {
        String wsdl = this.getResourceLocation("wsdl/no-schema-location/test.wsdl");
        ServiceDefinition definition = new ServiceDefinition(wsdl, "service", "BasicHttpBinding_IOrderService");
        Map schemas = definition.getSchemas().collect();
        MatcherAssert.assertThat(schemas.entrySet(), (Matcher)Matchers.hasSize((int)4));
    }

    @Test
    public void multipleSchemasInTypesTag() throws MetadataResolvingException {
        String wsdl = this.getResourceLocation("wsdl/types-multiple-schema.wsdl");
        ServiceDefinition definition = new ServiceDefinition(wsdl, "TService", "TPort");
        Set schemas = definition.getSchemas().collect().keySet();
        MatcherAssert.assertThat(schemas, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat(schemas, (Matcher)Matchers.hasItems((Object[])new String[]{"http://www.test.com/schemas/FirstInterface", "http://www.test.com/schemas/SecondInterface"}));
    }

    private String getResourceLocation(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name).getFile();
    }
}

