/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.runtime;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.extension.api.soap.message.DispatchingRequest;
import org.mule.runtime.extension.api.soap.message.DispatchingResponse;
import org.mule.runtime.extension.api.soap.message.MessageDispatcher;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.mule.service.soap.AbstractSoapServiceTestCase;
import org.mule.service.soap.SoapTestUtils;
import org.mule.service.soap.client.TestSoapClient;

public class CustomDispatcherTestCase
extends AbstractSoapServiceTestCase {
    private static final String RESPONSE = "<text>RESPONSE</text>";

    @Test
    public void customDispatcher() throws Exception {
        SoapResponse response = this.getTestClient().consume(SoapRequest.empty((String)"noParams"));
        SoapTestUtils.assertSimilarXml(RESPONSE, response.getContent());
    }

    @Test
    public void transportHeaders() {
        ImmutableMap headers = ImmutableMap.builder().put((Object)"H1", (Object)"H1Value").put((Object)"H2", (Object)"H2Value").build();
        SoapResponse response = this.getTestClient().consume((SoapRequest)SoapRequest.builder().operation("noParams").transportHeaders((Map)headers).build());
        response.getTransportHeaders().forEach((arg_0, arg_1) -> CustomDispatcherTestCase.lambda$transportHeaders$0((Map)headers, arg_0, arg_1));
    }

    private TestSoapClient getTestClient() {
        return new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).withVersion(this.soapVersion).withDispatcher((MessageDispatcher)new TestDispatcher()).build());
    }

    private static /* synthetic */ void lambda$transportHeaders$0(Map headers, String k, String v) {
        Assert.assertThat((Object)headers.containsKey(k), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)headers.containsValue(v), (Matcher)Is.is((Object)true));
    }

    public class TestDispatcher
    implements MessageDispatcher {
        public DispatchingResponse dispatch(DispatchingRequest request) {
            String envelope = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"><s:Body><text>RESPONSE</text></s:Body></s:Envelope>";
            return new DispatchingResponse((InputStream)new ByteArrayInputStream(envelope.getBytes()), request.getHeaders());
        }
    }
}

