/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator.attachment;

import java.util.List;
import javax.wsdl.Part;
import org.apache.cxf.message.Exchange;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.runtime.soap.api.exception.InvalidWsdlException;
import org.mule.service.soap.introspection.ServiceDefinition;
import org.mule.service.soap.util.SoapServiceMetadataTypeUtils;
import org.mule.service.soap.xml.util.XMLUtils;
import org.w3c.dom.Document;

public abstract class AttachmentResponseEnricher {
    private final ServiceDefinition definition;
    private final TypeLoader loader;

    protected AttachmentResponseEnricher(ServiceDefinition definition, TypeLoader loader) {
        this.definition = definition;
        this.loader = loader;
    }

    public String enrich(Document response, String operation, Exchange exchange) {
        Part outputPart = this.definition.getOperation(operation).getOutputBodyPart().orElseThrow(() -> new InvalidWsdlException(String.format("Cannot find output body part for operation [%s] in the configured WSDL", operation)));
        String part = outputPart.getElementName().toString();
        MetadataType outputBodyType = (MetadataType)this.loader.load(part).orElseThrow(() -> new InvalidWsdlException(String.format("Cannot found output part [%s] for operation [%s] in the configured WSDL", part, operation)));
        List<ObjectFieldType> attachmentParams = SoapServiceMetadataTypeUtils.getAttachmentFields(outputBodyType);
        if (!attachmentParams.isEmpty()) {
            this.processResponseAttachments(response, attachmentParams, exchange);
        }
        return XMLUtils.toXml(response);
    }

    protected abstract void processResponseAttachments(Document var1, List<ObjectFieldType> var2, Exchange var3);
}

