/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.introspection;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Header;
import org.mule.service.soap.introspection.SoapHeaderAdapter;

public class OperationDefinition {
    private final BindingOperation bindingOperation;
    private final Operation operation;

    OperationDefinition(BindingOperation bop) {
        this.bindingOperation = bop;
        this.operation = bop.getOperation();
    }

    public Message getInputMessage() {
        return this.operation.getInput().getMessage();
    }

    public Message getOutputMessage() {
        return this.operation.getOutput().getMessage();
    }

    public Optional<Part> getInputBodyPart() {
        return this.getBodyPart(this.getInputMessage(), (ElementExtensible)this.bindingOperation.getBindingInput());
    }

    public Optional<Part> getOutputBodyPart() {
        return this.getBodyPart(this.getOutputMessage(), (ElementExtensible)this.bindingOperation.getBindingOutput());
    }

    public List<SoapHeaderAdapter> getInputHeaders() {
        return this.getHeaderParts((ElementExtensible)this.bindingOperation.getBindingInput());
    }

    public List<SoapHeaderAdapter> getOutputHeaders() {
        return this.getHeaderParts((ElementExtensible)this.bindingOperation.getBindingOutput());
    }

    public String getName() {
        return this.operation.getName();
    }

    public OperationType getType() {
        return this.operation.getStyle();
    }

    private Optional<Part> getBodyPart(Message message, ElementExtensible bindingType) {
        Map parts = message.getParts();
        if (parts == null || parts.isEmpty()) {
            return Optional.empty();
        }
        if (parts.size() == 1) {
            return Optional.ofNullable((Part)parts.get(parts.keySet().toArray()[0]));
        }
        return this.getBodyPartName(bindingType).flatMap(partName -> Optional.ofNullable((Part)parts.get(partName)));
    }

    private Optional<String> getBodyPartName(ElementExtensible bindingType) {
        Optional<Object> bodyParts;
        List elements = bindingType.getExtensibilityElements();
        if (elements != null && (bodyParts = elements.stream().filter(e -> e instanceof SOAPBody || e instanceof SOAP12Body).map(e -> e instanceof SOAPBody ? ((SOAPBody)e).getParts() : ((SOAP12Body)e).getParts()).map(parts -> parts == null ? Collections.emptyList() : parts).findFirst()).isPresent() && !((List)bodyParts.get()).isEmpty()) {
            return Optional.ofNullable((String)((List)bodyParts.get()).get(0));
        }
        return Optional.empty();
    }

    List<SoapHeaderAdapter> getHeaderParts(ElementExtensible bindingType) {
        List extensible = bindingType.getExtensibilityElements();
        if (extensible != null) {
            return extensible.stream().filter(e -> e instanceof SOAPHeader || e instanceof SOAP12Header).map(e -> e instanceof SOAPHeader ? new SoapHeaderAdapter((SOAPHeader)e) : new SoapHeaderAdapter((SOAP12Header)e)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public BindingOperation getBindingOperation() {
        return this.bindingOperation;
    }
}

