/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.message;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.extension.api.soap.SoapAttributes;
import org.mule.runtime.extension.api.soap.SoapOutputPayload;
import org.mule.runtime.soap.api.message.SoapResponse;

public final class ImmutableSoapResponse
implements SoapResponse {
    private final InputStream content;
    private final Map<String, String> soapHeaders;
    private final Map<String, String> transportHeaders;
    private final Map<String, SoapAttachment> attachments;
    private final MediaType contentType;

    public ImmutableSoapResponse(InputStream content, Map<String, String> soapHeaders, Map<String, String> transportHeaders, Map<String, SoapAttachment> attachments, MediaType contentType) {
        this.content = content;
        this.soapHeaders = Collections.unmodifiableMap(soapHeaders);
        this.transportHeaders = Collections.unmodifiableMap(transportHeaders);
        this.attachments = Collections.unmodifiableMap(attachments);
        this.contentType = contentType;
    }

    public InputStream getContent() {
        return this.content;
    }

    public Map<String, String> getSoapHeaders() {
        return this.soapHeaders;
    }

    public Map<String, String> getTransportHeaders() {
        return this.transportHeaders;
    }

    public Map<String, SoapAttachment> getAttachments() {
        return this.attachments;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public Result<SoapOutputPayload, SoapAttributes> getAsResult(StreamingHelper helper) {
        return Result.builder().output((Object)new SoapOutputPayload(this.wrapBody(this.content, helper), this.wrapAttachments(this.attachments, helper), this.soapHeaders)).attributes((Object)new SoapAttributes(this.transportHeaders)).build();
    }

    private TypedValue<InputStream> wrapBody(InputStream body, StreamingHelper helper) {
        return new TypedValue(helper.resolveCursorProvider((Object)body), DataType.builder().type(InputStream.class).mediaType(MediaType.XML).build());
    }

    private Map<String, TypedValue<InputStream>> wrapAttachments(Map<String, SoapAttachment> attachments, StreamingHelper helper) {
        ImmutableMap.Builder wrapped = ImmutableMap.builder();
        attachments.forEach((k, v) -> wrapped.put(k, (Object)new TypedValue(helper.resolveCursorProvider((Object)v.getContent()), DataType.builder().type(InputStream.class).mediaType(v.getContentType()).build())));
        return wrapped.build();
    }
}

